/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;

public class GVUeb
extends AbstractHBCIJob {
    public GVUeb(HBCIPassportInternal passport, String name) {
        super(passport, name, new HBCIJobResultImpl(passport));
    }

    public GVUeb(HBCIPassportInternal passport) {
        this(passport, GVUeb.getLowlevelName());
        this.addConstraint("src.country", "My.KIK.country", "DE");
        this.addConstraint("src.blz", "My.KIK.blz", null);
        this.addConstraint("src.number", "My.number", null);
        this.addConstraint("src.subnumber", "My.subnumber", "");
        this.addConstraint("dst.country", "Other.KIK.country", "DE");
        this.addConstraint("dst.blz", "Other.KIK.blz", null);
        this.addConstraint("dst.number", "Other.number", null);
        this.addConstraint("dst.subnumber", "Other.subnumber", "");
        this.addConstraint("btg.value", "BTG.value", null);
        this.addConstraint("btg.curr", "BTG.curr", null);
        this.addConstraint("name", "name", null);
        this.addConstraint("name2", "name2", "");
        this.addConstraint("key", "key", "51");
        HashMap<String, String> parameters = this.getJobRestrictions();
        int maxusage = Integer.parseInt(parameters.get("maxusage"));
        for (int i = 0; i < maxusage; ++i) {
            String name = HBCIUtils.withCounter("usage", i);
            this.addConstraint(name, "usage." + name, "");
        }
    }

    public static String getLowlevelName() {
        return "Ueb";
    }

    @Override
    public void setParam(String paramName, String value) {
        HashMap<String, String> res = this.getJobRestrictions();
        if (paramName.equals("key")) {
            String st;
            boolean atLeastOne = false;
            boolean found = false;
            int i = 0;
            while ((st = res.get(HBCIUtils.withCounter("key", i))) != null) {
                atLeastOne = true;
                if (st.equals(value)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (atLeastOne && !found) {
                String msg = HBCIUtils.getLocMsg("EXCMSG_INV_KEY", value);
                throw new InvalidUserDataException(msg);
            }
        }
        super.setParam(paramName, value);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("src");
        this.checkAccountCRC("dst");
    }
}

