/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.text.DecimalFormat;
import java.util.HashMap;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV_Result.GVRDauerEdit;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVDauerSEPAEdit
extends AbstractSEPAGV {
    private static final SepaVersion DEFAULT = SepaVersion.PAIN_001_001_02;

    public GVDauerSEPAEdit(HBCIPassportInternal passport) {
        super(passport, GVDauerSEPAEdit.getLowlevelName(), new GVRDauerEdit(passport));
        this.addConstraint("src.bic", "My.bic", null);
        this.addConstraint("src.iban", "My.iban", null);
        if (this.canNationalAcc(passport)) {
            this.addConstraint("src.country", "My.KIK.country", "");
            this.addConstraint("src.blz", "My.KIK.blz", "");
            this.addConstraint("src.number", "My.number", "");
            this.addConstraint("src.subnumber", "My.subnumber", "");
        }
        this.addConstraint("_sepadescriptor", "sepadescr", this.getPainVersion().getURN());
        this.addConstraint("_sepapain", "sepapain", null);
        this.addConstraint("orderid", "orderid", null);
        this.addConstraint("src.bic", "sepa.src.bic", null);
        this.addConstraint("src.iban", "sepa.src.iban", null);
        this.addConstraint("src.name", "sepa.src.name", null);
        this.addConstraint("dst.bic", "sepa.dst.bic", null);
        this.addConstraint("dst.iban", "sepa.dst.iban", null);
        this.addConstraint("dst.name", "sepa.dst.name", null);
        this.addConstraint("btg.value", "sepa.btg.value", null);
        this.addConstraint("btg.curr", "sepa.btg.curr", "EUR");
        this.addConstraint("usage", "sepa.usage", "");
        this.addConstraint("date", "date", "");
        this.addConstraint("sepaid", "sepa.sepaid", this.getPainMessageId());
        this.addConstraint("pmtinfid", "sepa.pmtinfid", this.getPainMessageId());
        this.addConstraint("endtoendid", "sepa.endtoendid", "NOTPROVIDED");
        this.addConstraint("purposecode", "sepa.purposecode", "");
        this.addConstraint("firstdate", "DauerDetails.firstdate", null);
        this.addConstraint("timeunit", "DauerDetails.timeunit", null);
        this.addConstraint("turnus", "DauerDetails.turnus", null);
        this.addConstraint("execday", "DauerDetails.execday", null);
        this.addConstraint("lastdate", "DauerDetails.lastdate", "");
    }

    public static String getLowlevelName() {
        return "DauerSEPAEdit";
    }

    @Override
    protected SepaVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.PAIN_001;
    }

    @Override
    public void setParam(String paramName, String value) {
        String timeunit;
        HashMap<String, String> res = this.getJobRestrictions();
        if (paramName.equals("timeunit")) {
            if (!value.equals("W") && !value.equals("M")) {
                String msg = HBCIUtils.getLocMsg("EXCMSG_INV_TIMEUNIT", value);
                throw new InvalidUserDataException(msg);
            }
        } else if (paramName.equals("turnus")) {
            String timeunit2 = this.getLowlevelParams().get(this.getName() + ".DauerDetails.timeunit");
            if (timeunit2 != null) {
                String st;
                if (timeunit2.equals("W")) {
                    String st2 = res.get("turnusweeks");
                    if (st2 != null) {
                        String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                        if (!st2.equals("00") && !this.twoDigitValueInList(value2, st2)) {
                            String msg = HBCIUtils.getLocMsg("EXCMSG_INV_TURNUS", value);
                            throw new InvalidUserDataException(msg);
                        }
                    }
                } else if (timeunit2.equals("M") && (st = res.get("turnusmonths")) != null) {
                    String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                    if (!st.equals("00") && !this.twoDigitValueInList(value2, st)) {
                        String msg = HBCIUtils.getLocMsg("EXCMSG_INV_TURNUS", value);
                        throw new InvalidUserDataException(msg);
                    }
                }
            }
        } else if (paramName.equals("execday") && (timeunit = this.getLowlevelParams().get(this.getName() + ".DauerDetails.timeunit")) != null) {
            String st;
            if (timeunit.equals("W")) {
                String st3 = res.get("daysperweek");
                if (st3 != null && !st3.equals("0") && st3.indexOf(value) == -1) {
                    String msg = HBCIUtils.getLocMsg("EXCMSG_INV_EXECDAY", value);
                    throw new InvalidUserDataException(msg);
                }
            } else if (timeunit.equals("M") && (st = res.get("dayspermonth")) != null) {
                String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                if (!st.equals("00") && !this.twoDigitValueInList(value2, st)) {
                    String msg = HBCIUtils.getLocMsg("EXCMSG_INV_EXECDAY", value);
                    throw new InvalidUserDataException(msg);
                }
            }
        }
        super.setParam(paramName, value);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        String orderid = result.get(header + ".orderid");
        ((GVRDauerEdit)this.jobResult).setOrderId(orderid);
        ((GVRDauerEdit)this.jobResult).setOrderIdOld(result.get(header + ".orderidold"));
        if (orderid != null && orderid.length() != 0) {
            HashMap p2 = new HashMap();
            this.getLowlevelParams().forEach((key, value) -> p2.put(key.substring(key.indexOf(".") + 1), value));
        }
    }

    @Override
    public String getPainJobName() {
        return "UebSEPA";
    }
}

