/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes;

import org.kapott.hbci.datatypes.SyntaxAN;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.manager.HBCIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntaxDTAUS
extends SyntaxAN {
    private static final Logger log = LoggerFactory.getLogger(SyntaxDTAUS.class);

    public SyntaxDTAUS(String x, int minlen, int maxlen) {
        super(SyntaxDTAUS.check(x.trim()), minlen, maxlen);
    }

    protected SyntaxDTAUS() {
    }

    public SyntaxDTAUS(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    public static String check(String st) {
        st = st.replace("[", "\u00c3\u0084");
        st = st.replace("\\", "\u00c3\u0096");
        st = st.replace("]", "\u00c3\u009c");
        st = st.replace("{", "\u00e4");
        st = st.replace("|", "\u00c3\u00b6");
        st = st.replace("}", "\u00fc");
        st = st.replace("~", "\u00c3\u009f");
        st = st.toUpperCase();
        st = st.replace('\u00e4', '[').replace('\u00c4', '[');
        st = st.replace('\u00f6', '\\').replace('\u00d6', '\\');
        st = st.replace('\u00fc', ']').replace('\u00dc', ']');
        st = st.replace('\u00df', '~');
        int len = st.length();
        for (int i = 0; i < len; ++i) {
            char ch = st.charAt(i);
            if (ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == ' ' || ch == '.' || ch == ',' || ch == '&' || ch == '-' || ch == '+' || ch == '*' || ch == '%' || ch == '/' || ch == '$' || ch == '[' || ch == '\\' || ch == ']' || ch == '~') continue;
            String msg = HBCIUtils.getLocMsg("EXC_DTAUS_INV_CHAR", Character.toString(ch));
            InvalidArgumentException e = new InvalidArgumentException(msg);
            e.setFatal(true);
            throw e;
        }
        return st;
    }

    @Override
    public void init(String x, int minlen, int maxlen) {
        super.init(SyntaxDTAUS.check(x.trim()), minlen, maxlen);
    }

    @Override
    protected void init() {
        super.init();
    }

    private void initData(StringBuffer res, int minsize, int maxsize) {
        int startidx = SyntaxDTAUS.skipPreDelim(res);
        int endidx = SyntaxDTAUS.findNextDelim(res, startidx);
        String st = res.substring(startidx, endidx);
        this.setContent(SyntaxDTAUS.check(SyntaxDTAUS.unquote(st)), minsize, maxsize);
        res.delete(0, endidx);
    }

    @Override
    public void init(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    @Override
    public String toString() {
        String ret = super.toString();
        ret = ret.replace('[', '\u00c4');
        ret = ret.replace('\\', '\u00d6');
        ret = ret.replace(']', '\u00dc');
        ret = ret.replace('~', '\u00df');
        return ret;
    }
}

