/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXB;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.AccountIdentification4Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.AccountReport22;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.ActiveOrHistoricCurrencyAndAmount;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.BankToCustomerAccountReportV07;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.BankTransactionCodeStructure4;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.BranchAndFinancialInstitutionIdentification5;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.CashAccount24;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.CashAccount36;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.CashBalance8;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.CreditDebitCode;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.DateAndDateTime2Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.Document;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.EntryDetails8;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.EntryTransaction9;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.FinancialInstitutionIdentification8;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.Party35Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.PartyIdentification125;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.Purpose2Choice;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.ReportEntry9;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.TransactionAgents4;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.TransactionParties4;
import org.kapott.hbci.sepa.jaxb.camt_052_001_07.TransactionReferences3;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseCamt05200107
implements ISEPAParser<List<GVRKUms.BTag>> {
    private static final Logger log = LoggerFactory.getLogger(ParseCamt05200107.class);

    @Override
    public void parse(InputStream xml, List<GVRKUms.BTag> tage) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        BankToCustomerAccountReportV07 container = doc.getBkToCstmrAcctRpt();
        if (container == null) {
            log.warn("camt document empty");
            return;
        }
        List<AccountReport22> reports = container.getRpt();
        if (reports == null || reports.size() == 0) {
            log.warn("camt document empty");
            return;
        }
        for (AccountReport22 report : reports) {
            GVRKUms.BTag tag = this.createDay(report);
            tage.add(tag);
            BigDecimal saldo = tag.start != null && tag.start.value != null ? tag.start.value.getBigDecimalValue() : BigDecimal.ZERO;
            for (ReportEntry9 entry : report.getNtry()) {
                GVRKUms.UmsLine line = this.createLine(entry, saldo);
                if (line == null) continue;
                tag.lines.add(line);
                saldo = line.saldo.value.getBigDecimalValue();
            }
        }
    }

    private GVRKUms.UmsLine createLine(ReportEntry9 entry, BigDecimal currSaldo) {
        Purpose2Choice purp;
        String[] parts;
        String code;
        ActiveOrHistoricCurrencyAndAmount amt;
        List<String> usages;
        TransactionAgents4 banks;
        GVRKUms.UmsLine line = new GVRKUms.UmsLine();
        line.isSepa = true;
        line.isCamt = true;
        line.other = new Konto();
        List<EntryDetails8> details = entry.getNtryDtls();
        if (details.size() == 0) {
            return null;
        }
        EntryDetails8 detail = details.get(0);
        List<EntryTransaction9> txList = detail.getTxDtls();
        if (txList.size() == 0) {
            return null;
        }
        boolean haben = entry.getCdtDbtInd() != null && entry.getCdtDbtInd() == CreditDebitCode.CRDT;
        EntryTransaction9 tx = txList.get(0);
        TransactionReferences3 ref = tx.getRefs();
        line.id = ref.getPrtry() != null && ref.getPrtry().size() > 0 ? ref.getPrtry().get(0).getRef() : null;
        TransactionParties4 other = tx.getRltdPties();
        if (other != null) {
            CashAccount24 acc = haben ? other.getDbtrAcct() : other.getCdtrAcct();
            AccountIdentification4Choice id = acc != null ? acc.getId() : null;
            line.other.iban = id != null ? id.getIBAN() : null;
            Party35Choice party = haben ? other.getDbtr() : other.getCdtr();
            PartyIdentification125 pi = party != null ? party.getPty() : null;
            String string = line.other.name = pi != null ? pi.getNm() : null;
        }
        if ((banks = tx.getRltdAgts()) != null) {
            BranchAndFinancialInstitutionIdentification5 bank = haben ? banks.getDbtrAgt() : banks.getCdtrAgt();
            FinancialInstitutionIdentification8 bic = bank != null ? bank.getFinInstnId() : null;
            line.other.bic = bank != null ? bic.getBICFI() : null;
        }
        List<String> list = usages = tx.getRmtInf() != null ? tx.getRmtInf().getUstrd() : null;
        if (usages != null && usages.size() > 0) {
            line.usage.addAll(usages);
        }
        BigDecimal bd = (amt = entry.getAmt()).getValue() != null ? amt.getValue() : BigDecimal.ZERO;
        line.value = new Value(haben ? bd : BigDecimal.ZERO.subtract(bd));
        line.value.setCurr(amt.getCcy());
        line.isStorno = entry.isRvslInd() != null ? entry.isRvslInd() : false;
        DateAndDateTime2Choice bdate = entry.getBookgDt();
        line.bdate = bdate != null ? SepaUtil.toDate(bdate.getDt()) : null;
        DateAndDateTime2Choice vdate = entry.getValDt();
        Date date = line.valuta = vdate != null ? SepaUtil.toDate(vdate.getDt()) : null;
        if (line.bdate == null) {
            line.bdate = line.valuta;
        }
        if (line.valuta == null) {
            line.valuta = line.bdate;
        }
        line.saldo = new Saldo();
        line.saldo.value = new Value(currSaldo.add(line.value.getBigDecimalValue()));
        line.saldo.value.setCurr(line.value.getCurr());
        line.saldo.timestamp = line.bdate;
        line.text = entry.getAddtlNtryInf();
        line.customerref = entry.getAcctSvcrRef();
        BankTransactionCodeStructure4 b = tx.getBkTxCd();
        String string = code = b != null && b.getPrtry() != null ? b.getPrtry().getCd() : null;
        if (code != null && code.contains("+") && (parts = code.split("\\+")).length == 4) {
            line.gvcode = parts[1];
            line.primanota = parts[2];
            line.addkey = parts[3];
        }
        line.purposecode = (purp = tx.getPurp()) != null ? purp.getCd() : null;
        return line;
    }

    private GVRKUms.BTag createDay(AccountReport22 report) {
        GVRKUms.BTag tag = new GVRKUms.BTag();
        tag.start = new Saldo();
        tag.end = new Saldo();
        tag.starttype = (char)70;
        tag.endtype = (char)70;
        long day = 86400000L;
        for (CashBalance8 bal : report.getBal()) {
            String code = bal.getTp().getCdOrPrtry().getCd();
            if (code != null && code.equalsIgnoreCase("PRCD")) {
                tag.start.value = new Value(bal.getAmt().getValue());
                tag.start.value.setCurr(bal.getAmt().getCcy());
                tag.start.timestamp = new Date(SepaUtil.toDate(bal.getDt().getDt()).getTime() + 86400000L);
            }
            if (code == null || !code.equalsIgnoreCase("CLBD")) continue;
            tag.end.value = new Value(bal.getAmt().getValue());
            tag.end.value.setCurr(bal.getAmt().getCcy());
            tag.end.timestamp = SepaUtil.toDate(bal.getDt().getDt());
        }
        CashAccount36 acc = report.getAcct();
        tag.my = new Konto();
        tag.my.iban = acc.getId().getIBAN();
        tag.my.curr = acc.getCcy();
        tag.my.bic = acc.getSvcr().getFinInstnId().getBICFI();
        return tag;
    }
}

