/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.rewrite;

import java.util.HashMap;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.rewrite.Rewrite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RKUmsDelimiters
extends Rewrite {
    private static final Logger log = LoggerFactory.getLogger(RKUmsDelimiters.class);

    private String rewriteKUms(String st) {
        log.debug("rewriting statement of account");
        StringBuffer temp = new StringBuffer(st);
        int posi = 0;
        boolean wrongCRLF = false;
        while ((posi = temp.indexOf("\n", posi)) != -1) {
            if (posi == 0 || temp.charAt(posi - 1) != '\r') {
                temp.replace(posi, posi + 1, "\r\n");
                posi += 2;
                wrongCRLF = true;
                continue;
            }
            ++posi;
        }
        boolean wrongDelimiter = false;
        posi = 0;
        while ((posi = temp.indexOf("@@", posi)) != -1) {
            temp.replace(posi, posi + 2, "\r\n");
            wrongDelimiter = true;
        }
        boolean wrongEndSequence = false;
        if (!temp.substring(temp.length() - 3, temp.length()).equals("\r\n-")) {
            char ch;
            wrongEndSequence = true;
            for (posi = temp.length() - 1; posi >= 0 && ((ch = temp.charAt(posi)) == '\r' || ch == '\n' || ch == '-'); --posi) {
            }
            if (posi >= 0) {
                if (posi != temp.length() - 1) {
                    temp.replace(posi + 1, temp.length(), "\r\n-");
                } else {
                    log.debug("absolutely no ending sequence found - maybe statement of account splitted at wrong position?");
                }
            } else {
                log.warn("statement of account seems to be empty");
            }
        }
        posi = 0;
        boolean missingMinusBetweenCRLFs = false;
        boolean missingCRLFMinus = false;
        while ((posi = temp.indexOf("\r\n:20:", posi)) != -1) {
            if (posi > 1 && temp.substring(posi - 2, posi).equals("\r\n")) {
                missingMinusBetweenCRLFs = true;
                temp.insert(posi, "-");
                posi += 3;
                continue;
            }
            if (posi > 0 && temp.charAt(posi - 1) != '-') {
                missingCRLFMinus = true;
                temp.insert(posi, "\r\n-");
                posi += 5;
                continue;
            }
            ++posi;
        }
        if (!temp.toString().equals(st)) {
            log.debug("this institute produces buggy account statements!");
            log.debug("wrongCRLF:" + wrongCRLF + " wrongDelimiterChars:" + wrongDelimiter + " wrongEnd:" + wrongEndSequence + " missingMinusBetweenCRLFs:" + missingMinusBetweenCRLFs + " missingCRLFMinus:" + missingCRLFMinus);
        }
        return temp.toString();
    }

    @Override
    public Message incomingData(Message msg) {
        String header = "GVRes";
        HashMap<String, String> data = msg.getData();
        data.keySet().forEach(key -> {
            if (key.startsWith(header) && key.indexOf("KUms") != -1 && key.endsWith(".booked")) {
                String st = msg.getValueOfDE(msg.getName() + "." + key);
                st = this.rewriteKUms(st);
                msg.propagateValue(msg.getName() + "." + key, "B" + st, false, true);
            }
        });
        return msg;
    }
}

