/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;

public class SyntaxFloat
extends SyntaxDE {
    public SyntaxFloat(String x, int minsize, int maxsize) {
        super(SyntaxFloat.double2string(x), minsize, maxsize);
    }

    public SyntaxFloat(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    private static String double2string(String st) {
        DecimalFormat hbciFormat = new DecimalFormat("0.##");
        DecimalFormatSymbols symbols = hbciFormat.getDecimalFormatSymbols();
        symbols.setDecimalSeparator(',');
        hbciFormat.setDecimalFormatSymbols(symbols);
        hbciFormat.setDecimalSeparatorAlwaysShown(true);
        return hbciFormat.format(HBCIUtils.string2BigDecimal(st));
    }

    @Override
    public void init(String x, int minsize, int maxsize) {
        super.init(SyntaxFloat.double2string(x), minsize, maxsize);
    }

    private void initData(StringBuffer res, int minsize, int maxsize) {
        String st = null;
        try {
            int startidx = SyntaxFloat.skipPreDelim(res);
            int endidx = SyntaxFloat.findNextDelim(res, startidx);
            st = res.substring(startidx, endidx);
            if (st.length() != 0) {
                DecimalFormat hbciFormat = new DecimalFormat("0.##");
                DecimalFormatSymbols symbols = hbciFormat.getDecimalFormatSymbols();
                symbols.setDecimalSeparator(',');
                hbciFormat.setDecimalFormatSymbols(symbols);
                hbciFormat.setDecimalSeparatorAlwaysShown(true);
                hbciFormat.parse(st).doubleValue();
            }
            this.setContent(st, minsize, maxsize);
            res.delete(0, endidx);
        }
        catch (Exception ex) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_FLOATERR", st), ex);
        }
    }

    @Override
    public void init(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    @Override
    public String toString() {
        try {
            String ret = "";
            String c = this.getContent();
            if (c != null) {
                DecimalFormat hbciFormat = new DecimalFormat("0.##");
                DecimalFormatSymbols symbols = hbciFormat.getDecimalFormatSymbols();
                symbols.setDecimalSeparator(',');
                hbciFormat.setDecimalFormatSymbols(symbols);
                hbciFormat.setDecimalSeparatorAlwaysShown(true);
                hbciFormat.setParseBigDecimal(true);
                ret = HBCIUtils.bigDecimal2String((BigDecimal)hbciFormat.parse(c));
            }
            return ret;
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }
}

