/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.security;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.protocol.MultipleSEGs;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SEG;
import org.kapott.hbci.protocol.SyntaxElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Sig {
    private static final Logger log = LoggerFactory.getLogger(Sig.class);
    public static final String SECFUNC_HBCI_SIG_RDH = "1";
    public static final String SECFUNC_HBCI_SIG_DDV = "2";
    public static final String SECFUNC_FINTS_SIG_DIG = "1";
    public static final String SECFUNC_FINTS_SIG_SIG = "2";
    public static final String SECFUNC_SIG_PT_1STEP = "999";
    public static final String SECFUNC_SIG_PT_2STEP_MIN = "900";
    public static final String SECFUNC_SIG_PT_2STEP_MAX = "997";
    public static final String HASHALG_SHA1 = "1";
    public static final String HASHALG_SHA256 = "3";
    public static final String HASHALG_SHA384 = "4";
    public static final String HASHALG_SHA512 = "5";
    public static final String HASHALG_SHA256_SHA256 = "6";
    public static final String HASHALG_RIPEMD160 = "999";
    public static final String SIGALG_DES = "1";
    public static final String SIGALG_RSA = "10";
    public static final String SIGMODE_ISO9796_1 = "16";
    public static final String SIGMODE_ISO9796_2 = "17";
    public static final String SIGMODE_PKCS1 = "18";
    public static final String SIGMODE_PSS = "19";
    public static final String SIGMODE_RETAIL_MAC = "999";
    private String u_secfunc;
    private String u_cid;
    private String u_role;
    private String u_range;
    private String u_keyblz;
    private String u_keycountry;
    private String u_keyuserid;
    private String u_keynum;
    private String u_keyversion;
    private String u_sysid;
    private String u_sigid;
    private String u_sigalg;
    private String u_sigmode;
    private String u_hashalg;
    private String sigstring;

    public boolean signIt(Message msg, HBCIPassportInternal passport) {
        Node msgNode = msg.getSyntaxDef(msg.getName(), passport.getSyntaxDocument());
        String dontsignAttr = ((Element)msgNode).getAttribute("dontsign");
        if (dontsignAttr.length() == 0) {
            try {
                List<MultipleSyntaxElements> msgelements = msg.getChildContainers();
                List<SyntaxElement> sigheads = msgelements.get(1).getElements();
                List<SyntaxElement> sigtails = msgelements.get(msgelements.size() - 2).getElements();
                SEG sigHead = new SEG("SigHeadUser", "SigHead", msg.getName(), 0, passport.getSyntaxDocument());
                sigheads.set(0, sigHead);
                SEG sigTail = new SEG("SigTailUser", "SigTail", msg.getName(), 0, passport.getSyntaxDocument());
                sigtails.set(0, sigTail);
                this.u_secfunc = passport.getSigFunction();
                this.u_cid = "";
                this.u_role = "1";
                this.u_range = "1";
                this.u_keyblz = passport.getBLZ();
                this.u_keycountry = passport.getCountry();
                this.u_keyuserid = passport.getMySigKeyName();
                this.u_keynum = passport.getMySigKeyNum();
                this.u_keyversion = passport.getMySigKeyVersion();
                this.u_sysid = passport.getSysId();
                this.u_sigid = passport.getSigId().toString();
                this.u_sigalg = passport.getSigAlg();
                this.u_sigmode = passport.getSigMode();
                this.u_hashalg = passport.getHashAlg();
                passport.incSigId();
                this.fillSigHead(sigHead, passport.getProfileMethod(), passport.getProfileVersion(), msg.getName().endsWith("Res"));
                this.fillSigTail(sigHead, sigTail);
                msg.enumerateSegs(0, true);
                msg.validate();
                msg.enumerateSegs(1, true);
                msgelements = msg.getChildContainers();
                sigtails = msgelements.get(msgelements.size() - 2).getElements();
                sigTail = (SEG)sigtails.get(0);
                msg.propagateValue(sigTail.getPath() + ".UserSig.pin", passport.getPIN(), false, false);
                String tan = passport.getCallback().needTAN();
                if (tan != null) {
                    msg.propagateValue(sigTail.getPath() + ".UserSig.tan", tan, false, false);
                }
                msg.validate();
                msg.enumerateSegs(1, true);
                msg.autoSetMsgSize();
            }
            catch (Exception ex) {
                throw new HBCI_Exception("*** error while signing", ex);
            }
        } else {
            log.debug("did not sign - message does not want to be signed");
        }
        return true;
    }

    private void fillSigHead(SEG sighead, String profileMethod, String profileVersion, boolean response) {
        String sigheadName = sighead.getPath();
        String seccheckref = Integer.toString(Math.abs(new Random().nextInt()));
        Date d = new Date();
        sighead.propagateValue(sigheadName + ".secfunc", this.u_secfunc, false, false);
        sighead.propagateValue(sigheadName + ".seccheckref", seccheckref, false, false);
        sighead.propagateValue(sigheadName + ".role", this.u_role, false, false);
        sighead.propagateValue(sigheadName + ".SecIdnDetails.func", response ? "2" : "1", false, false);
        if (this.u_cid.length() != 0) {
            sighead.propagateValue(sigheadName + ".SecIdnDetails.cid", "B" + this.u_cid, false, false);
        } else {
            sighead.propagateValue(sigheadName + ".SecIdnDetails.sysid", this.u_sysid, false, false);
        }
        sighead.propagateValue(sigheadName + ".SecTimestamp.date", HBCIUtils.date2StringISO(d), false, false);
        sighead.propagateValue(sigheadName + ".SecTimestamp.time", HBCIUtils.time2StringISO(d), false, false);
        sighead.propagateValue(sigheadName + ".secref", this.u_sigid, false, false);
        sighead.propagateValue(sigheadName + ".HashAlg.alg", this.u_hashalg, false, false);
        sighead.propagateValue(sigheadName + ".SigAlg.alg", this.u_sigalg, false, false);
        sighead.propagateValue(sigheadName + ".SigAlg.mode", this.u_sigmode, false, false);
        sighead.propagateValue(sigheadName + ".KeyName.KIK.country", this.u_keycountry, false, false);
        sighead.propagateValue(sigheadName + ".KeyName.KIK.blz", this.u_keyblz, false, false);
        sighead.propagateValue(sigheadName + ".KeyName.userid", this.u_keyuserid, false, false);
        sighead.propagateValue(sigheadName + ".KeyName.keynum", this.u_keynum, false, false);
        sighead.propagateValue(sigheadName + ".KeyName.keyversion", this.u_keyversion, false, false);
        sighead.propagateValue(sigheadName + ".SecProfile.method", profileMethod, false, false);
        sighead.propagateValue(sigheadName + ".SecProfile.version", profileVersion, false, false);
    }

    private void fillSigTail(SEG sighead, SEG sigtail) {
        String sigtailName = sigtail.getPath();
        sigtail.propagateValue(sigtailName + ".seccheckref", sighead.getValueOfDE(sighead.getPath() + ".seccheckref"), false, false);
    }

    private void readSigHead(Message msg, HBCIPassportInternal passport) {
        String sigheadName = msg.getName() + ".SigHead";
        this.u_secfunc = msg.getValueOfDE(sigheadName + ".secfunc");
        this.u_role = msg.getValueOfDE(sigheadName + ".role");
        this.u_range = msg.getValueOfDE(sigheadName + ".range");
        this.u_keycountry = msg.getValueOfDE(sigheadName + ".KeyName.KIK.country");
        this.u_keyuserid = msg.getValueOfDE(sigheadName + ".KeyName.userid");
        this.u_keynum = msg.getValueOfDE(sigheadName + ".KeyName.keynum");
        this.u_keyversion = msg.getValueOfDE(sigheadName + ".KeyName.keyversion");
        this.u_sigid = msg.getValueOfDE(sigheadName + ".secref");
        this.u_sigalg = msg.getValueOfDE(sigheadName + ".SigAlg.alg");
        this.u_sigmode = msg.getValueOfDE(sigheadName + ".SigAlg.mode");
        this.u_hashalg = msg.getValueOfDE(sigheadName + ".HashAlg.alg");
        try {
            this.u_keyblz = msg.getValueOfDE(sigheadName + ".KeyName.KIK.blz");
        }
        catch (Exception e) {
            log.warn("missing bank code in message signature, ignoring...");
        }
        if (passport.needUserSig()) {
            HashMap<String, String> values = new HashMap<String, String>();
            msg.extractValues(values);
            String pin = values.get(msg.getName() + ".SigTail.UserSig.pin");
            String tan = values.get(msg.getName() + ".SigTail.UserSig.tan");
            this.sigstring = (pin != null ? pin : "") + "|" + (tan != null ? tan : "");
        } else {
            this.sigstring = msg.getValueOfDE(msg.getName() + ".SigTail.sig");
        }
        String checkref = msg.getValueOfDE(msg.getName() + ".SigHead.seccheckref");
        String checkref2 = msg.getValueOfDE(msg.getName() + ".SigTail.seccheckref");
        if (checkref == null || !checkref.equals(checkref2)) {
            String errmsg = HBCIUtils.getLocMsg("EXCMSG_SIGREFFAIL");
            throw new HBCI_Exception(errmsg);
        }
    }

    private boolean hasSig(Message msg) {
        boolean ret = true;
        MultipleSyntaxElements seglist = msg.getChildContainers().get(1);
        if (seglist instanceof MultipleSEGs) {
            SEG sighead = null;
            try {
                sighead = (SEG)seglist.getElements().get(0);
            }
            catch (IndexOutOfBoundsException e) {
                ret = false;
            }
            if (ret) {
                String sigheadCode = "HNSHK";
                if (!sighead.getCode().equals(sigheadCode)) {
                    ret = false;
                }
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public boolean verify(Message msg, HBCIPassportInternal passport) {
        if (passport.hasInstSigKey()) {
            String msgName = msg.getName();
            Node msgNode = msg.getSyntaxDef(msgName, passport.getSyntaxDocument());
            String dontsignAttr = ((Element)msgNode).getAttribute("dontsign");
            if (dontsignAttr.length() == 0) {
                if (this.hasSig(msg)) {
                    this.readSigHead(msg, passport);
                    return true;
                }
                log.warn("message has no signature");
                return true;
            }
            log.debug("message does not need a signature");
            return true;
        }
        log.warn("can not check signature - no signature key available");
        return true;
    }
}

