/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.ListIterator;
import org.kapott.hbci.protocol.MultipleSEGs;
import org.kapott.hbci.protocol.MultipleSFs;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SyntaxElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SF
extends SyntaxElement {
    private static final Logger log = LoggerFactory.getLogger(SF.class);

    public SF(String type, String name, String path, int idx, Document document) {
        super(type, name, path, idx, document);
    }

    public SF(String type, String name, String path, char predelim, int idx, StringBuffer res, Document document, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        super(type, name, path, predelim, idx, res, document, predefs, valids);
    }

    @Override
    protected MultipleSyntaxElements createNewChildContainer(Node ref, Document document) {
        MultipleSyntaxElements ret = null;
        if (ref.getNodeName().equals("SEG")) {
            ret = new MultipleSEGs(ref, this.getPath(), document);
        } else if (ref.getNodeName().equals("SF")) {
            ret = new MultipleSFs(ref, this.getPath(), document);
        }
        return ret;
    }

    @Override
    protected MultipleSyntaxElements createAndAppendNewChildContainer(Node ref, Document document) {
        MultipleSyntaxElements ret = null;
        if (((Element)ref).getAttribute("minnum").equals("0")) {
            log.trace("will not create container " + this.getPath() + " -> " + ((Element)ref).getAttribute("type") + " with minnum=0");
        } else {
            ret = super.createAndAppendNewChildContainer(ref, document);
        }
        return ret;
    }

    @Override
    protected String getElementTypeName() {
        return "SF";
    }

    @Override
    public void init(String type, String name, String path, int idx, Document document) {
        super.init(type, name, path, idx, document);
    }

    @Override
    public String toString(int dummy) {
        StringBuffer ret = new StringBuffer(256);
        if (this.isValid()) {
            ListIterator<MultipleSyntaxElements> i = this.getChildContainers().listIterator();
            while (i.hasNext()) {
                MultipleSyntaxElements list = i.next();
                if (list == null) continue;
                ret.append(list.toString(0));
            }
        }
        return ret.toString();
    }

    @Override
    public void init(String type, String name, String path, char predelim, int idx, StringBuffer res, Document document, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        super.init(type, name, path, predelim, idx, res, document, predefs, valids);
    }

    @Override
    protected char getInDelim() {
        return '\'';
    }

    private String[] extractSegId(StringBuffer sb) {
        String[] ret = new String[]{"", ""};
        if (sb.length() > 1) {
            int endpos;
            int startpos = 0;
            char ch = sb.charAt(0);
            if (ch == '+' || ch == ':' || ch == '\'') {
                ++startpos;
            }
            if ((endpos = sb.indexOf("+", startpos)) == -1) {
                endpos = sb.length();
            }
            String[] des = sb.substring(startpos, endpos).split(":");
            ret[0] = des[0];
            ret[1] = des[2];
        }
        return ret;
    }

    private String[] getRefSegId(Node segref, Document document) {
        String segname = ((Element)segref).getAttribute("type");
        String[] ret = new String[]{"", ""};
        Element segdef = document.getElementById(segname);
        NodeList valueElems = segdef.getElementsByTagName("value");
        int len = valueElems.getLength();
        for (int i = 0; i < len; ++i) {
            Node valueNode = valueElems.item(i);
            if (valueNode.getNodeType() != 1) continue;
            String pathAttr = ((Element)valueNode).getAttribute("path");
            if (pathAttr.equals("SegHead.code")) {
                ret[0] = valueNode.getFirstChild().getNodeValue();
                continue;
            }
            if (!pathAttr.equals("SegHead.version")) continue;
            ret[1] = valueNode.getFirstChild().getNodeValue();
        }
        return ret;
    }

    @Override
    protected MultipleSyntaxElements parseNewChildContainer(Node segref, char predelim0, char predelim1, StringBuffer res, Document document, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        MultipleSyntaxElements ret = null;
        if (segref.getNodeName().equals("SEG")) {
            ret = new MultipleSEGs(segref, this.getPath(), predelim0, predelim1, res, document, predefs, valids);
        } else if (segref.getNodeName().equals("SF")) {
            ret = new MultipleSFs(segref, this.getPath(), predelim0, predelim1, res, document, predefs, valids);
        }
        return ret;
    }

    protected MultipleSyntaxElements parseAndAppendNewChildContainer(Node segref, char predelim0, char predelim1, StringBuffer res, int fullResLen, Document document, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        MultipleSyntaxElements ret = null;
        if (segref.getNodeName().equals("SEG")) {
            String[] nextSegId = this.extractSegId(res);
            String[] segRefId = this.getRefSegId(segref, document);
            if (segRefId[0].equals(nextSegId[0]) && segRefId[1].equals(nextSegId[1]) || segRefId[0].equals("") || segRefId[1].equals("")) {
                boolean parseNext = true;
                if (this.getName().startsWith("Params") && (nextSegId[0].length() != 6 || !nextSegId[0].endsWith("S"))) {
                    parseNext = false;
                }
                if (parseNext) {
                    ret = super.parseAndAppendNewChildContainer(segref, predelim0, predelim1, res, document, predefs, valids);
                }
            }
        } else if (segref.getNodeName().equals("SF")) {
            ret = super.parseAndAppendNewChildContainer(segref, predelim0, predelim1, res, document, predefs, valids);
        }
        return ret;
    }

    @Override
    public void getElementPaths(HashMap<String, String> p, int[] segref, int[] degref, int[] deref) {
        if (this.isValid()) {
            for (MultipleSyntaxElements l : this.getChildContainers()) {
                if (l == null) continue;
                l.getElementPaths(p, segref, null, null);
            }
        }
    }
}

