/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRStatus;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.status.HBCIRetVal;

public final class GVStatus
extends AbstractHBCIJob {
    public GVStatus(HBCIPassportInternal passport) {
        super(passport, GVStatus.getLowlevelName(), new GVRStatus(passport));
        this.addConstraint("startdate", "startdate", "");
        this.addConstraint("enddate", "enddate", "");
        this.addConstraint("maxentries", "maxentries", "");
        this.addConstraint("jobid", null, "");
    }

    public static String getLowlevelName() {
        return "Status";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        GVRStatus.Entry entry = new GVRStatus.Entry();
        entry.dialogid = result.get(header + ".MsgRef.dialogid");
        entry.msgnum = result.get(header + ".MsgRef.msgnum");
        entry.retval = new HBCIRetVal(result, header + ".RetVal", result.get(header + ".segref"));
        entry.retval.element = null;
        String date = result.get(header + ".date");
        String time = result.get(header + ".time");
        entry.timestamp = HBCIUtils.strings2DateTimeISO(date, time);
        ((GVRStatus)this.jobResult).addEntry(entry);
    }

    @Override
    public void setParam(String paramName, String value) {
        if (paramName.equals("jobid")) {
            try {
                Date dateOfJob = new SimpleDateFormat("yyyyMMdd").parse(value.substring(0, value.indexOf("/")));
                this.setParam("startdate", dateOfJob);
                this.setParam("enddate", dateOfJob);
            }
            catch (Exception e) {
                String msg = HBCIUtils.getLocMsg("EXCMSG_CANTEXTRACTDATE", value);
                throw new InvalidUserDataException(msg, e);
            }
        } else {
            super.setParam(paramName, value);
        }
    }
}

