/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HHDVersion {
    HHD_1_4(Type.CHIPTAN, "HHD1.4", "1.4", 5, "hhd14"),
    HHD_1_3(Type.CHIPTAN, "HHD1.3", "1.3", 4, "hhd13"),
    MS_1(Type.PHOTOTAN, "MS1", null, -1, "hhd14"),
    HHD_1_2(Type.CHIPTAN, null, null, -1, "hhd12");

    private static final Logger log;
    private Type type = null;
    private String idStart = null;
    private String versionStart = null;
    private int segVersion = 0;
    private String challengeVersion = null;

    private HHDVersion(Type type, String idStart, String versionStart, int segVersion, String challengeVersion) {
        this.type = type;
        this.idStart = idStart;
        this.versionStart = versionStart;
        this.segVersion = segVersion;
        this.challengeVersion = challengeVersion;
    }

    public static HHDVersion find(HashMap<String, String> secmech) {
        log.debug("trying to determine HHD version for secmech: " + secmech);
        String id = secmech.get("id") != null ? secmech.get("id") : "";
        log.debug("  technical HHD id: " + id);
        for (HHDVersion v : HHDVersion.values()) {
            String s = v.idStart;
            if (s == null || !id.startsWith(s)) continue;
            return v;
        }
        String version = secmech.get("zkamethod_version");
        log.debug("  ZKA version: " + version);
        if (version != null && version.length() > 0) {
            for (HHDVersion v : HHDVersion.values()) {
                String s = v.versionStart;
                if (s == null || !version.startsWith(s)) continue;
                return v;
            }
        }
        String segversion = secmech.get("segversion");
        log.debug("  segment version: " + segversion);
        if (segversion != null && segversion.length() > 0) {
            int i = Integer.parseInt(segversion);
            for (HHDVersion v : HHDVersion.values()) {
                int i2 = v.segVersion;
                if (i2 <= 0 || i != i2) continue;
                return v;
            }
        }
        return HHD_1_2;
    }

    public String getChallengeVersion() {
        return this.challengeVersion;
    }

    public Type getType() {
        return this.type;
    }

    static {
        log = LoggerFactory.getLogger(HHDVersion.class);
    }

    public static enum Type {
        CHIPTAN,
        PHOTOTAN;

    }
}

