/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;

public final class GVRInfoList
extends HBCIJobResultImpl {
    private List<Info> entries = new ArrayList<Info>();

    public GVRInfoList(HBCIPassportInternal passport) {
        super(passport);
    }

    public void addEntry(Info entry) {
        this.entries.add(entry);
    }

    public Info[] getEntries() {
        return this.entries.toArray(new Info[this.entries.size()]);
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        for (int i = 0; i < this.entries.size(); ++i) {
            Info entry = this.entries.get(i);
            ret.append("Info #").append(i).append(linesep);
            ret.append(entry.toString());
            ret.append(linesep + linesep);
        }
        return ret.toString().trim();
    }

    public static final class Info {
        public String code;
        public String description;
        public String type;
        public String format;
        public Date date;
        public String[] comment = new String[0];

        public void addComment(String st) {
            ArrayList<String> a = new ArrayList<String>(Arrays.asList(this.comment));
            a.add(st);
            this.comment = a.toArray(this.comment);
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            String linesep = System.getProperty("line.separator");
            if (this.type.equals("F")) {
                ret.append("Freitextmeldung");
            } else if (this.type.equals("D")) {
                ret.append("Datei");
            } else if (this.type.equals("S")) {
                ret.append("Schriftdokument");
            } else if (this.type.equals("T")) {
                ret.append("Themenueberschrift");
            }
            if (this.format != null) {
                ret.append("(").append(this.format).append(")");
            }
            ret.append(" ").append(this.code).append(" ").append(this.description);
            if (this.date != null) {
                ret.append(" ").append(HBCIUtils.date2StringLocal(this.date));
            }
            ret.append(linesep);
            for (int i = 0; i < this.comment.length; ++i) {
                ret.append(this.comment[i] + linesep);
            }
            return ret.toString().trim();
        }
    }
}

