/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXB;
import javax.xml.datatype.XMLGregorianCalendar;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.GV.parsers.AbstractSepaParser;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.sepa.jaxb.pain_008_003_02.ActiveOrHistoricCurrencyAndAmountSEPA;
import org.kapott.hbci.sepa.jaxb.pain_008_003_02.CustomerDirectDebitInitiationV02;
import org.kapott.hbci.sepa.jaxb.pain_008_003_02.DirectDebitTransactionInformationSDD;
import org.kapott.hbci.sepa.jaxb.pain_008_003_02.Document;
import org.kapott.hbci.sepa.jaxb.pain_008_003_02.PaymentInstructionInformationSDD;
import org.kapott.hbci.sepa.jaxb.pain_008_003_02.PurposeSEPA;

public class ParsePain00800302
extends AbstractSepaParser {
    @Override
    public void parse(InputStream xml, List<HashMap<String, String>> sepaResults) {
        Document doc = (Document)JAXB.unmarshal((InputStream)xml, Document.class);
        CustomerDirectDebitInitiationV02 pain = doc.getCstmrDrctDbtInitn();
        List<PaymentInstructionInformationSDD> pmtInfs = pain.getPmtInf();
        for (PaymentInstructionInformationSDD pmtInf : pmtInfs) {
            List<DirectDebitTransactionInformationSDD> txList = pmtInf.getDrctDbtTxInf();
            for (DirectDebitTransactionInformationSDD tx : txList) {
                XMLGregorianCalendar date;
                PurposeSEPA purp;
                HashMap<String, String> prop = new HashMap<String, String>();
                this.put(prop, ISEPAParser.Names.PMTINFID, pmtInf.getPmtInfId());
                this.put(prop, ISEPAParser.Names.SRC_NAME, pain.getGrpHdr().getInitgPty().getNm());
                this.put(prop, ISEPAParser.Names.SRC_IBAN, pmtInf.getCdtrAcct().getId().getIBAN());
                this.put(prop, ISEPAParser.Names.SRC_BIC, pmtInf.getCdtrAgt().getFinInstnId().getBIC());
                this.put(prop, ISEPAParser.Names.DST_NAME, tx.getDbtr().getNm());
                this.put(prop, ISEPAParser.Names.DST_IBAN, tx.getDbtrAcct().getId().getIBAN());
                try {
                    this.put(prop, ISEPAParser.Names.DST_BIC, tx.getDbtrAgt().getFinInstnId().getBIC());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ActiveOrHistoricCurrencyAndAmountSEPA amt = tx.getInstdAmt();
                this.put(prop, ISEPAParser.Names.VALUE, SepaUtil.format(amt.getValue()));
                this.put(prop, ISEPAParser.Names.CURR, amt.getCcy().value());
                if (tx.getRmtInf() != null) {
                    this.put(prop, ISEPAParser.Names.USAGE, tx.getRmtInf().getUstrd());
                }
                if ((purp = tx.getPurp()) != null) {
                    this.put(prop, ISEPAParser.Names.PURPOSECODE, purp.getCd());
                }
                if ((date = pmtInf.getReqdColltnDt()) != null) {
                    this.put(prop, ISEPAParser.Names.TARGETDATE, SepaUtil.format(date, null));
                }
                this.put(prop, ISEPAParser.Names.ENDTOENDID, tx.getPmtId().getEndToEndId());
                try {
                    this.put(prop, ISEPAParser.Names.CREDITORID, tx.getDrctDbtTx().getCdtrSchmeId().getId().getPrvtId().getOthr().getId());
                }
                catch (Exception e) {
                    this.put(prop, ISEPAParser.Names.CREDITORID, pmtInf.getCdtrSchmeId().getId().getPrvtId().getOthr().getId());
                }
                this.put(prop, ISEPAParser.Names.MANDATEID, tx.getDrctDbtTx().getMndtRltdInf().getMndtId());
                XMLGregorianCalendar mandDate = tx.getDrctDbtTx().getMndtRltdInf().getDtOfSgntr();
                if (mandDate != null) {
                    this.put(prop, ISEPAParser.Names.MANDDATEOFSIG, SepaUtil.format(mandDate, null));
                }
                this.put(prop, ISEPAParser.Names.SEQUENCETYPE, pmtInf.getPmtTpInf().getSeqTp().value());
                this.put(prop, ISEPAParser.Names.LAST_TYPE, pmtInf.getPmtTpInf().getLclInstrm().getCd());
                sepaResults.add(prop);
            }
        }
    }
}

