/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV_Result.GVRTermUeb;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.PainVersion;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVTermUebSEPA
extends AbstractSEPAGV {
    private static final PainVersion DEFAULT = PainVersion.PAIN_001_001_02;

    public GVTermUebSEPA(HBCIPassportInternal passport) {
        super(passport, GVTermUebSEPA.getLowlevelName(), new GVRTermUeb(passport));
        this.addConstraint("src.bic", "My.bic", null);
        this.addConstraint("src.iban", "My.iban", null);
        if (this.canNationalAcc(passport)) {
            this.addConstraint("src.country", "My.KIK.country", "");
            this.addConstraint("src.blz", "My.KIK.blz", "");
            this.addConstraint("src.number", "My.number", "");
            this.addConstraint("src.subnumber", "My.subnumber", "");
        }
        this.addConstraint("_sepadescriptor", "sepadescr", this.getPainVersion().getURN());
        this.addConstraint("_sepapain", "sepapain", null);
        this.addConstraint("src.bic", "sepa.src.bic", null);
        this.addConstraint("src.iban", "sepa.src.iban", null);
        this.addConstraint("src.name", "sepa.src.name", null);
        this.addConstraint("dst.bic", "sepa.dst.bic", null);
        this.addConstraint("dst.iban", "sepa.dst.iban", null);
        this.addConstraint("dst.name", "sepa.dst.name", null);
        this.addConstraint("btg.value", "sepa.btg.value", null);
        this.addConstraint("btg.curr", "sepa.btg.curr", "EUR");
        this.addConstraint("usage", "sepa.usage", "");
        this.addConstraint("date", "sepa.date", null);
        this.addConstraint("sepaid", "sepa.sepaid", this.getSEPAMessageId());
        this.addConstraint("pmtinfid", "sepa.pmtinfid", this.getSEPAMessageId());
        this.addConstraint("endtoendid", "sepa.endtoendid", "NOTPROVIDED");
        this.addConstraint("purposecode", "sepa.purposecode", "");
    }

    public static String getLowlevelName() {
        return "TermUebSEPA";
    }

    @Override
    protected PainVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected PainVersion.Type getPainType() {
        return PainVersion.Type.PAIN_001;
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        String orderid = result.get(header + ".orderid");
        ((GVRTermUeb)this.jobResult).setOrderId(orderid);
        if (orderid != null && orderid.length() != 0) {
            HashMap p2 = new HashMap();
            this.getLowlevelParams().forEach((key, value) -> p2.put(key.substring(key.indexOf(".") + 1), value));
        }
    }

    @Override
    public String getPainJobName() {
        return "UebSEPA";
    }
}

