/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRKontoauszug;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.swift.Swift;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GVKontoauszug
extends AbstractHBCIJob {
    private static final Logger log = LoggerFactory.getLogger(GVKontoauszug.class);
    public static final String FORMAT_MT940 = "1";
    public static final String FORMAT_ISO8583 = "2";
    public static final String FORMAT_PDF = "3";

    public GVKontoauszug(HBCIPassportInternal passport, String name) {
        super(passport, name, new GVRKontoauszug(passport));
    }

    public GVKontoauszug(HBCIPassportInternal passport) {
        this(passport, GVKontoauszug.getLowlevelName());
        this.addConstraint("my.country", "My.KIK.country", "DE");
        this.addConstraint("my.blz", "My.KIK.blz", null);
        this.addConstraint("my.number", "My.number", null);
        this.addConstraint("my.subnumber", "My.subnumber", "");
        this.addConstraint("format", "format", "");
        this.addConstraint("idx", "idx", "");
        this.addConstraint("year", "year", "");
        this.addConstraint("maxentries", "maxentries", "");
    }

    public static String getLowlevelName() {
        return "Kontoauszug";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        GVRKontoauszug umsResult = (GVRKontoauszug)this.jobResult;
        String format = result.get(header + ".format");
        String rawData = result.get(header + ".booked");
        if (rawData != null) {
            if (format.equals(FORMAT_MT940)) {
                umsResult.appendMT940Data(Swift.decodeUmlauts(rawData));
            } else if (format.equals(FORMAT_ISO8583)) {
                umsResult.appendISOData(rawData);
            } else if (format.equals(FORMAT_PDF)) {
                umsResult.appendPDFData(rawData);
            } else {
                log.error("unknown format in result for GV Kontoauszug: " + format);
            }
        }
        umsResult.setFormat(format);
        umsResult.setStartDate(HBCIUtils.string2DateISO(result.get(header + ".TimeRange.startdate")));
        umsResult.setEndDate(HBCIUtils.string2DateISO(result.get(header + ".TimeRange.enddate")));
        umsResult.setAbschlussInfo(result.get(header + ".abschlussinfo"));
        umsResult.setKundenInfo(result.get(header + ".kondinfo"));
        umsResult.setWerbetext(result.get(header + ".ads"));
        umsResult.setIBAN(result.get(header + ".iban"));
        umsResult.setBIC(result.get(header + ".bic"));
        umsResult.setName(result.get(header + ".name"));
        umsResult.setName2(result.get(header + ".name2"));
        umsResult.setName3(result.get(header + ".name3"));
        umsResult.setReceipt(result.get(header + ".receipt"));
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

