/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.GV.parsers.SEPAParserFactory;
import org.kapott.hbci.GV_Result.GVRDauerList;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.PainVersion;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GVDauerSEPAList
extends AbstractSEPAGV {
    private static final Logger log = LoggerFactory.getLogger(GVDauerSEPAList.class);
    private static final PainVersion DEFAULT = PainVersion.PAIN_001_001_02;

    public GVDauerSEPAList(HBCIPassportInternal passport) {
        super(passport, GVDauerSEPAList.getLowlevelName(), new GVRDauerList(passport));
        this.addConstraint("src.bic", "My.bic", null);
        this.addConstraint("src.iban", "My.iban", null);
        if (this.canNationalAcc(passport)) {
            this.addConstraint("src.country", "My.KIK.country", "");
            this.addConstraint("src.blz", "My.KIK.blz", "");
            this.addConstraint("src.number", "My.number", "");
            this.addConstraint("src.subnumber", "My.subnumber", "");
        }
        this.addConstraint("_sepadescriptor", "sepadescr", this.getPainVersion().getURN());
        this.addConstraint("orderid", "orderid", "");
        this.addConstraint("maxentries", "maxentries", "");
    }

    public static String getLowlevelName() {
        return "DauerSEPAList";
    }

    @Override
    protected PainVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected PainVersion.Type getPainType() {
        return PainVersion.Type.PAIN_001;
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        GVRDauerList.Dauer entry = new GVRDauerList.Dauer();
        log.debug("parsing SEPA standing orders from msg data [size: " + result.size() + "]");
        entry.my = new Konto();
        entry.my.country = result.get(header + ".My.KIK.country");
        entry.my.blz = result.get(header + ".My.KIK.blz");
        entry.my.number = result.get(header + ".My.number");
        entry.my.subnumber = result.get(header + ".My.subnumber");
        entry.my.iban = result.get(header + ".My.iban");
        entry.my.bic = result.get(header + ".My.bic");
        this.passport.fillAccountInfo(entry.my);
        entry.other = new Konto();
        String sepadescr = result.get(header + ".sepadescr");
        String pain = result.get(header + ".sepapain");
        PainVersion version = PainVersion.choose(sepadescr, pain);
        ISEPAParser parser = SEPAParserFactory.get(version);
        ArrayList<HashMap<String, String>> sepaResults = new ArrayList<HashMap<String, String>>();
        try {
            log.debug("  parsing sepa data: " + pain);
            parser.parse(new ByteArrayInputStream(pain.getBytes("ISO-8859-1")), sepaResults);
            log.debug("  parsed sepa data, entries: " + sepaResults.size());
        }
        catch (Exception e) {
            log.error("  unable to parse sepa data: " + e.getMessage());
            throw new HBCI_Exception("Error parsing SEPA pain document", e);
        }
        if (sepaResults.isEmpty()) {
            log.warn("  found no sepa data");
            return;
        }
        HashMap<String, String> separesult = sepaResults.get(0);
        entry.other.iban = separesult.get("dst.iban");
        entry.other.bic = separesult.get("dst.bic");
        entry.other.name = separesult.get("dst.name");
        entry.pmtinfid = separesult.get("pmtinfid");
        entry.purposecode = separesult.get("purposecode");
        entry.value = new Value(separesult.get("value"), separesult.get("curr"));
        entry.addUsage(separesult.get("usage"));
        entry.orderid = result.get(header + ".orderid");
        entry.firstdate = HBCIUtils.string2DateISO(result.get(header + ".DauerDetails.firstdate"));
        entry.timeunit = result.get(header + ".DauerDetails.timeunit");
        entry.turnus = Integer.parseInt(result.get(header + ".DauerDetails.turnus"));
        entry.execday = Integer.parseInt(result.get(header + ".DauerDetails.execday"));
        String st = result.get(header + ".DauerDetails.lastdate");
        if (st != null) {
            entry.lastdate = HBCIUtils.string2DateISO(st);
        }
        boolean bl = entry.aus_available = result.get(header + ".Aussetzung.annual") != null;
        if (entry.aus_available) {
            entry.aus_annual = result.get(header + ".Aussetzung.annual").equals("J");
            st = result.get(header + ".Aussetzung.startdate");
            if (st != null) {
                entry.aus_start = HBCIUtils.string2DateISO(st);
            }
            if ((st = result.get(header + ".Aussetzung.enddate")) != null) {
                entry.aus_end = HBCIUtils.string2DateISO(st);
            }
            entry.aus_breakcount = result.get(header + ".Aussetzung.number");
            st = result.get(header + ".Aussetzung.newvalue.value");
            if (st != null) {
                entry.aus_newvalue = new Value(st, result.get(header + ".Aussetzung.newvalue.curr"));
            }
        }
        entry.can_change = result.get(header + ".canchange") == null || result.get(header + ".canchange").equals("J");
        entry.can_skip = result.get(header + ".canskip") == null || result.get(header + ".canskip").equals("J");
        entry.can_delete = result.get(header + ".candel") == null || result.get(header + ".candel").equals("J");
        ((GVRDauerList)this.jobResult).addEntry(entry);
        if (entry.orderid != null && entry.orderid.length() != 0) {
            HashMap<String, String> p2 = new HashMap<String, String>();
            for (String key : result.keySet()) {
                if (!key.startsWith(header + ".") || key.startsWith(header + ".SegHead.") || key.endsWith(".orderid")) continue;
                p2.put(key.substring(header.length() + 1), result.get(key));
            }
        }
    }

    @Override
    public String getPainJobName() {
        return "UebSEPA";
    }
}

