/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.NoSuchElementException;
import org.kapott.hbci.exceptions.NoSuchPathException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.protocol.MultipleSEGs;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SyntaxElement {
    private static final Logger log = LoggerFactory.getLogger(SyntaxElement.class);
    public static final boolean TRY_TO_CREATE = true;
    public static final boolean DONT_TRY_TO_CREATE = false;
    public static final boolean ALLOW_OVERWRITE = true;
    public static final boolean DONT_ALLOW_OVERWRITE = false;
    private List<MultipleSyntaxElements> childContainers = new ArrayList<MultipleSyntaxElements>();
    private String name;
    private String type;
    private String path;
    private boolean valid;
    private MultipleSyntaxElements parent;
    private int posInMsg;
    private Document document;
    private Node def;
    private boolean needsRequestTag;
    private boolean haveRequestTag;

    protected SyntaxElement(String type, String name, String path, int idx, Document document) {
        this.initData(type, name, path, idx, document);
    }

    protected SyntaxElement(String type, String name, String path, char predelim, int idx, StringBuffer res, Document document, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        this.initData(type, name, path, predelim, idx, res, document, predefs, valids);
    }

    protected abstract String getElementTypeName();

    protected abstract char getInDelim();

    protected abstract MultipleSyntaxElements createNewChildContainer(Node var1, Document var2);

    protected abstract MultipleSyntaxElements parseNewChildContainer(Node var1, char var2, char var3, StringBuffer var4, Document var5, Hashtable<String, String> var6, Hashtable<String, String> var7);

    private void initData(String type, String name, String ppath, int idx, Document document) {
        if (this.getElementTypeName().equals("SEG")) {
            log.trace("creating segment " + ppath + " -> " + name + "(" + idx + ")");
        }
        this.type = type;
        this.name = name;
        this.document = document;
        StringBuilder temppath = new StringBuilder(128);
        if (ppath != null && ppath.length() != 0) {
            temppath.append(ppath).append(".");
        }
        temppath.append(HBCIUtils.withCounter(name, idx));
        this.path = temppath.toString();
        this.setValid(false);
        if (document != null) {
            this.def = this.getSyntaxDef(type, document);
            String requestTag = ((Element)this.def).getAttribute("needsRequestTag");
            if (requestTag != null && requestTag.equals("1")) {
                this.needsRequestTag = true;
            }
            int syntaxIdx = 0;
            for (Node ref = this.def.getFirstChild(); ref != null; ref = ref.getNextSibling()) {
                if (ref.getNodeType() != 1) continue;
                MultipleSyntaxElements child = this.createAndAppendNewChildContainer(ref, document);
                if (child != null) {
                    child.setParent(this);
                    child.setSyntaxIdx(syntaxIdx);
                    if (this.getElementTypeName().equals("MSG")) {
                        log.trace("child container " + child.getPath() + " has syntaxIdx=" + child.getSyntaxIdx());
                    }
                }
                ++syntaxIdx;
            }
            NodeList valueNodes = ((Element)this.def).getElementsByTagName("value");
            int len = valueNodes.getLength();
            String dottedPath = this.path + ".";
            for (int i = 0; i < len; ++i) {
                Node valueNode = valueNodes.item(i);
                String valuePath = ((Element)valueNode).getAttribute("path");
                String value = valueNode.getFirstChild().getNodeValue();
                String destpath = dottedPath + valuePath;
                if (this.propagateValue(destpath, value, true, false)) continue;
                throw new NoSuchPathException(destpath);
            }
            NodeList validNodes = ((Element)this.def).getElementsByTagName("valids");
            len = validNodes.getLength();
            dottedPath = this.getPath() + ".";
            for (int i = 0; i < len; ++i) {
                Node validNode = validNodes.item(i);
                String valuePath = ((Element)validNode).getAttribute("path");
                String absPath = dottedPath + valuePath;
                NodeList validvalueNodes = ((Element)validNode).getElementsByTagName("validvalue");
                int len2 = validvalueNodes.getLength();
                for (int j = 0; j < len2; ++j) {
                    Node validvalue = validvalueNodes.item(j);
                    String value = validvalue.getFirstChild().getNodeValue();
                    this.storeValidValueInDE(absPath, value);
                }
            }
        }
    }

    protected void init(String type, String name, String path, int idx, Document document) {
        this.initData(type, name, path, idx, document);
    }

    protected MultipleSyntaxElements createAndAppendNewChildContainer(Node ref, Document document) {
        MultipleSyntaxElements ret = this.createNewChildContainer(ref, document);
        if (ret != null) {
            this.addChildContainer(ret);
        }
        return ret;
    }

    protected boolean storeValidValueInDE(String destPath, String value) {
        boolean ret = false;
        ListIterator<MultipleSyntaxElements> i = this.childContainers.listIterator();
        while (i.hasNext()) {
            MultipleSyntaxElements l = (MultipleSyntaxElements)i.next();
            if (!l.storeValidValueInDE(destPath, value)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public int enumerateSegs(int startValue, boolean allowOverwrite) {
        int idx = startValue;
        for (MultipleSyntaxElements s : this.getChildContainers()) {
            if (s == null) continue;
            idx = s.enumerateSegs(idx, allowOverwrite);
        }
        return idx;
    }

    private void initData(String type, String name, String ppath, char predelim, int idx, StringBuffer res, Document document, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        this.type = type;
        this.name = name;
        this.parent = null;
        this.childContainers = new ArrayList<MultipleSyntaxElements>();
        this.needsRequestTag = false;
        this.haveRequestTag = false;
        this.document = document;
        this.def = null;
        int fullResLen = res.length();
        this.posInMsg = fullResLen - res.length();
        StringBuilder temppath = new StringBuilder(128);
        if (ppath != null && ppath.length() != 0) {
            temppath.append(ppath).append(".");
        }
        temppath.append(HBCIUtils.withCounter(name, idx));
        this.path = temppath.toString();
        this.setValid(false);
        if (document != null) {
            this.def = this.getSyntaxDef(type, document);
            NodeList valueNodes = ((Element)this.def).getElementsByTagName("value");
            String dottedPath = this.getPath() + ".";
            int len = valueNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node valueNode = valueNodes.item(i);
                String valuePath = ((Element)valueNode).getAttribute("path");
                String value = valueNode.getFirstChild().getNodeValue();
                predefs.put(dottedPath + valuePath, value);
            }
            if (valids != null) {
                NodeList validNodes = ((Element)this.def).getElementsByTagName("valids");
                len = validNodes.getLength();
                for (int i = 0; i < len; ++i) {
                    Node validNode = validNodes.item(i);
                    String valuePath = ((Element)validNode).getAttribute("path");
                    String absPath = dottedPath + valuePath;
                    NodeList validvalueNodes = ((Element)validNode).getElementsByTagName("validvalue");
                    int len2 = validvalueNodes.getLength();
                    for (int j = 0; j < len2; ++j) {
                        Node validvalue = validvalueNodes.item(j);
                        String value = validvalue.getFirstChild().getNodeValue();
                        valids.put(HBCIUtils.withCounter(absPath + ".value", j), value);
                    }
                }
            }
            int counter = 0;
            for (Node ref = this.def.getFirstChild(); ref != null; ref = ref.getNextSibling()) {
                MultipleSyntaxElements child;
                if (ref.getNodeType() != 1 || (child = this.parseAndAppendNewChildContainer(ref, counter++ == 0 ? predelim : this.getInDelim(), this.getInDelim(), res, document, predefs, valids)) == null) continue;
                child.setParent(this);
                if (this instanceof SF && (this.getName().equals("Params") || this.getName().equals("GVRes")) && ((MultipleSEGs)child).hasValidChilds()) break;
            }
        }
        this.setValid(true);
    }

    protected void init(String type, String name, String path, char predelim, int idx, StringBuffer res, Document document, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        this.initData(type, name, path, predelim, idx, res, document, predefs, valids);
    }

    protected MultipleSyntaxElements parseAndAppendNewChildContainer(Node ref, char predelim0, char predelim1, StringBuffer res, Document document, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        MultipleSyntaxElements ret = this.parseNewChildContainer(ref, predelim0, predelim1, res, document, predefs, valids);
        if (ret != null) {
            this.addChildContainer(ret);
        }
        return ret;
    }

    public void extractValues(HashMap<String, String> values) {
        for (MultipleSyntaxElements l : this.childContainers) {
            l.extractValues(values);
        }
    }

    private void addChildContainer(MultipleSyntaxElements x) {
        this.childContainers.add(x);
    }

    public List<MultipleSyntaxElements> getChildContainers() {
        return this.childContainers;
    }

    public boolean propagateValue(String destPath, String value, boolean tryToCreate, boolean allowOverwrite) {
        boolean ret = false;
        if (destPath.equals(this.getPath())) {
            if (value == null || !value.equals("requested")) {
                throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVVALUE", new Object[]{destPath, value}));
            }
            this.haveRequestTag = true;
            ret = true;
        } else if (destPath.startsWith(this.getPath())) {
            for (MultipleSyntaxElements l : this.childContainers) {
                if (!l.propagateValue(destPath, value, tryToCreate, allowOverwrite)) continue;
                ret = true;
                break;
            }
            if (!ret && tryToCreate) {
                log.trace(this.getPath() + ": could not set value for " + destPath);
                String subPath = destPath.substring(this.getPath().length() + 1);
                log.trace("  subpath is " + subPath);
                int dotPos = subPath.indexOf(46);
                if (dotPos == -1) {
                    dotPos = subPath.length();
                }
                String subType = subPath.substring(0, dotPos);
                log.trace("  subname is " + subType);
                int counterPos = subType.indexOf(95);
                if (counterPos != -1) {
                    subType = subType.substring(0, counterPos);
                }
                log.trace("  subType is " + subType);
                boolean found = false;
                for (MultipleSyntaxElements c : this.childContainers) {
                    if (!c.getName().equals(subType)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    Node ref;
                    int newChildIdx = 0;
                    found = false;
                    for (ref = this.def.getFirstChild(); ref != null; ref = ref.getNextSibling()) {
                        if (ref.getNodeType() != 1) continue;
                        String type = ((Element)ref).getAttribute("type");
                        String name = ((Element)ref).getAttribute("name");
                        if (name.length() == 0) {
                            name = type;
                        }
                        if (name.equals(subType)) {
                            found = true;
                            break;
                        }
                        ++newChildIdx;
                    }
                    if (found) {
                        MultipleSyntaxElements child = this.createNewChildContainer(ref, this.document);
                        child.setParent(this);
                        child.setSyntaxIdx(newChildIdx);
                        if (this.getElementTypeName().equals("MSG")) {
                            log.trace("child container " + child.getPath() + " has syntaxIdx=" + child.getSyntaxIdx());
                        }
                        int newPosi = 0;
                        for (MultipleSyntaxElements c : this.childContainers) {
                            if (c.getSyntaxIdx() > newChildIdx) break;
                            ++newPosi;
                        }
                        log.trace("  inserting child container with syntaxIdx " + newChildIdx + " at position " + newPosi);
                        this.childContainers.add(newPosi, child);
                        ret = child.propagateValue(destPath, value, tryToCreate, allowOverwrite);
                    }
                } else {
                    log.trace("  subtype " + subType + " already existing - will not try to create");
                }
            }
        }
        return ret;
    }

    public String getValueOfDE(String path) {
        MultipleSyntaxElements l;
        String ret = null;
        Iterator<MultipleSyntaxElements> iterator = this.childContainers.iterator();
        while (iterator.hasNext() && (ret = (l = iterator.next()).getValueOfDE(path)) == null) {
        }
        return ret;
    }

    public String getValueOfDE(String path, int zero) {
        MultipleSyntaxElements l;
        String ret = null;
        Iterator<MultipleSyntaxElements> iterator = this.childContainers.iterator();
        while (iterator.hasNext() && (ret = (l = iterator.next()).getValueOfDE(path, 0)) == null) {
        }
        return ret;
    }

    public SyntaxElement getElement(String path) {
        SyntaxElement ret = null;
        if (this.getPath().equals(path)) {
            ret = this;
        } else {
            MultipleSyntaxElements l;
            Iterator<MultipleSyntaxElements> iterator = this.childContainers.iterator();
            while (iterator.hasNext() && (ret = (l = iterator.next()).getElement(path)) == null) {
            }
        }
        return ret;
    }

    public final String getPath() {
        return this.path;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public final Node getSyntaxDef(String type, Document document) {
        Element ret = document.getElementById(type);
        if (ret == null) {
            throw new NoSuchElementException(this.getElementTypeName(), type);
        }
        return ret;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected final void setValid(boolean valid) {
        this.valid = valid;
    }

    public int checkSegSeq(int value) {
        for (MultipleSyntaxElements a : this.childContainers) {
            value = a.checkSegSeq(value);
        }
        return value;
    }

    public String toString(int zero) {
        return this.toString();
    }

    public void validate() {
        if (!this.needsRequestTag || this.haveRequestTag) {
            for (MultipleSyntaxElements l : this.childContainers) {
                l.validate();
            }
            this.setValid(true);
        }
    }

    public void getElementPaths(HashMap<String, String> p, int[] segref, int[] degref, int[] deref) {
    }

    public MultipleSyntaxElements getParent() {
        return this.parent;
    }

    public void setParent(MultipleSyntaxElements parent) {
        this.parent = parent;
    }

    public int getPosInMsg() {
        return this.posInMsg;
    }
}

