/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.kapott.hbci.GV_Result.GVRTANMediaList;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.status.HBCIRetVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinTanPassport
extends AbstractHBCIPassport {
    private static final Logger log = LoggerFactory.getLogger(PinTanPassport.class);
    private String proxy;
    private String proxyuser;
    private String proxypass;
    private boolean verifyTANMode;
    private HashMap<String, HBCITwoStepMechanism> twostepMechanisms = new HashMap();
    private HBCITwoStepMechanism currentSecMechInfo;
    private List<String> allowedTwostepMechanisms = new ArrayList<String>();
    private List<GVRTANMediaList.TANMediaInfo> tanMedias;
    private String pin;

    public PinTanPassport(String hbciversion, HashMap<String, String> properties, HBCICallback callback) {
        super(hbciversion, properties, callback);
    }

    @Override
    public byte[][] encrypt(byte[] bytes) {
        try {
            byte padLength = bytes[bytes.length - 1];
            byte[] encrypted = new String(bytes, 0, bytes.length - padLength, "ISO-8859-1").getBytes("ISO-8859-1");
            return new byte[][]{new byte[8], encrypted};
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** encrypting message failed", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] bytes, byte[] bytes1) {
        try {
            return new String(new String(bytes1, "ISO-8859-1") + '\u0001').getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** decrypting of message failed", ex);
        }
    }

    @Override
    public List<GVRTANMediaList.TANMediaInfo> getTanMedias() {
        return this.tanMedias;
    }

    public GVRTANMediaList.TANMediaInfo getTanMedia(String name) {
        Optional<GVRTANMediaList.TANMediaInfo> tanMediaInfoOptional;
        if (this.tanMedias != null && (tanMediaInfoOptional = this.tanMedias.stream().filter(tanMediaInfo -> tanMediaInfo.mediaName.equals(name)).findFirst()).isPresent()) {
            return tanMediaInfoOptional.get();
        }
        return null;
    }

    @Override
    public void setTanMedias(List<GVRTANMediaList.TANMediaInfo> tanMedias) {
        this.tanMedias = tanMedias;
    }

    @Override
    public void setBPD(HashMap<String, String> newBPD) {
        super.setBPD(newBPD);
        if (newBPD != null && newBPD.size() != 0) {
            this.twostepMechanisms.clear();
            int maxAllowedVersion = 0;
            for (String key : newBPD.keySet()) {
                String subkey;
                if (!key.startsWith("Params") || !(subkey = key.substring(key.indexOf(46) + 1)).startsWith("TAN2StepPar")) continue;
                int segVersion = Integer.parseInt(subkey.substring(11, 12));
                if (!(subkey = subkey.substring(subkey.indexOf(46) + 1)).startsWith("ParTAN2Step") || !subkey.endsWith(".secfunc")) continue;
                if (maxAllowedVersion > 0 && segVersion > maxAllowedVersion) {
                    log.info("skipping segversion " + segVersion + ", larger than allowed version " + maxAllowedVersion);
                    continue;
                }
                String secfunc = newBPD.get(key);
                HBCITwoStepMechanism prev = this.twostepMechanisms.get(secfunc);
                if (prev != null && prev.getSegversion() > segVersion) {
                    log.debug("found another twostepmech " + secfunc + " in segversion " + segVersion + ", allready have one in segversion " + prev.getSegversion() + ", ignoring segversion " + segVersion);
                    continue;
                }
                HBCITwoStepMechanism entry = new HBCITwoStepMechanism();
                entry.setSegversion(segVersion);
                String paramHeader = key.substring(0, key.lastIndexOf(46));
                for (String key2 : newBPD.keySet()) {
                    if (!key2.startsWith(paramHeader + ".")) continue;
                    int dotPos = key2.lastIndexOf(46);
                    entry.setValue(key2.substring(dotPos + 1), newBPD.get(key2));
                }
                this.twostepMechanisms.put(secfunc, entry);
            }
        }
    }

    private void searchFor3920s(List<HBCIRetVal> rets) {
        for (HBCIRetVal ret : rets) {
            if (ret.code.equals("3920")) {
                this.allowedTwostepMechanisms.clear();
                int l2 = ret.params.length;
                this.allowedTwostepMechanisms.addAll(Arrays.asList(ret.params).subList(0, l2));
                if (this.allowedTwostepMechanisms.size() > 0) {
                    this.currentSecMechInfo = this.twostepMechanisms.get(this.allowedTwostepMechanisms.get(0));
                    log.info("using secfunc: {}", (Object)this.allowedTwostepMechanisms.get(0));
                }
            }
            log.debug("autosecfunc: found 3920 in response - updated list of allowed twostepmechs with " + this.allowedTwostepMechanisms.size() + " entries");
        }
    }

    private void searchFor3072s(List<HBCIRetVal> rets) {
        for (HBCIRetVal ret : rets) {
            if (!ret.code.equals("3072")) continue;
            String newCustomerId = "";
            String newUserId = "";
            int l2 = ret.params.length;
            if (l2 > 0) {
                newUserId = ret.params[0];
                newCustomerId = ret.params[0];
            }
            if (l2 > 1) {
                newCustomerId = ret.params[1];
            }
            if (l2 <= 0) continue;
            log.debug("autosecfunc: found 3072 in response - change user id");
            StringBuffer retData = new StringBuffer();
            retData.append(newUserId).append("|").append(newCustomerId);
            this.callback.callback(41, "*** User ID changed", 2, retData);
        }
    }

    @Override
    public void postInitResponseHook(HBCIMsgStatus msgStatus) {
        if (!msgStatus.isOK()) {
            log.debug("dialog init ended with errors - searching for return code 'wrong PIN'");
            if (msgStatus.isInvalidPIN()) {
                log.info("detected 'invalid PIN' error - clearing passport PIN");
                this.clearPIN();
                StringBuffer retData = new StringBuffer();
                this.callback.callback(40, "*** invalid PIN entered", 2, retData);
            }
        }
        log.debug("autosecfunc: search for 3920s in response to detect allowed twostep secmechs");
        this.searchFor3920s(msgStatus.globStatus.getWarnings());
        this.searchFor3920s(msgStatus.segStatus.getWarnings());
        this.searchFor3072s(msgStatus.segStatus.getWarnings());
    }

    public HBCITwoStepMechanism getCurrentSecMechInfo() {
        return this.currentSecMechInfo;
    }

    public void setCurrentSecMechInfo(HBCITwoStepMechanism currentSecMechInfo) {
        this.currentSecMechInfo = currentSecMechInfo;
    }

    public HashMap<String, HBCITwoStepMechanism> getTwostepMechanisms() {
        return this.twostepMechanisms;
    }

    @Override
    public String getProfileMethod() {
        return "PIN";
    }

    @Override
    public String getProfileVersion() {
        return "2";
    }

    @Override
    public boolean needUserSig() {
        return true;
    }

    @Override
    public String getSysStatus() {
        return "1";
    }

    @Override
    public boolean hasInstSigKey() {
        return true;
    }

    @Override
    public boolean hasInstEncKey() {
        return true;
    }

    @Override
    public String getInstEncKeyName() {
        return this.getUserId();
    }

    @Override
    public String getInstEncKeyNum() {
        return "0";
    }

    @Override
    public String getInstEncKeyVersion() {
        return "0";
    }

    @Override
    public String getMySigKeyName() {
        return this.getUserId();
    }

    @Override
    public String getMySigKeyNum() {
        return "0";
    }

    @Override
    public String getMySigKeyVersion() {
        return "0";
    }

    @Override
    public void setMyPublicEncKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateEncKey(HBCIKey key) {
    }

    @Override
    public String getCryptMode() {
        return "2";
    }

    @Override
    public String getCryptAlg() {
        return "13";
    }

    @Override
    public String getCryptKeyType() {
        return "5";
    }

    @Override
    public String getSigFunction() {
        if (this.getCurrentSecMechInfo() == null) {
            return "999";
        }
        return this.getCurrentSecMechInfo().getSecfunc();
    }

    @Override
    public String getCryptFunction() {
        return "998";
    }

    @Override
    public String getSigAlg() {
        return "10";
    }

    @Override
    public String getSigMode() {
        return "16";
    }

    @Override
    public String getHashAlg() {
        return "999";
    }

    @Override
    public void setInstSigKey(HBCIKey key) {
    }

    @Override
    public void setInstEncKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicDigKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateDigKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicSigKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateSigKey(HBCIKey key) {
    }

    @Override
    public void incSigId() {
    }

    @Override
    public String getPinTanInfo(String jobHbciCode) {
        String ret = "";
        HashMap<String, String> bpd = this.getBPD();
        if (bpd != null) {
            boolean isGV = false;
            StringBuffer paramCode = new StringBuffer(jobHbciCode).replace(1, 2, "I").append("S");
            for (String key : bpd.keySet()) {
                String code2;
                if (key.startsWith("Params") && key.substring(key.indexOf(".") + 1).startsWith("PinTanPar") && key.contains(".ParPinTan.PinTanGV") && key.endsWith(".segcode")) {
                    code2 = bpd.get(key);
                    if (!jobHbciCode.equals(code2)) continue;
                    key = key.substring(0, key.length() - "segcode".length()) + "needtan";
                    ret = bpd.get(key);
                    break;
                }
                if (!key.startsWith("Params") || !key.endsWith(".SegHead.jobHbciCode") || !paramCode.equals(code2 = bpd.get(key))) continue;
                isGV = true;
            }
            if (ret.length() == 0 && !isGV) {
                if (this.verifyTANMode && jobHbciCode.equals("HKIDN")) {
                    ret = "J";
                    this.deactivateTANVerifyMode();
                } else {
                    ret = "A";
                }
            }
        }
        return ret;
    }

    private void deactivateTANVerifyMode() {
        this.verifyTANMode = false;
    }

    @Override
    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    @Override
    public String getProxyPass() {
        return this.proxypass;
    }

    @Override
    public String getProxyUser() {
        return this.proxyuser;
    }

    public boolean tanMediaNeeded() {
        HBCITwoStepMechanism secmec = this.getCurrentSecMechInfo();
        int nofactivetanmedia = secmec.getNofactivetanmedia();
        String needtanmedia = secmec.getNeedtanmedia();
        log.debug("nofactivetanmedia: " + nofactivetanmedia + ", needtanmedia: " + needtanmedia);
        return needtanmedia.equals("2");
    }

    @Override
    public String getPIN() {
        return this.pin;
    }

    public void setPIN(String pin) {
        this.pin = pin;
    }

    private void clearPIN() {
        this.setPIN(null);
    }

    public List<String> getAllowedTwostepMechanisms() {
        return this.allowedTwostepMechanisms;
    }

    public void setAllowedTwostepMechanisms(List<String> l) {
        this.allowedTwostepMechanisms = l;
    }

    @Override
    public int getMaxGVSegsPerMsg() {
        return 1;
    }
}

