/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes;

import org.kapott.hbci.datatypes.SyntaxDE;

public class SyntaxAN
extends SyntaxDE {
    public SyntaxAN(String x, int minlen, int maxlen) {
        super(x.trim(), minlen, maxlen);
    }

    protected SyntaxAN() {
    }

    public SyntaxAN(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    protected static String quote(String x) {
        int len = x.length();
        StringBuffer temp = new StringBuffer(len << 1);
        for (int i = 0; i < len; ++i) {
            char ch = x.charAt(i);
            switch (ch) {
                case '\'': 
                case '+': 
                case ':': 
                case '?': 
                case '@': {
                    temp.append('?');
                    break;
                }
            }
            temp.append(ch);
        }
        return temp.toString();
    }

    protected static String unquote(String st) {
        int len = st.length();
        StringBuffer ret = new StringBuffer(len);
        int idx = 0;
        while (idx < len) {
            char ch;
            if ((ch = st.charAt(idx++)) == '?') {
                ch = st.charAt(idx++);
            }
            ret.append(ch);
        }
        return ret.toString();
    }

    @Override
    public void init(String x, int minlen, int maxlen) {
        super.init(x.trim(), minlen, maxlen);
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    public String toString(int zero) {
        String st = this.getContent();
        return st == null ? "" : SyntaxAN.quote(st);
    }

    private void initData(StringBuffer res, int minsize, int maxsize) {
        int startidx = SyntaxAN.skipPreDelim(res);
        int endidx = SyntaxAN.findNextDelim(res, startidx);
        String st = res.substring(startidx, endidx);
        this.setContent(SyntaxAN.unquote(st), minsize, maxsize);
        res.delete(0, endidx);
    }

    @Override
    public void init(StringBuffer res, int minlen, int maxlen) {
        this.initData(res, minlen, maxlen);
    }
}

