/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;
import org.kapott.hbci.swift.Swift;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GVRKUms
extends HBCIJobResultImpl {
    private static final Logger log = LoggerFactory.getLogger(GVRKUms.class);
    public StringBuffer restMT940;
    public StringBuffer restMT942;
    private StringBuffer bufferMT940 = new StringBuffer();
    private StringBuffer bufferMT942 = new StringBuffer();
    private List<BTag> tageMT940 = new ArrayList<BTag>();
    private List<BTag> tageMT942 = new ArrayList<BTag>();
    private boolean parsed = false;

    public GVRKUms(HBCIPassportInternal passport) {
        super(passport);
        this.restMT940 = new StringBuffer();
        this.restMT942 = new StringBuffer();
    }

    public void appendMT940Data(String data) {
        this.bufferMT940.append(data);
    }

    public void appendMT942Data(String data) {
        this.bufferMT942.append(data);
    }

    public List<BTag> getDataPerDay() {
        this.verifyMT94xParsing("getDataPerDay()");
        return this.tageMT940;
    }

    public List<UmsLine> getFlatData() {
        this.verifyMT94xParsing("getFlatData()");
        ArrayList<UmsLine> result = new ArrayList<UmsLine>();
        for (BTag tag : this.tageMT940) {
            result.addAll(tag.lines);
        }
        return result;
    }

    public List<UmsLine> getFlatDataUnbooked() {
        this.verifyMT94xParsing("getFlatDataUnbooked()");
        ArrayList<UmsLine> result = new ArrayList<UmsLine>();
        for (BTag tag : this.tageMT942) {
            result.addAll(tag.lines);
        }
        return result;
    }

    @Override
    public String toString() {
        this.verifyMT94xParsing("toString()");
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        Iterator<UmsLine> i = this.getFlatData().iterator();
        while (i.hasNext()) {
            ret.append(i.next().toString()).append(linesep);
        }
        ret.append("rest: ").append(this.restMT940).append(linesep).append(linesep);
        ret.append("not yet booked:").append(linesep);
        i = this.getFlatDataUnbooked().iterator();
        while (i.hasNext()) {
            ret.append(i.next().toString()).append(linesep);
        }
        ret.append("rest: ").append(this.restMT942);
        return ret.toString().trim();
    }

    private void verifyMT94xParsing(String where) {
        if (!this.parsed) {
            this.parseMT94x(this.bufferMT940, this.tageMT940, this.restMT940);
            this.parseMT94x(this.bufferMT942, this.tageMT942, this.restMT942);
        }
        if (this.restMT940 != null && this.restMT940.length() != 0) {
            log.warn(where + ": mt940 has not been parsed successfully - probably returned data will be incomplete. check variable 'restMT940' (or set logging level to 4 (=DEBUG)) to see the data that could not be parsed.");
            log.debug("restMT940: " + this.restMT940);
        }
        if (this.restMT942 != null && this.restMT942.length() != 0) {
            log.warn(where + ": mt942 has not been parsed successfully - probably returned data will be incomplete. check variable 'restMT942' (or set logging level to 4 (=DEBUG)) to see the data that could not be parsed.");
            log.debug("restMT942: " + this.restMT942);
        }
    }

    private void parseMT94x(StringBuffer buffer, List<BTag> tage, StringBuffer rest) {
        log.debug("now parsing MT94x data");
        this.parsed = true;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd");
            HBCIPassportInternal passport = this.getPassport();
            while (buffer.length() != 0) {
                int numLines;
                String st_ums;
                String curr;
                String iban;
                String number;
                String blz;
                String st_tag = Swift.getOneBlock(buffer);
                if (st_tag == null) {
                    break;
                }
                BTag btag = new BTag();
                String konto_info = Swift.getTagValue(st_tag, "25", 0);
                int pos = konto_info.indexOf("/");
                if (pos != -1) {
                    char ch;
                    blz = konto_info.substring(0, pos);
                    number = konto_info.substring(pos + 1);
                    iban = "";
                    curr = "";
                    for (pos = number.length(); pos > 0 && ((ch = number.charAt(pos - 1)) < '0' || ch > '9'); --pos) {
                    }
                    if (pos < number.length()) {
                        curr = number.substring(pos);
                        number = number.substring(0, pos);
                    }
                } else {
                    blz = "";
                    number = "";
                    iban = konto_info;
                    curr = "";
                }
                btag.my = new Konto();
                btag.my.blz = blz;
                btag.my.number = number;
                btag.my.iban = iban;
                btag.my.curr = curr;
                if (passport != null) {
                    passport.fillAccountInfo(btag.my);
                }
                btag.counter = Swift.getTagValue(st_tag, "28C", 0);
                String st_start = Swift.getTagValue(st_tag, "60F", 0);
                int starttype = 70;
                if (st_start == null) {
                    st_start = Swift.getTagValue(st_tag, "60M", 0);
                    starttype = 77;
                }
                if (st_start != null) {
                    btag.start = new Saldo();
                    btag.starttype = (char)starttype;
                    String cd = st_start.substring(0, 1);
                    try {
                        btag.start.timestamp = dateFormat.parse(st_start.substring(1, 7));
                    }
                    catch (Exception e) {
                        btag.start.timestamp = null;
                    }
                    btag.start.value = new Value((cd.equals("D") ? "-" : "") + st_start.substring(10).replace(',', '.'), st_start.substring(7, 10));
                }
                long saldo = btag.start != null ? btag.start.value.getLongValue() : 0L;
                int ums_counter = 0;
                while ((st_ums = Swift.getTagValue(st_tag, "61", ums_counter)) != null) {
                    String st_multi;
                    String cd;
                    UmsLine line = new UmsLine();
                    line.valuta = dateFormat.parse(st_ums.substring(0, 6));
                    int next = 0;
                    if (st_ums.charAt(6) > '9') {
                        line.bdate = btag.start != null && btag.start.timestamp != null ? btag.start.timestamp : line.valuta;
                        next = 6;
                    } else {
                        line.bdate = dateFormat.parse(st_ums.substring(0, 2) + st_ums.substring(6, 10));
                        if (Math.abs(line.bdate.getTime() - line.valuta.getTime()) > 15552000000L) {
                            int diff = line.bdate.before(line.valuta) ? 1 : -1;
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(line.bdate);
                            cal.set(1, cal.get(1) + diff);
                            line.bdate = cal.getTime();
                        }
                        next = 10;
                    }
                    if (st_ums.charAt(next) == 'C' || st_ums.charAt(next) == 'D') {
                        line.isStorno = false;
                        cd = st_ums.substring(next, next + 1);
                        ++next;
                    } else {
                        line.isStorno = true;
                        cd = st_ums.substring(next + 1, next + 2);
                        next += 2;
                    }
                    char currpart = st_ums.charAt(next);
                    if (currpart > '9') {
                        ++next;
                    }
                    (line.value = new Value()).setCurr(btag.start != null ? btag.start.value.getCurr() : "EUR");
                    int npos = st_ums.indexOf("N", next);
                    String negValueIndikator = line.isStorno ? "C" : "D";
                    line.value.setValue(HBCIUtils.string2Long((cd.equals(negValueIndikator) ? "-" : "") + st_ums.substring(next, npos).replace(',', '.'), 100L));
                    next = npos + 4;
                    line.saldo = new Saldo();
                    line.saldo.timestamp = line.bdate;
                    line.saldo.value = new Value(saldo += line.value.getLongValue(), btag.start != null ? btag.start.value.getCurr() : "EUR");
                    npos = st_ums.indexOf("//", next);
                    if (npos == -1) {
                        npos = st_ums.indexOf("\r\n", next);
                    }
                    if (npos == -1) {
                        npos = st_ums.length();
                    }
                    line.customerref = st_ums.substring(next, npos);
                    next = npos;
                    if (next < st_ums.length() && st_ums.substring(next, next + 2).equals("//")) {
                        npos = st_ums.indexOf("\r\n", next += 2);
                        if (npos == -1) {
                            npos = st_ums.length();
                        }
                        line.instref = st_ums.substring(next, npos);
                        next = npos + 2;
                    }
                    if (line.instref == null) {
                        line.instref = "";
                    }
                    if (next < st_ums.length() && st_ums.charAt(next) == '\r') {
                        int slashpos;
                        pos = st_ums.indexOf("/OCMT/", next += 2);
                        if (pos != -1) {
                            slashpos = st_ums.indexOf("/", pos + 9);
                            if (slashpos == -1) {
                                slashpos = st_ums.length();
                            }
                            try {
                                line.orig_value = new Value(st_ums.substring(pos + 9, slashpos).replace(',', '.'), st_ums.substring(pos + 6, pos + 9));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if ((pos = st_ums.indexOf("/CHGS/", next)) != -1) {
                            slashpos = st_ums.indexOf("/", pos + 9);
                            if (slashpos == -1) {
                                slashpos = st_ums.length();
                            }
                            try {
                                line.charge_value = new Value(st_ums.substring(pos + 9, slashpos).replace(',', '.'), st_ums.substring(pos + 6, pos + 9));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    if ((st_multi = Swift.getTagValue(st_tag, "86", ums_counter)) != null) {
                        line.gvcode = st_multi.substring(0, 3);
                        st_multi = Swift.packMulti(st_multi.substring(3));
                        if (!line.gvcode.equals("999")) {
                            int space;
                            line.isSepa = line.gvcode.startsWith("1");
                            line.text = Swift.getMultiTagValue(st_multi, "00");
                            line.primanota = Swift.getMultiTagValue(st_multi, "10");
                            for (int i = 0; i < 10; ++i) {
                                line.addUsage(Swift.getMultiTagValue(st_multi, Integer.toString(20 + i)));
                            }
                            Konto acc = new Konto();
                            acc.blz = Swift.getMultiTagValue(st_multi, "30");
                            acc.number = Swift.getMultiTagValue(st_multi, "31");
                            if (acc.blz != null && (space = acc.blz.indexOf(" ")) != -1) {
                                log.debug("blz/bic \"" + acc.blz + "\" contains invalid chars, trimming after first space");
                                acc.blz = acc.blz.substring(0, space);
                            }
                            if (line.isSepa) {
                                acc.bic = acc.blz;
                                acc.iban = acc.number;
                            }
                            acc.name = Swift.getMultiTagValue(st_multi, "32");
                            acc.name2 = Swift.getMultiTagValue(st_multi, "33");
                            if (acc.blz != null || acc.number != null || acc.name != null || acc.name2 != null) {
                                if (acc.blz == null) {
                                    acc.blz = "";
                                }
                                if (acc.number == null) {
                                    acc.number = "";
                                }
                                if (acc.name == null) {
                                    acc.name = "";
                                }
                                line.other = acc;
                            }
                            line.addkey = Swift.getMultiTagValue(st_multi, "34");
                            for (int i = 0; i < 4; ++i) {
                                line.addUsage(Swift.getMultiTagValue(st_multi, Integer.toString(60 + i)));
                            }
                        } else {
                            line.additional = st_multi;
                        }
                    }
                    btag.addLine(line);
                    ++ums_counter;
                }
                String st_end = Swift.getTagValue(st_tag, "62F", 0);
                int endtype = 70;
                btag.endtype = (char)70;
                if (st_end == null) {
                    st_end = Swift.getTagValue(st_tag, "62M", 0);
                    endtype = 77;
                }
                if (st_end != null) {
                    btag.end = new Saldo();
                    btag.endtype = (char)endtype;
                    String cd = st_end.substring(0, 1);
                    try {
                        btag.end.timestamp = dateFormat.parse(st_end.substring(1, 7));
                    }
                    catch (Exception e) {
                        btag.end.timestamp = null;
                    }
                    if (btag.start != null && btag.start.timestamp == null) {
                        btag.start.timestamp = btag.end.timestamp;
                    }
                    for (UmsLine line : btag.lines) {
                        if (line.bdate != null) continue;
                        line.bdate = btag.end.timestamp;
                    }
                    btag.end.value = new Value((cd.equals("D") ? "-" : "") + st_end.substring(10).replaceAll("\\s", "").replace(',', '.'), st_end.substring(7, 10));
                }
                if ((numLines = btag.lines.size()) > 0 && btag.end != null) {
                    UmsLine lastLine = btag.lines.get(numLines - 1);
                    saldo = btag.end.value.getLongValue();
                    if (lastLine.saldo.value.getLongValue() != saldo) {
                        for (int i = numLines - 1; i >= 0; --i) {
                            lastLine = btag.lines.get(i);
                            lastLine.saldo.value = new Value(saldo, btag.end.value.getCurr());
                            saldo -= lastLine.value.getLongValue();
                        }
                    }
                }
                tage.add(btag);
                buffer.delete(0, st_tag.length());
            }
        }
        catch (Exception e) {
            log.error("There is unparsed MT94x data - an exception occured while parsing");
            log.debug("current MT94x buffer: " + buffer);
            throw new HBCI_Exception(e);
        }
        finally {
            rest.setLength(0);
            rest.append(buffer.toString());
        }
    }

    public static class BTag
    implements Serializable {
        public Konto my;
        public String counter;
        public Saldo start;
        public char starttype;
        public List<UmsLine> lines = new ArrayList<UmsLine>();
        public Saldo end;
        public char endtype;

        public void addLine(UmsLine line) {
            this.lines.add(line);
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            String linesep = System.getProperty("line.separator");
            ret.append("Konto ").append(this.my.toString()).append(" - Auszugsnummer ").append(this.counter).append(linesep);
            ret.append("  ").append(this.starttype == 'F' ? "Anfangs" : "Zwischen").append("saldo: ").append(this.start.toString()).append(linesep);
            Iterator<UmsLine> i = this.lines.iterator();
            while (i.hasNext()) {
                ret.append("  ").append(i.next().toString()).append(linesep);
            }
            ret.append("  ").append(this.endtype == 'F' ? "Schluss" : "Zwischen").append("saldo: ").append(this.end.toString());
            return ret.toString().trim();
        }
    }

    public static class UmsLine
    implements Serializable {
        public Date valuta;
        public Date bdate;
        public Value value;
        public boolean isStorno;
        public Saldo saldo;
        public String customerref;
        public String instref;
        public Value orig_value;
        public Value charge_value;
        public String gvcode;
        public String additional;
        public String text;
        public String primanota;
        public List<String> usage = new ArrayList<String>();
        public Konto other;
        public String addkey;
        public boolean isSepa = false;

        public void addUsage(String st) {
            if (st != null) {
                this.usage.add(st);
            }
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            String linesep = System.getProperty("line.separator");
            ret.append(HBCIUtils.date2StringLocal(this.valuta)).append(" ").append(HBCIUtils.date2StringLocal(this.bdate)).append(" ");
            ret.append(this.customerref).append(":").append(this.instref).append(" ");
            ret.append(this.value.toString());
            ret.append(this.isStorno ? " (Storno)" : "");
            if (this.orig_value != null) {
                ret.append(" (orig ").append(this.orig_value.toString()).append(")");
            }
            if (this.charge_value != null) {
                ret.append(" (charge ").append(this.charge_value.toString()).append(")");
            }
            ret.append(linesep);
            ret.append("    saldo: ").append(this.saldo.toString()).append(linesep);
            ret.append("    code ").append(this.gvcode).append(linesep);
            if (this.additional == null) {
                ret.append("    text:").append(this.text).append(linesep);
                ret.append("    primanota:").append(this.primanota).append(linesep);
                Iterator<String> i = this.usage.iterator();
                while (i.hasNext()) {
                    ret.append("    usage:").append(i.next()).append(linesep);
                }
                if (this.other != null) {
                    ret.append("    konto:").append(this.other.toString()).append(linesep);
                }
                ret.append("    addkey:").append(this.addkey);
            } else {
                ret.append("    ").append(this.additional);
            }
            return ret.toString().trim();
        }
    }
}

