/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.text.DecimalFormat;
import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRDauerNew;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public final class GVDauerNew
extends AbstractHBCIJob {
    public GVDauerNew(HBCIPassportInternal passport) {
        super(passport, GVDauerNew.getLowlevelName(), new GVRDauerNew(passport));
        this.addConstraint("src.number", "My.number", null);
        this.addConstraint("src.subnumber", "My.subnumber", "");
        this.addConstraint("dst.blz", "Other.KIK.blz", null);
        this.addConstraint("dst.number", "Other.number", null);
        this.addConstraint("dst.subnumber", "Other.subnumber", "");
        this.addConstraint("btg.value", "BTG.value", null);
        this.addConstraint("btg.curr", "BTG.curr", null);
        this.addConstraint("name", "name", null);
        this.addConstraint("firstdate", "DauerDetails.firstdate", null);
        this.addConstraint("timeunit", "DauerDetails.timeunit", null);
        this.addConstraint("turnus", "DauerDetails.turnus", null);
        this.addConstraint("execday", "DauerDetails.execday", null);
        this.addConstraint("src.blz", "My.KIK.blz", null);
        this.addConstraint("src.country", "My.KIK.country", "DE");
        this.addConstraint("dst.country", "Other.KIK.country", "DE");
        this.addConstraint("name2", "name2", "");
        this.addConstraint("lastdate", "DauerDetails.lastdate", "");
        this.addConstraint("key", "key", "52");
        HashMap<String, String> parameters = this.getJobRestrictions();
        int maxusage = Integer.parseInt(parameters.get("maxusage"));
        for (int i = 0; i < maxusage; ++i) {
            String name = HBCIUtils.withCounter("usage", i);
            this.addConstraint(name, "usage." + name, "");
        }
    }

    public static String getLowlevelName() {
        return "DauerNew";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        String orderid = result.get(header + ".orderid");
        ((GVRDauerNew)this.jobResult).setOrderId(orderid);
        if (orderid != null && orderid.length() != 0) {
            HashMap p2 = new HashMap();
            this.getLowlevelParams().forEach((key, value) -> p2.put(key.substring(key.indexOf(".") + 1), value));
        }
    }

    @Override
    public void setParam(String paramName, String value) {
        HashMap<String, String> res = this.getJobRestrictions();
        if (paramName.equals("timeunit")) {
            if (!value.equals("W") && !value.equals("M")) {
                String msg = HBCIUtils.getLocMsg("EXCMSG_INV_TIMEUNIT", value);
                throw new InvalidUserDataException(msg);
            }
        } else if (paramName.equals("turnus")) {
            String timeunit = this.getLowlevelParams().get(this.getName() + ".DauerDetails.timeunit");
            if (timeunit != null) {
                String st;
                if (timeunit.equals("W")) {
                    String st2 = res.get("turnusweeks");
                    if (st2 != null) {
                        String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                        if (!st2.equals("00") && !this.twoDigitValueInList(value2, st2)) {
                            String msg = HBCIUtils.getLocMsg("EXCMSG_INV_TURNUS", value);
                            throw new InvalidUserDataException(msg);
                        }
                    }
                } else if (timeunit.equals("M") && (st = res.get("turnusmonths")) != null) {
                    String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                    if (!st.equals("00") && !this.twoDigitValueInList(value2, st)) {
                        String msg = HBCIUtils.getLocMsg("EXCMSG_INV_TURNUS", value);
                        throw new InvalidUserDataException(msg);
                    }
                }
            }
        } else if (paramName.equals("execday")) {
            String timeunit = this.getLowlevelParams().get(this.getName() + ".DauerDetails.timeunit");
            if (timeunit != null) {
                String st;
                if (timeunit.equals("W")) {
                    String st3 = res.get("daysperweek");
                    if (st3 != null && !st3.equals("0") && st3.indexOf(value) == -1) {
                        String msg = HBCIUtils.getLocMsg("EXCMSG_INV_EXECDAY", value);
                        throw new InvalidUserDataException(msg);
                    }
                } else if (timeunit.equals("M") && (st = res.get("dayspermonth")) != null) {
                    String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                    if (!st.equals("00") && !this.twoDigitValueInList(value2, st)) {
                        String msg = HBCIUtils.getLocMsg("EXCMSG_INV_EXECDAY", value);
                        throw new InvalidUserDataException(msg);
                    }
                }
            }
        } else if (paramName.equals("key")) {
            String st;
            boolean atLeastOne = false;
            boolean found = false;
            int i = 0;
            while ((st = res.get(HBCIUtils.withCounter("textkey", i))) != null) {
                atLeastOne = true;
                if (st.equals(value)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (atLeastOne && !found) {
                String msg = HBCIUtils.getLocMsg("EXCMSG_INV_KEY", value);
                throw new InvalidUserDataException(msg);
            }
        }
        super.setParam(paramName, value);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("src");
        this.checkAccountCRC("dst");
    }
}

