/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.smartcardio;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.kapott.hbci.exceptions.HBCI_Exception;

public class RSABankData {
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private int index;
    private String country;
    private String bankCode;
    private String userId;
    private int comService;
    private String comAddress;
    private String comSuffix;
    private String bankId;
    private String systemId;
    private String customerId;

    public RSABankData() {
    }

    public RSABankData(int index, byte[] record, byte[] customerIdData) {
        this.index = index;
        this.country = new String(record, 0, 3, CHARSET).trim();
        this.bankCode = new String(record, 3, 30, CHARSET).trim();
        this.userId = new String(record, 33, 30, CHARSET).trim();
        this.comService = record[63];
        this.comAddress = new String(record, 64, 28, CHARSET).trim();
        this.comSuffix = new String(record, 92, 2, CHARSET).trim();
        this.bankId = new String(record, 94, 30, CHARSET).trim();
        this.systemId = new String(record, 124, 30, CHARSET).trim();
        this.customerId = customerIdData == null ? "" : new String(customerIdData, CHARSET).trim();
    }

    private void fillRecord(byte[] record, int offset, int length, String value) {
        byte[] bytes = value.getBytes(CHARSET);
        if (bytes.length > length) {
            throw new HBCI_Exception("string value for bank data record at offset " + offset + " is " + bytes.length + " bytes long but must not be longer than " + length + " bytes");
        }
        Arrays.fill(record, offset, offset + length, (byte)32);
        System.arraycopy(bytes, 0, record, offset, bytes.length);
    }

    public byte[] toRecord() {
        byte[] result = new byte[154];
        this.fillRecord(result, 0, 3, this.country);
        this.fillRecord(result, 3, 30, this.bankCode);
        this.fillRecord(result, 33, 30, this.userId);
        result[63] = (byte)(this.comService & 0xFF);
        this.fillRecord(result, 64, 28, this.comAddress);
        this.fillRecord(result, 92, 2, this.comSuffix);
        this.fillRecord(result, 94, 30, this.bankId);
        this.fillRecord(result, 124, 30, this.systemId);
        return result;
    }

    public byte[] toCustomerIdData() {
        byte[] result = new byte[30];
        this.fillRecord(result, 0, 30, this.customerId);
        return result;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public int getComService() {
        return this.comService;
    }

    public void setComService(int comService) {
        this.comService = comService;
    }

    public String getComAddress() {
        return this.comAddress;
    }

    public void setComAddress(String comAddress) {
        this.comAddress = comAddress;
    }

    public String getComSuffix() {
        return this.comSuffix;
    }

    public void setComSuffix(String comSuffix) {
        this.comSuffix = comSuffix;
    }

    public String getBankId() {
        return this.bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String toString() {
        return "index=" + this.index + " country=" + this.country + " bankCode=" + this.bankCode + " userId=" + this.userId + " comService=" + this.comService + " comAddress=" + this.comAddress + " comSuffix=" + this.comSuffix + " bankId=" + this.bankId + " systemId=" + this.systemId + " customerId=" + this.customerId;
    }
}

