/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.security;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.MSG;
import org.kapott.hbci.protocol.MultipleSEGs;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SEG;
import org.kapott.hbci.protocol.SyntaxElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Sig {
    public static final String SECFUNC_HBCI_SIG_RDH = "1";
    public static final String SECFUNC_HBCI_SIG_DDV = "2";
    public static final String SECFUNC_FINTS_SIG_DIG = "1";
    public static final String SECFUNC_FINTS_SIG_SIG = "2";
    public static final String SECFUNC_SIG_PT_1STEP = "999";
    public static final String SECFUNC_SIG_PT_2STEP_MIN = "900";
    public static final String SECFUNC_SIG_PT_2STEP_MAX = "997";
    public static final String HASHALG_SHA1 = "1";
    public static final String HASHALG_SHA256 = "3";
    public static final String HASHALG_SHA384 = "4";
    public static final String HASHALG_SHA512 = "5";
    public static final String HASHALG_SHA256_SHA256 = "6";
    public static final String HASHALG_RIPEMD160 = "999";
    public static final String SIGALG_DES = "1";
    public static final String SIGALG_RSA = "10";
    public static final String SIGMODE_ISO9796_1 = "16";
    public static final String SIGMODE_ISO9796_2 = "17";
    public static final String SIGMODE_PKCS1 = "18";
    public static final String SIGMODE_PSS = "19";
    public static final String SIGMODE_RETAIL_MAC = "999";
    private MSG msg;
    private String u_secfunc;
    private String u_cid;
    private String u_role;
    private String u_range;
    private String u_keyblz;
    private String u_keycountry;
    private String u_keyuserid;
    private String u_keynum;
    private String u_keyversion;
    private String u_sysid;
    private String u_sigid;
    private String u_sigalg;
    private String u_sigmode;
    private String u_hashalg;
    private String sigstring;

    public Sig(MSG msg) {
        this.msg = msg;
    }

    private void fillSigHead(HBCIPassportInternal passport, SEG sighead) {
        String sigheadName = sighead.getPath();
        String seccheckref = Integer.toString(Math.abs(new Random().nextInt()));
        Date d = new Date();
        sighead.propagateValue(sigheadName + ".secfunc", this.u_secfunc, false, false);
        sighead.propagateValue(sigheadName + ".seccheckref", seccheckref, false, false);
        sighead.propagateValue(sigheadName + ".role", this.u_role, false, false);
        sighead.propagateValue(sigheadName + ".SecIdnDetails.func", this.msg.getName().endsWith("Res") ? "2" : "1", false, false);
        if (this.u_cid.length() != 0) {
            sighead.propagateValue(sigheadName + ".SecIdnDetails.cid", "B" + this.u_cid, false, false);
        } else {
            sighead.propagateValue(sigheadName + ".SecIdnDetails.sysid", this.u_sysid, false, false);
        }
        sighead.propagateValue(sigheadName + ".SecTimestamp.date", HBCIUtils.date2StringISO(d), false, false);
        sighead.propagateValue(sigheadName + ".SecTimestamp.time", HBCIUtils.time2StringISO(d), false, false);
        sighead.propagateValue(sigheadName + ".secref", this.u_sigid, false, false);
        sighead.propagateValue(sigheadName + ".HashAlg.alg", this.u_hashalg, false, false);
        sighead.propagateValue(sigheadName + ".SigAlg.alg", this.u_sigalg, false, false);
        sighead.propagateValue(sigheadName + ".SigAlg.mode", this.u_sigmode, false, false);
        sighead.propagateValue(sigheadName + ".KeyName.KIK.country", this.u_keycountry, false, false);
        sighead.propagateValue(sigheadName + ".KeyName.KIK.blz", this.u_keyblz, false, false);
        sighead.propagateValue(sigheadName + ".KeyName.userid", this.u_keyuserid, false, false);
        sighead.propagateValue(sigheadName + ".KeyName.keynum", this.u_keynum, false, false);
        sighead.propagateValue(sigheadName + ".KeyName.keyversion", this.u_keyversion, false, false);
        sighead.propagateValue(sigheadName + ".SecProfile.method", passport.getProfileMethod(), false, false);
        sighead.propagateValue(sigheadName + ".SecProfile.version", passport.getProfileVersion(), false, false);
    }

    private void fillSigTail(SEG sighead, SEG sigtail) {
        String sigtailName = sigtail.getPath();
        sigtail.propagateValue(sigtailName + ".seccheckref", sighead.getValueOfDE(sighead.getPath() + ".seccheckref"), false, false);
    }

    private String collectHashData(int idx) {
        int i;
        int numOfPassports = 1;
        StringBuffer ret = new StringBuffer(1024);
        List<MultipleSyntaxElements> msgelementslist = this.msg.getChildContainers();
        List<SyntaxElement> sigheads = ((MultipleSEGs)msgelementslist.get(1)).getElements();
        List<SyntaxElement> sigtails = ((MultipleSEGs)msgelementslist.get(msgelementslist.size() - 2)).getElements();
        for (i = numOfPassports - 1 - idx; i < (this.u_range.equals("1") ? numOfPassports - idx : numOfPassports); ++i) {
            ret.append(((SEG)sigheads.get(i)).toString(0));
        }
        for (i = 2; i < msgelementslist.size() - 2; ++i) {
            ret.append(msgelementslist.get(i).toString(0));
        }
        for (i = 0; i < (this.u_range.equals("1") ? 0 : idx); ++i) {
            ret.append(((SEG)sigtails.get(i)).toString(0));
        }
        return ret.toString();
    }

    public boolean signIt(HBCIPassportInternal passport, MsgGen gen) {
        boolean ret = false;
        if (passport.hasMySigKey()) {
            String msgName = this.msg.getName();
            Node msgNode = this.msg.getSyntaxDef(msgName, gen.getSyntax());
            String dontsignAttr = ((Element)msgNode).getAttribute("dontsign");
            if (dontsignAttr.length() == 0) {
                try {
                    List<MultipleSyntaxElements> msgelements;
                    int idx;
                    int numOfPassports = 1;
                    for (idx = 0; idx < numOfPassports; ++idx) {
                        int i;
                        SEG sighead = new SEG("SigHeadUser", "SigHead", msgName, numOfPassports - 1 - idx, gen.getSyntax());
                        SEG sigtail = new SEG("SigTailUser", "SigTail", msgName, idx, gen.getSyntax());
                        List<MultipleSyntaxElements> msgelements2 = this.msg.getChildContainers();
                        List<SyntaxElement> sigheads = ((MultipleSEGs)msgelements2.get(1)).getElements();
                        List<SyntaxElement> sigtails = ((MultipleSEGs)msgelements2.get(msgelements2.size() - 2)).getElements();
                        if (numOfPassports - 1 - idx >= sigheads.size()) {
                            for (i = sigheads.size() - 1; i < numOfPassports - 1 - idx; ++i) {
                                sigheads.add(null);
                            }
                        }
                        sigheads.set(numOfPassports - 1 - idx, sighead);
                        if (idx >= sigtails.size()) {
                            for (i = sigtails.size() - 1; i < idx; ++i) {
                                sigtails.add(null);
                            }
                        }
                        sigtails.set(idx, sigtail);
                    }
                    for (idx = 0; idx < numOfPassports; ++idx) {
                        this.setParam("secfunc", passport.getSigFunction());
                        this.setParam("cid", passport.getCID());
                        this.setParam("role", "1");
                        this.setParam("range", "1");
                        this.setParam("keyblz", passport.getBLZ());
                        this.setParam("keycountry", passport.getCountry());
                        this.setParam("keyuserid", passport.getMySigKeyName());
                        this.setParam("keynum", passport.getMySigKeyNum());
                        this.setParam("keyversion", passport.getMySigKeyVersion());
                        this.setParam("sysid", passport.getSysId());
                        this.setParam("sigid", passport.getSigId().toString());
                        this.setParam("sigalg", passport.getSigAlg());
                        this.setParam("sigmode", passport.getSigMode());
                        this.setParam("hashalg", passport.getHashAlg());
                        passport.incSigId();
                        msgelements = this.msg.getChildContainers();
                        List<SyntaxElement> sigheads = ((MultipleSEGs)msgelements.get(1)).getElements();
                        List<SyntaxElement> sigtails = ((MultipleSEGs)msgelements.get(msgelements.size() - 2)).getElements();
                        SEG sighead = (SEG)sigheads.get(numOfPassports - 1 - idx);
                        SEG sigtail = (SEG)sigtails.get(idx);
                        this.fillSigHead(passport, sighead);
                        this.fillSigTail(sighead, sigtail);
                    }
                    this.msg.enumerateSegs(0, true);
                    this.msg.validate();
                    this.msg.enumerateSegs(1, true);
                    for (idx = 0; idx < numOfPassports; ++idx) {
                        msgelements = this.msg.getChildContainers();
                        List<SyntaxElement> sigtails = ((MultipleSEGs)msgelements.get(msgelements.size() - 2)).getElements();
                        SEG sigtail = (SEG)sigtails.get(idx);
                        String hashdata = this.collectHashData(idx);
                        byte[] hashresult = passport.hash(hashdata.getBytes("ISO-8859-1"));
                        byte[] signature = passport.sign(hashresult);
                        if (passport.needUserSig()) {
                            String pintan = new String(signature, "ISO-8859-1");
                            int pos = pintan.indexOf("|");
                            if (pos != -1) {
                                String pin = pintan.substring(0, pos);
                                this.msg.propagateValue(sigtail.getPath() + ".UserSig.pin", pin, false, false);
                                if (pos < pintan.length() - 1) {
                                    String tan = pintan.substring(pos + 1);
                                    this.msg.propagateValue(sigtail.getPath() + ".UserSig.tan", tan, false, false);
                                }
                            }
                        } else {
                            this.msg.propagateValue(sigtail.getPath() + ".sig", "B" + new String(signature, "ISO-8859-1"), false, false);
                        }
                        this.msg.validate();
                        this.msg.enumerateSegs(1, true);
                        this.msg.autoSetMsgSize(gen);
                    }
                }
                catch (Exception ex) {
                    throw new HBCI_Exception("*** error while signing", ex);
                }
            } else {
                HBCIUtils.log("did not sign - message does not want to be signed", 4);
            }
            ret = true;
        } else {
            HBCIUtils.log("can not sign - no signature key available", 2);
        }
        return ret;
    }

    private void readSigHead(HBCIPassportInternal passport) {
        String errmsg;
        String sigheadName = this.msg.getName() + ".SigHead";
        this.u_secfunc = this.msg.getValueOfDE(sigheadName + ".secfunc");
        this.u_role = this.msg.getValueOfDE(sigheadName + ".role");
        this.u_range = this.msg.getValueOfDE(sigheadName + ".range");
        this.u_keycountry = this.msg.getValueOfDE(sigheadName + ".KeyName.KIK.country");
        this.u_keyuserid = this.msg.getValueOfDE(sigheadName + ".KeyName.userid");
        this.u_keynum = this.msg.getValueOfDE(sigheadName + ".KeyName.keynum");
        this.u_keyversion = this.msg.getValueOfDE(sigheadName + ".KeyName.keyversion");
        this.u_sigid = this.msg.getValueOfDE(sigheadName + ".secref");
        this.u_sigalg = this.msg.getValueOfDE(sigheadName + ".SigAlg.alg");
        this.u_sigmode = this.msg.getValueOfDE(sigheadName + ".SigAlg.mode");
        this.u_hashalg = this.msg.getValueOfDE(sigheadName + ".HashAlg.alg");
        try {
            this.u_keyblz = this.msg.getValueOfDE(sigheadName + ".KeyName.KIK.blz");
        }
        catch (Exception e) {
            HBCIUtils.log("missing bank code in message signature, ignoring...", 2);
        }
        if (passport.needUserSig()) {
            Hashtable<String, String> values = new Hashtable<String, String>();
            this.msg.extractValues(values);
            String pin = values.get(this.msg.getName() + ".SigTail.UserSig.pin");
            String tan = values.get(this.msg.getName() + ".SigTail.UserSig.tan");
            this.sigstring = (pin != null ? pin : "") + "|" + (tan != null ? tan : "");
        } else {
            this.sigstring = this.msg.getValueOfDE(this.msg.getName() + ".SigTail.sig");
        }
        String checkref = this.msg.getValueOfDE(this.msg.getName() + ".SigHead.seccheckref");
        String checkref2 = this.msg.getValueOfDE(this.msg.getName() + ".SigTail.seccheckref");
        if (!(checkref != null && checkref.equals(checkref2) || HBCIUtils.ignoreError(null, "client.errors.ignoreSignErrors", errmsg = HBCIUtils.getLocMsg("EXCMSG_SIGREFFAIL")))) {
            throw new HBCI_Exception(errmsg);
        }
    }

    private boolean hasSig(MsgGen gen) {
        boolean ret = true;
        MultipleSyntaxElements seglist = this.msg.getChildContainers().get(1);
        if (seglist instanceof MultipleSEGs) {
            SEG sighead = null;
            try {
                sighead = (SEG)seglist.getElements().get(0);
            }
            catch (IndexOutOfBoundsException e) {
                ret = false;
            }
            if (ret) {
                String sigheadCode = "HNSHK";
                if (!sighead.getCode(gen).equals(sigheadCode)) {
                    ret = false;
                }
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public boolean verify(HBCIPassportInternal passport, MsgGen gen) {
        boolean ret = false;
        if (passport.hasInstSigKey()) {
            String msgName = this.msg.getName();
            Node msgNode = this.msg.getSyntaxDef(msgName, gen.getSyntax());
            String dontsignAttr = ((Element)msgNode).getAttribute("dontsign");
            if (dontsignAttr.length() == 0) {
                if (this.hasSig(gen)) {
                    this.readSigHead(passport);
                    try {
                        String hashdata = this.collectHashData(0);
                        byte[] hashresult = passport.hash(hashdata.getBytes("ISO-8859-1"));
                        ret = passport.verify(hashresult, this.sigstring.getBytes("ISO-8859-1"));
                    }
                    catch (Exception e) {
                        ret = false;
                    }
                } else {
                    HBCIUtils.log("message has no signature", 2);
                    ret = true;
                }
            } else {
                HBCIUtils.log("message does not need a signature", 4);
                ret = true;
            }
        } else {
            HBCIUtils.log("can not check signature - no signature key available", 2);
            ret = true;
        }
        return ret;
    }

    public void setParam(String key, String value) {
        try {
            Field f = this.getClass().getDeclaredField("u_" + key);
            HBCIUtils.log("setting " + key + " to " + value, 4);
            f.set(this, value);
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** error while setting sig parameter", ex);
        }
    }
}

