/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.datatypes.factory.SyntaxDEFactory;
import org.kapott.hbci.exceptions.NoValidValueException;
import org.kapott.hbci.exceptions.NoValueGivenException;
import org.kapott.hbci.exceptions.OverwriteException;
import org.kapott.hbci.exceptions.ParseErrorException;
import org.kapott.hbci.exceptions.PredelimErrorException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SyntaxElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DE
extends SyntaxElement {
    private SyntaxDE value;
    private int minsize;
    private int maxsize;
    private List<String> valids;

    @Override
    protected MultipleSyntaxElements createNewChildContainer(Node dedef, Document syntax) {
        return null;
    }

    @Override
    protected String getElementTypeName() {
        return "DE";
    }

    @Override
    public boolean propagateValue(String destPath, String valueString, boolean tryToCreate, boolean allowOverwrite) {
        boolean ret = false;
        if (destPath.equals(this.getPath())) {
            if (this.value != null && !allowOverwrite && !HBCIUtils.ignoreError(null, "client.errors.allowOverwrites", "*** trying to overwrite " + this.getPath() + "=" + this.value.toString() + " with " + valueString)) {
                throw new OverwriteException(this.getPath(), this.value.toString(), valueString);
            }
            this.setValue(valueString);
            ret = true;
        }
        return ret;
    }

    @Override
    public String getValueOfDE(String path) {
        String ret = null;
        if (path.equals(this.getPath())) {
            ret = this.value.toString();
        }
        return ret;
    }

    @Override
    public String getValueOfDE(String path, int zero) {
        String ret = null;
        if (path.equals(this.getPath())) {
            ret = this.value.toString(0);
        }
        return ret;
    }

    private void initData(Node dedef, String name, String path, int idx, Document syntax) {
        this.value = null;
        this.valids = new ArrayList<String>();
        this.minsize = 1;
        String st = ((Element)dedef).getAttribute("minsize");
        if (st.length() != 0) {
            this.minsize = Integer.parseInt(st);
        }
        this.maxsize = 0;
        st = ((Element)dedef).getAttribute("maxsize");
        if (st.length() != 0) {
            this.maxsize = Integer.parseInt(st);
        }
    }

    public DE(Node dedef, String name, String path, int idx, Document syntax) {
        super(((Element)dedef).getAttribute("type"), name, path, idx, null);
        this.initData(dedef, name, path, idx, syntax);
    }

    public void init(Node dedef, String name, String path, int idx, Document syntax) {
        super.init(((Element)dedef).getAttribute("type"), name, path, idx, null);
        this.initData(dedef, name, path, idx, syntax);
    }

    @Override
    public void validate() {
        if (this.value == null) {
            throw new NoValueGivenException(this.getPath());
        }
        int validssize = this.valids.size();
        if (validssize != 0) {
            boolean ok = false;
            String valString = this.value != null ? this.value.toString() : "";
            for (int i = 0; i < validssize; ++i) {
                if (!this.valids.get(i).equals(valString)) continue;
                ok = true;
                break;
            }
            if (!ok && !HBCIUtils.ignoreError(null, "client.errors.ignoreValidValueErrors", "*** invalid value for " + this.getPath() + ": " + valString)) {
                throw new NoValidValueException(this.getPath(), valString);
            }
        }
        this.setValid(true);
    }

    public void setValids(List<String> valids) {
        this.valids = valids;
    }

    public String toString() {
        return this.isValid() ? this.value.toString() : "";
    }

    public int getMinSize() {
        return this.minsize;
    }

    public void setValue(String st) {
        this.value = SyntaxDEFactory.getInstance().createSyntaxDE(this.getType(), this.getPath(), st, this.minsize, this.maxsize);
    }

    public SyntaxDE getValue() {
        return this.value;
    }

    @Override
    protected MultipleSyntaxElements parseNewChildContainer(Node deref, char predelim0, char predelim1, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        return null;
    }

    @Override
    protected char getInDelim() {
        return '\u0000';
    }

    private void parseValue(StringBuffer res, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        String temp = res.toString();
        int len = temp.length();
        char preDelim = this.getPreDelim();
        if (preDelim != '\u0000' && temp.charAt(0) != preDelim) {
            if (len == 0) {
                throw new ParseErrorException(HBCIUtils.getLocMsg("EXCMSG_ENDOFSTRG", this.getPath()));
            }
            throw new PredelimErrorException(this.getPath(), Character.toString(preDelim), Character.toString(temp.charAt(0)));
        }
        this.value = SyntaxDEFactory.getInstance().createSyntaxDE(this.getType(), this.getPath(), res, this.minsize, this.maxsize);
        String valueString = this.value.toString(0);
        String predefined = predefs.get(this.getPath());
        if (predefined != null && !valueString.equals(predefined)) {
            throw new ParseErrorException(HBCIUtils.getLocMsg("EXCMSG_PREDEFERR", new Object[]{this.getPath(), predefined, this.value}));
        }
        boolean atLeastOne = false;
        boolean ok = false;
        if (valids != null) {
            String header = this.getPath() + ".value";
            Enumeration<String> e = valids.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                if (!key.startsWith(header) || key.indexOf(".", header.length()) != -1) continue;
                atLeastOne = true;
                String validValue = valids.get(key);
                if (!valueString.equals(validValue)) continue;
                ok = true;
                break;
            }
        }
        if (atLeastOne && !ok && !HBCIUtils.ignoreError(null, "client.errors.ignoreValidValueErrors", "*** invalid value for " + this.getPath() + ": " + valueString)) {
            throw new NoValidValueException(this.getPath(), valueString);
        }
    }

    private void initData(Node dedef, String name, String path, char predelim, int idx, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        this.setValid(false);
        this.value = null;
        this.valids = new ArrayList<String>();
        this.minsize = 1;
        String st = ((Element)dedef).getAttribute("minsize");
        if (st.length() != 0) {
            this.minsize = Integer.parseInt(st);
        }
        this.maxsize = 0;
        st = ((Element)dedef).getAttribute("maxsize");
        if (st.length() != 0) {
            this.maxsize = Integer.parseInt(st);
        }
        this.parseValue(res, predefs, valids);
        this.setValid(true);
    }

    public DE(Node dedef, String name, String path, char predelim, int idx, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        super(((Element)dedef).getAttribute("type"), name, path, predelim, idx, res, fullResLen, null, predefs, valids);
        this.initData(dedef, name, path, predelim, idx, res, fullResLen, syntax, predefs, valids);
    }

    public void init(Node dedef, String name, String path, char predelim, int idx, StringBuffer res, int fullResLen, Document syntax, Hashtable<String, String> predefs, Hashtable<String, String> valids) {
        super.init(((Element)dedef).getAttribute("type"), name, path, predelim, idx, res, fullResLen, null, predefs, valids);
        this.initData(dedef, name, path, predelim, idx, res, fullResLen, syntax, predefs, valids);
    }

    @Override
    public void extractValues(Hashtable<String, String> values) {
        if (this.isValid()) {
            values.put(this.getPath(), this.value.toString());
        }
    }

    @Override
    public String toString(int zero) {
        return this.isValid() ? this.value.toString(0) : "";
    }

    @Override
    public void getElementPaths(Properties p, int[] segref, int[] degref, int[] deref) {
        if (deref == null) {
            p.setProperty(Integer.toString(segref[0]) + ":" + Integer.toString(degref[0]), this.getPath());
            degref[0] = degref[0] + 1;
        } else {
            p.setProperty(Integer.toString(segref[0]) + ":" + Integer.toString(degref[0]) + "," + Integer.toString(deref[0]), this.getPath());
            deref[0] = deref[0] + 1;
        }
    }

    @Override
    public void destroy() {
        this.value = null;
        this.valids.clear();
        this.valids = null;
        super.destroy();
    }
}

