/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.util.Properties;
import java.util.StringTokenizer;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.FlickerCode;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HHDVersion;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.passport.AbstractPinTanPassport;

public class HBCIPassportPinTanNoFile
extends AbstractPinTanPassport {
    public HBCIPassportPinTanNoFile(Properties properties, HBCICallback callback) {
        super(properties, callback);
        this.read();
    }

    protected void read() {
        this.setCountry(this.properties.getProperty("client.passport.country"));
        this.setBLZ(this.properties.getProperty("client.passport.blz"));
        this.setCustomerId(this.properties.getProperty("client.passport.customerId"));
        if (this.properties.getProperty("client.passport.userId") != null) {
            this.setUserId(this.properties.getProperty("client.passport.userId"));
        } else {
            this.setUserId(this.getCustomerId());
        }
        BankInfo bankInfo = HBCIUtils.getBankInfo(this.getBLZ());
        this.setHBCIVersion(bankInfo.getPinTanVersion().getId());
        String url = bankInfo.getPinTanAddress();
        String proxyPrefix = System.getProperty("proxyPrefix", null);
        if (proxyPrefix != null) {
            url = proxyPrefix + url;
        }
        this.setHost(url);
    }

    @Override
    public byte[] hash(byte[] data) {
        return data;
    }

    @Override
    public byte[] sign(byte[] data) {
        try {
            if (this.getPIN() == null) {
                StringBuffer s = new StringBuffer();
                this.getCallback().callback(16, HBCIUtils.getLocMsg("CALLB_NEED_PTPIN"), 1, s);
                if (s.length() == 0) {
                    throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_PINZERO"));
                }
                LogFilter.getInstance().addSecretData(this.getPIN(), "X", 1);
            }
            String tan = "";
            String pintanMethod = this.getCurrentTANMethod(false);
            if (pintanMethod.equals("999")) {
                HBCIUtils.log("onestep method - checking GVs to decide whether or not we need a TAN", 4);
                String codes = this.collectSegCodes(new String(data, "ISO-8859-1"));
                StringTokenizer tok = new StringTokenizer(codes, "|");
                while (tok.hasMoreTokens()) {
                    String code = tok.nextToken();
                    String info = this.getPinTanInfo(code);
                    if (info.equals("J")) {
                        HBCIUtils.log("the job with the code " + code + " needs a TAN", 4);
                        if (tan.length() == 0) {
                            StringBuffer s = new StringBuffer();
                            this.callback.callback(17, HBCIUtils.getLocMsg("CALLB_NEED_PTTAN"), 2, s);
                            if (s.length() == 0) {
                                throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_TANZERO"));
                            }
                            tan = s.toString();
                            continue;
                        }
                        HBCIUtils.log("there should be only one job that needs a TAN!", 2);
                        continue;
                    }
                    if (info.equals("N")) {
                        HBCIUtils.log("the job with the code " + code + " does not need a TAN", 4);
                        continue;
                    }
                    if (info.length() != 0) continue;
                    HBCIUtils.log("the job with the code " + code + " seems not to be allowed with PIN/TAN", 2);
                }
            } else {
                HBCIUtils.log("twostep method - checking passport(challenge) to decide whether or not we need a TAN", 4);
                Properties secmechInfo = this.getCurrentSecMechInfo();
                String challenge = (String)this.getPersistentData("pintan_challenge");
                this.setPersistentData("pintan_challenge", null);
                if (challenge == null) {
                    HBCIUtils.log("will not sign with a TAN, because there is no challenge", 4);
                } else {
                    HBCIUtils.log("found challenge in passport, so we ask for a TAN", 4);
                    String hhduc = (String)this.getPersistentData("pintan_challenge_hhd_uc");
                    this.setPersistentData("pintan_challenge_hhd_uc", null);
                    HHDVersion hhd = HHDVersion.find(secmechInfo);
                    HBCIUtils.log("detected HHD version: " + (Object)((Object)hhd), 4);
                    StringBuffer payload = new StringBuffer();
                    String msg = secmechInfo.getProperty("name") + "\n" + secmechInfo.getProperty("inputinfo") + "\n\n" + challenge;
                    if (hhd.getType() == HHDVersion.Type.PHOTOTAN) {
                        payload.append(hhduc);
                        this.callback.callback(33, msg, 2, payload);
                    } else {
                        String flicker = this.parseFlickercode(challenge, hhduc);
                        if (flicker != null) {
                            payload.append(flicker);
                        }
                        this.callback.callback(17, msg, 2, payload);
                    }
                    this.setPersistentData("externalid", null);
                    if (payload == null || payload.length() == 0) {
                        throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_TANZERO"));
                    }
                    tan = payload.toString();
                }
            }
            if (tan.length() != 0) {
                LogFilter.getInstance().addSecretData(tan, "X", 1);
            }
            return (this.getPIN() + "|" + tan).getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** signing failed", ex);
        }
    }

    private String parseFlickercode(String challenge, String hhduc) {
        if (hhduc != null && hhduc.trim().length() > 0) {
            try {
                FlickerCode code = new FlickerCode(hhduc);
                return code.render();
            }
            catch (Exception e) {
                HBCIUtils.log("unable to parse Challenge HHDuc " + hhduc + ":" + HBCIUtils.exception2String(e), 4);
            }
        }
        if (challenge != null && challenge.trim().length() > 0) {
            try {
                FlickerCode code = new FlickerCode(challenge);
                return code.render();
            }
            catch (Exception e) {
                HBCIUtils.log("challenge contains no HHDuc (no problem in most cases):" + HBCIUtils.exception2String(e), 5);
            }
        }
        return null;
    }

    @Override
    public boolean verify(byte[] data, byte[] sig) {
        return true;
    }

    @Override
    public byte[][] encrypt(byte[] plainMsg) {
        try {
            byte padLength = plainMsg[plainMsg.length - 1];
            byte[] encrypted = new String(plainMsg, 0, plainMsg.length - padLength, "ISO-8859-1").getBytes("ISO-8859-1");
            return new byte[][]{new byte[8], encrypted};
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** encrypting message failed", ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] cryptedKey, byte[] cryptedMsg) {
        try {
            return new String(new String(cryptedMsg, "ISO-8859-1") + '\u0001').getBytes("ISO-8859-1");
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** decrypting of message failed", ex);
        }
    }
}

