/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.ChallengeInfo;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.protocol.SEG;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.status.HBCIRetVal;
import org.kapott.hbci.structures.Konto;

public abstract class AbstractPinTanPassport
extends AbstractHBCIPassport {
    private String proxy;
    private String proxyuser;
    private String proxypass;
    private boolean verifyTANMode;
    private Hashtable<String, Properties> twostepMechanisms = new Hashtable();
    private List<String> allowedTwostepMechanisms = new ArrayList<String>();
    private String currentTANMethod;
    private boolean currentTANMethodWasAutoSelected;
    private String pin;

    public AbstractPinTanPassport(Properties properties, HBCICallback callback) {
        super(properties, callback);
    }

    @Override
    public void setBPD(Properties p) {
        super.setBPD(p);
        if (p != null && p.size() != 0) {
            this.twostepMechanisms.clear();
            int maxAllowedVersion = Integer.parseInt(HBCIUtils.getParam("kernel.gv.HITANS.segversion.max", "0"));
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                int prevVersion;
                String subkey;
                String key = (String)e.nextElement();
                if (!key.startsWith("Params") || !(subkey = key.substring(key.indexOf(46) + 1)).startsWith("TAN2StepPar")) continue;
                int segVersion = Integer.parseInt(subkey.substring(11, 12));
                if (!(subkey = subkey.substring(subkey.indexOf(46) + 1)).startsWith("ParTAN2Step") || !subkey.endsWith(".secfunc")) continue;
                if (maxAllowedVersion > 0 && segVersion > maxAllowedVersion) {
                    HBCIUtils.log("skipping segversion " + segVersion + ", larger than allowed version " + maxAllowedVersion, 3);
                    continue;
                }
                String secfunc = p.getProperty(key);
                Properties prev = this.twostepMechanisms.get(secfunc);
                if (prev != null && (prevVersion = Integer.parseInt(prev.getProperty("segversion"))) > segVersion) {
                    HBCIUtils.log("found another twostepmech " + secfunc + " in segversion " + segVersion + ", allready have one in segversion " + prevVersion + ", ignoring segversion " + segVersion, 4);
                    continue;
                }
                Properties entry = new Properties();
                entry.put("segversion", Integer.toString(segVersion));
                String paramHeader = key.substring(0, key.lastIndexOf(46));
                Enumeration<?> e2 = p.propertyNames();
                while (e2.hasMoreElements()) {
                    String key2 = (String)e2.nextElement();
                    if (!key2.startsWith(paramHeader + ".")) continue;
                    int dotPos = key2.lastIndexOf(46);
                    entry.setProperty(key2.substring(dotPos + 1), p.getProperty(key2));
                }
                this.twostepMechanisms.put(secfunc, entry);
            }
        }
    }

    private void searchFor3920s(List<HBCIRetVal> rets) {
        for (HBCIRetVal ret : rets) {
            if (!ret.code.equals("3920")) continue;
            this.allowedTwostepMechanisms.clear();
            int l2 = ret.params.length;
            for (int j = 0; j < l2; ++j) {
                this.allowedTwostepMechanisms.add(ret.params[j]);
            }
            HBCIUtils.log("autosecfunc: found 3920 in response - updated list of allowed twostepmechs with " + this.allowedTwostepMechanisms.size() + " entries", 4);
        }
    }

    private boolean searchFor3072s(List<HBCIRetVal> rets) {
        for (HBCIRetVal ret : rets) {
            if (!ret.code.equals("3072")) continue;
            String newCustomerId = "";
            String newUserId = "";
            int l2 = ret.params.length;
            if (l2 > 0) {
                newUserId = ret.params[0];
                newCustomerId = ret.params[0];
            }
            if (l2 > 1) {
                newCustomerId = ret.params[1];
            }
            if (l2 <= 0) continue;
            HBCIUtils.log("autosecfunc: found 3072 in response - change user id", 4);
            StringBuffer retData = new StringBuffer();
            retData.append(newUserId + "|" + newCustomerId);
            this.callback.callback(41, "*** User ID changed", 2, retData);
            return true;
        }
        return false;
    }

    @Override
    public boolean postInitResponseHook(HBCIMsgStatus msgStatus) {
        if (!msgStatus.isOK()) {
            HBCIUtils.log("dialog init ended with errors - searching for return code 'wrong PIN'", 4);
            if (msgStatus.isInvalidPIN()) {
                HBCIUtils.log("detected 'invalid PIN' error - clearing passport PIN", 3);
                this.clearPIN();
                StringBuffer retData = new StringBuffer();
                this.callback.callback(40, "*** invalid PIN entered", 2, retData);
            }
        }
        HBCIUtils.log("autosecfunc: search for 3920s in response to detect allowed twostep secmechs", 4);
        this.searchFor3920s(msgStatus.globStatus.getWarnings());
        this.searchFor3920s(msgStatus.segStatus.getWarnings());
        this.searchFor3072s(msgStatus.segStatus.getWarnings());
        this.setPersistentData("_authed_dialog_executed", Boolean.TRUE);
        String oldTANMethod = this.currentTANMethod;
        String updatedTANMethod = this.getCurrentTANMethod(true);
        if (oldTANMethod != null && !oldTANMethod.equals(updatedTANMethod)) {
            HBCIUtils.log("autosecfunc: after this dialog-init we had to change selected pintan method from " + oldTANMethod + " to " + updatedTANMethod + ", so a restart of this dialog is needed", 3);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSupported() {
        boolean ret = false;
        Properties bpd = this.getBPD();
        if (bpd != null && bpd.size() != 0) {
            Enumeration<?> e = bpd.propertyNames();
            while (e.hasMoreElements()) {
                int posi;
                String key = (String)e.nextElement();
                if (!key.startsWith("Params") || !key.substring((posi = key.indexOf(".")) + 1).startsWith("PinTanPar")) continue;
                ret = true;
                break;
            }
            if (ret) {
                String current = this.getCurrentTANMethod(true);
                if (current.equals("999")) {
                    if (!this.isOneStepAllowed()) {
                        HBCIUtils.log("not supported: onestep method not allowed by BPD", 1);
                        ret = false;
                    } else {
                        HBCIUtils.log("supported: pintan-onestep", 4);
                    }
                } else {
                    Properties entry = this.twostepMechanisms.get(current);
                    if (entry == null) {
                        HBCIUtils.log("not supported: twostep-method " + current + " selected, but this is not supported", 1);
                        ret = false;
                    } else {
                        HBCIUtils.log("selected twostep-method " + current + " (" + entry.getProperty("name") + ") is supported", 4);
                    }
                }
            }
        } else {
            ret = true;
        }
        return ret;
    }

    private boolean isOneStepAllowed() {
        boolean ret = true;
        Properties bpd = this.getBPD();
        if (bpd != null) {
            Enumeration<?> e = bpd.propertyNames();
            while (e.hasMoreElements()) {
                String subkey;
                String key = (String)e.nextElement();
                if (!key.startsWith("Params") || !(subkey = key.substring(key.indexOf(46) + 1)).startsWith("TAN2StepPar") || !subkey.endsWith(".can1step")) continue;
                String value = bpd.getProperty(key);
                ret = value.equals("J");
                break;
            }
        }
        return ret;
    }

    public void setCurrentTANMethod(String method) {
        this.currentTANMethod = method;
    }

    public String getCurrentTANMethod(boolean recheckSupportedSecMechs) {
        if (this.currentTANMethod == null || recheckSupportedSecMechs) {
            String[] entry;
            HBCIUtils.log("autosecfunc: (re)checking selected pintan secmech", 4);
            ArrayList<String[]> options = new ArrayList<String[]>();
            if (this.isOneStepAllowed() && (this.allowedTwostepMechanisms.size() == 0 || this.allowedTwostepMechanisms.contains("999"))) {
                options.add(new String[]{"999", "Einschritt-Verfahren"});
            }
            Object[] secfuncs = this.twostepMechanisms.keySet().toArray(new String[this.twostepMechanisms.size()]);
            Arrays.sort(secfuncs);
            for (Object secfunc : secfuncs) {
                if (this.allowedTwostepMechanisms.size() != 0 && !this.allowedTwostepMechanisms.contains(secfunc)) continue;
                entry = this.twostepMechanisms.get(secfunc);
                options.add(new String[]{secfunc, entry.getProperty("name")});
            }
            if (options.size() == 1) {
                String autoSelection = ((String[])options.get(0))[0];
                HBCIUtils.log("autosecfunc: there is only one pintan method (" + autoSelection + ") supported - choosing this automatically", 4);
                if (this.currentTANMethod != null && !autoSelection.equals(this.currentTANMethod)) {
                    HBCIUtils.log("autosecfunc: currently selected method (" + this.currentTANMethod + ") differs from auto-selected method (" + autoSelection + ")", 4);
                }
                this.setCurrentTANMethod(autoSelection);
                this.currentTANMethodWasAutoSelected = true;
            } else if (options.size() > 1) {
                Iterator i;
                if (this.currentTANMethod != null) {
                    boolean ok = false;
                    i = options.iterator();
                    while (i.hasNext()) {
                        if (!this.currentTANMethod.equals(((String[])i.next())[0])) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        HBCIUtils.log("autosecfunc: currently selected pintan method (" + this.currentTANMethod + ") not in list of supported methods - resetting current selection", 4);
                        this.currentTANMethod = null;
                    }
                }
                if (this.currentTANMethod == null || this.currentTANMethodWasAutoSelected) {
                    if (this.allowedTwostepMechanisms.size() == 0 && this.getPersistentData("_authed_dialog_executed") == null) {
                        String autoSelection = ((String[])options.get(0))[0];
                        HBCIUtils.log("autosecfunc: there are " + options.size() + " pintan methods supported, but we don't know which of them are allowed for the current user, so we automatically choose " + autoSelection, 4);
                        this.setCurrentTANMethod(autoSelection);
                        this.currentTANMethodWasAutoSelected = true;
                    } else {
                        HBCIUtils.log("autosecfunc: we have to callback to ask for pintan method to be used", 4);
                        StringBuffer retData = new StringBuffer();
                        i = options.iterator();
                        while (i.hasNext()) {
                            if (retData.length() != 0) {
                                retData.append("|");
                            }
                            entry = (String[])i.next();
                            retData.append(entry[0]).append(":").append(entry[1]);
                        }
                        this.callback.callback(27, "*** Select a pintan method from the list", 2, retData);
                        String selected = retData.toString();
                        boolean ok = false;
                        Iterator i2 = options.iterator();
                        while (i2.hasNext()) {
                            if (!selected.equals(((String[])i2.next())[0])) continue;
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            throw new InvalidUserDataException("*** selected pintan method not supported!");
                        }
                        this.setCurrentTANMethod(selected);
                        this.currentTANMethodWasAutoSelected = false;
                        HBCIUtils.log("autosecfunc: manually selected pintan method " + this.currentTANMethod, 4);
                    }
                }
            } else {
                HBCIUtils.log("autosecfunc: absolutely no information about allowed pintan methods available - automatically falling back to 999", 4);
                this.setCurrentTANMethod("999");
                this.currentTANMethodWasAutoSelected = true;
            }
        }
        return this.currentTANMethod;
    }

    public Properties getCurrentSecMechInfo() {
        return this.twostepMechanisms.get(this.getCurrentTANMethod(false));
    }

    public Hashtable<String, Properties> getTwostepMechanisms() {
        return this.twostepMechanisms;
    }

    @Override
    public String getProfileMethod() {
        return "PIN";
    }

    @Override
    public String getProfileVersion() {
        return this.getCurrentTANMethod(false).equals("999") ? "1" : "2";
    }

    @Override
    public boolean needUserKeys() {
        return false;
    }

    @Override
    public boolean needUserSig() {
        return true;
    }

    @Override
    public String getSysStatus() {
        return "1";
    }

    @Override
    public boolean hasInstSigKey() {
        return true;
    }

    @Override
    public boolean hasInstEncKey() {
        return true;
    }

    @Override
    public boolean hasMySigKey() {
        return true;
    }

    @Override
    public boolean hasMyEncKey() {
        return true;
    }

    public HBCIKey getInstSigKey() {
        return null;
    }

    public HBCIKey getInstEncKey() {
        return null;
    }

    @Override
    public String getInstSigKeyName() {
        return this.getUserId();
    }

    @Override
    public String getInstSigKeyNum() {
        return "0";
    }

    @Override
    public String getInstSigKeyVersion() {
        return "0";
    }

    @Override
    public String getInstEncKeyName() {
        return this.getUserId();
    }

    @Override
    public String getInstEncKeyNum() {
        return "0";
    }

    @Override
    public String getInstEncKeyVersion() {
        return "0";
    }

    @Override
    public String getMySigKeyName() {
        return this.getUserId();
    }

    @Override
    public String getMySigKeyNum() {
        return "0";
    }

    @Override
    public String getMySigKeyVersion() {
        return "0";
    }

    public String getMyEncKeyName() {
        return this.getUserId();
    }

    public String getMyEncKeyNum() {
        return "0";
    }

    public String getMyEncKeyVersion() {
        return "0";
    }

    public HBCIKey getMyPublicDigKey() {
        return null;
    }

    public HBCIKey getMyPrivateDigKey() {
        return null;
    }

    public HBCIKey getMyPublicSigKey() {
        return null;
    }

    public HBCIKey getMyPrivateSigKey() {
        return null;
    }

    @Override
    public HBCIKey getMyPublicEncKey() {
        return null;
    }

    @Override
    public HBCIKey getMyPrivateEncKey() {
        return null;
    }

    @Override
    public String getCryptMode() {
        return "2";
    }

    @Override
    public String getCryptAlg() {
        return "13";
    }

    @Override
    public String getCryptKeyType() {
        return "5";
    }

    @Override
    public String getSigFunction() {
        return this.getCurrentTANMethod(false);
    }

    @Override
    public String getCryptFunction() {
        return "998";
    }

    @Override
    public String getSigAlg() {
        return "10";
    }

    @Override
    public String getSigMode() {
        return "16";
    }

    @Override
    public String getHashAlg() {
        return "999";
    }

    @Override
    public void setInstSigKey(HBCIKey key) {
    }

    @Override
    public void setInstEncKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicDigKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateDigKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicSigKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateSigKey(HBCIKey key) {
    }

    @Override
    public void setMyPublicEncKey(HBCIKey key) {
    }

    @Override
    public void setMyPrivateEncKey(HBCIKey key) {
    }

    @Override
    public void incSigId() {
    }

    protected String collectSegCodes(String msg) {
        int endPosi;
        StringBuffer ret = new StringBuffer();
        int len = msg.length();
        int posi = 0;
        while ((endPosi = msg.indexOf(58, posi)) != -1) {
            String segcode = msg.substring(posi, endPosi);
            if (ret.length() != 0) {
                ret.append("|");
            }
            ret.append(segcode);
            while (posi < len && msg.charAt(posi) != '\'') {
                posi = HBCIUtils.getPosiOfNextDelimiter(msg, posi + 1);
            }
            if (posi >= len) break;
            ++posi;
        }
        return ret.toString();
    }

    public String getPinTanInfo(String code) {
        String ret = "";
        Properties bpd = this.getBPD();
        if (bpd != null) {
            boolean isGV = false;
            StringBuffer paramCode = new StringBuffer(code).replace(1, 2, "I").append("S");
            Enumeration<?> e = bpd.propertyNames();
            while (e.hasMoreElements()) {
                String code2;
                String key = (String)e.nextElement();
                if (key.startsWith("Params") && key.substring(key.indexOf(".") + 1).startsWith("PinTanPar") && key.indexOf(".ParPinTan.PinTanGV") != -1 && key.endsWith(".segcode")) {
                    code2 = bpd.getProperty(key);
                    if (!code.equals(code2)) continue;
                    key = key.substring(0, key.length() - "segcode".length()) + "needtan";
                    ret = bpd.getProperty(key);
                    break;
                }
                if (!key.startsWith("Params") || !key.endsWith(".SegHead.code") || !paramCode.equals(code2 = bpd.getProperty(key))) continue;
                isGV = true;
            }
            if (ret.length() == 0 && !isGV) {
                if (this.verifyTANMode && code.equals("HKIDN")) {
                    ret = "J";
                    this.deactivateTANVerifyMode();
                } else {
                    ret = "A";
                }
            }
        }
        return ret;
    }

    public void deactivateTANVerifyMode() {
        this.verifyTANMode = false;
    }

    @Override
    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    @Override
    public String getProxyPass() {
        return this.proxypass;
    }

    @Override
    public String getProxyUser() {
        return this.proxyuser;
    }

    private String getOrderHashMode() {
        String ret = null;
        Properties bpd = this.getBPD();
        if (bpd != null) {
            Enumeration<?> e = bpd.propertyNames();
            while (e.hasMoreElements()) {
                String subkey;
                String key = (String)e.nextElement();
                Properties props = this.getCurrentSecMechInfo();
                String segVersion = "";
                try {
                    int value = Integer.parseInt(props.getProperty("segversion"));
                    segVersion = segVersion + value;
                }
                catch (NumberFormatException value) {
                    // empty catch block
                }
                if (!key.startsWith("Params") || !(subkey = key.substring(key.indexOf(46) + 1)).startsWith("TAN2StepPar" + segVersion) || !subkey.endsWith(".orderhashmode")) continue;
                ret = bpd.getProperty(key);
                break;
            }
        }
        return ret;
    }

    private void patchMessagesFor2StepMethods(List<List<HBCIJobImpl>> msgs) {
        if (!this.getCurrentTANMethod(false).equals("999")) {
            HBCIUtils.log("afterCustomDialogInitHook: patching message queues for twostep method", 4);
            Properties secmechInfo = this.getCurrentSecMechInfo();
            String segversion = secmechInfo.getProperty("segversion");
            String process = secmechInfo.getProperty("process");
            ArrayList<List<Object>> new_msgs = new ArrayList<List<Object>>();
            for (List<HBCIJobImpl> msg_tasks : msgs) {
                ArrayList<HBCIJobImpl> new_msg_tasks = new ArrayList<HBCIJobImpl>();
                HBCIJobImpl hktan2 = null;
                for (HBCIJobImpl task : msg_tasks) {
                    String segcode = task.getHBCICode();
                    if (this.getPinTanInfo(segcode).equals("J")) {
                        HBCIUtils.log("found task that requires a TAN: " + segcode + " - have to patch message queue", 4);
                        if (process.equals("1")) {
                            HBCIUtils.log("process #1: adding new message with HKTAN(p=1,hash=...) before current message", 4);
                            HBCIJobImpl hktan = null;
                            hktan.setExternalId(task.getExternalId());
                            hktan.setSegVersion(segversion);
                            ((GVTAN2Step)hktan).setParam("process", process);
                            ((GVTAN2Step)hktan).setParam("notlasttan", "N");
                            int hktanVersion = Integer.parseInt(hktan.getSegVersion());
                            if (hktanVersion >= 5) {
                                ((GVTAN2Step)hktan).setParam("ordersegcode", task.getHBCICode());
                                String noa = secmechInfo.getProperty("needorderaccount", "");
                                HBCIUtils.log("needorderaccount=" + noa, 3);
                                if (noa.equals("2")) {
                                    Konto k = task.getOrderAccount();
                                    if (k != null) {
                                        HBCIUtils.log("applying orderaccount to HKTAN for " + task.getHBCICode(), 3);
                                        hktan.setParam("orderaccount", k);
                                    } else {
                                        HBCIUtils.log("orderaccount needed, but not found in " + task.getHBCICode(), 2);
                                    }
                                }
                            }
                            try {
                                SEG seg = task.createJobSegment(3);
                                seg.validate();
                                String segdata = seg.toString(0);
                                HBCIUtils.log("calculating hash for jobsegment: " + segdata, 5);
                                String orderhashmode = this.getOrderHashMode();
                                String alg = null;
                                String provider = null;
                                if (orderhashmode.equals("1")) {
                                    alg = "RIPEMD160";
                                    provider = "CryptAlgs4Java";
                                } else if (orderhashmode.equals("2")) {
                                    alg = "SHA-1";
                                }
                                HBCIUtils.log("using " + alg + "/" + provider + " for generating order hash", 4);
                                MessageDigest digest = MessageDigest.getInstance(alg, provider);
                                digest.update(segdata.getBytes("ISO-8859-1"));
                                byte[] hash = digest.digest();
                                ((GVTAN2Step)hktan).setParam("orderhash", new String(hash, "ISO-8859-1"));
                            }
                            catch (Exception e) {
                                throw new HBCI_Exception(e);
                            }
                            if (secmechInfo.getProperty("needchallengeklass", "N").equals("J")) {
                                HBCIUtils.log("we are in PV #1, and a challenge klass is required", 4);
                                ChallengeInfo cinfo = new ChallengeInfo();
                                cinfo.applyParams(task, hktan, secmechInfo);
                            }
                            this.applyTanMedia((GVTAN2Step)hktan);
                            ArrayList<HBCIJobImpl> additional_msg_tasks = new ArrayList<HBCIJobImpl>();
                            additional_msg_tasks.add(hktan2);
                            new_msgs.add(additional_msg_tasks);
                            new_msg_tasks.add(task);
                            continue;
                        }
                        HBCIUtils.log("process #2: adding new task HKTAN(p=4) to current message", 4);
                        new_msg_tasks.add(task);
                        HBCIJobImpl hktan1 = null;
                        hktan1.setExternalId(task.getExternalId());
                        hktan1.setSegVersion(segversion);
                        ((GVTAN2Step)hktan1).setParam("process", "4");
                        this.applyTanMedia((GVTAN2Step)hktan1);
                        new_msg_tasks.add(hktan1);
                        HBCIUtils.log("creating new msg with HKTAN(p=2,orderref=DELAYED)", 4);
                        hktan1.setSegVersion(segversion);
                        hktan2 = null;
                        hktan2.setExternalId(task.getExternalId());
                        ((GVTAN2Step)hktan2).setParam("process", "2");
                        ((GVTAN2Step)hktan2).setParam("notlasttan", "N");
                        HBCIUtils.log("storing reference to this HKTAN in previous HKTAN segment", 4);
                        ((GVTAN2Step)hktan1).storeOtherTAN2StepTask((GVTAN2Step)hktan2);
                        HBCIUtils.log("storing reference to original job in new HKTAN segment", 4);
                        ((GVTAN2Step)hktan2).storeOriginalTask(task);
                        continue;
                    }
                    HBCIUtils.log("found task that does not require a TAN: " + segcode + " - adding it to current msg", 4);
                    new_msg_tasks.add(task);
                }
                msg_tasks.clear();
                msg_tasks.addAll(new_msg_tasks);
                new_msgs.add(msg_tasks);
                if (hktan2 == null || this.callback.tanCallback(this, (GVTAN2Step)hktan2)) continue;
                ArrayList<HBCIJobImpl> additional_msg_tasks = new ArrayList<HBCIJobImpl>();
                additional_msg_tasks.add(hktan2);
                HBCIUtils.log("adding newly created message with HKTAN(p=2) after current one", 4);
                new_msgs.add(additional_msg_tasks);
            }
            msgs.clear();
            msgs.addAll(new_msgs);
        }
    }

    private void applyTanMedia(GVTAN2Step hktan) {
        if (hktan == null) {
            return;
        }
        int hktan_version = Integer.parseInt(hktan.getSegVersion());
        HBCIUtils.log("hktan_version: " + hktan_version, 4);
        if (hktan_version >= 3) {
            Properties secmechInfo = this.getCurrentSecMechInfo();
            int num = Integer.parseInt(secmechInfo.getProperty("nofactivetanmedia", "0"));
            String needed = secmechInfo.getProperty("needtanmedia", "");
            HBCIUtils.log("nofactivetanmedia: " + num + ", needtanmedia: " + needed, 4);
            if (needed.equals("2")) {
                HBCIUtils.log("we have to add the tan media", 4);
                StringBuffer retData = new StringBuffer();
                retData.append(this.getUPD().getProperty("tanmedia.names", ""));
                this.callback.callback(32, "*** Enter the name of your TAN media", 2, retData);
                hktan.setParam("tanmedia", retData.toString());
            }
        }
    }

    @Override
    public void afterCustomDialogInitHook(List<List<HBCIJobImpl>> msgs) {
        this.patchMessagesFor2StepMethods(msgs);
    }

    public void setPIN(String pin) {
        this.pin = pin;
    }

    public String getPIN() {
        return this.pin;
    }

    public void clearPIN() {
        this.setPIN(null);
    }

    public List<String> getAllowedTwostepMechanisms() {
        return this.allowedTwostepMechanisms;
    }

    public void setAllowedTwostepMechanisms(List<String> l) {
        this.allowedTwostepMechanisms = l;
    }

    @Override
    public int getMaxGVSegsPerMsg() {
        return 1;
    }
}

