/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.passport;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Limit;
import org.kapott.hbci.structures.Value;

public abstract class AbstractHBCIPassport
implements HBCIPassportInternal,
Serializable {
    private Properties bpd;
    private Properties upd;
    private String hbciversion;
    private String country;
    private String blz;
    private String host;
    private Integer port;
    private String userid;
    private String customerid;
    private String sysid;
    private Long sigid;
    private String cid;
    private Hashtable<String, Object> persistentData = new Hashtable();
    protected HBCICallback callback;
    protected Properties properties;

    public AbstractHBCIPassport(Properties properties, HBCICallback callback) {
        this.callback = callback;
        this.properties = properties;
    }

    @Override
    public final Properties getBPD() {
        return this.bpd;
    }

    @Override
    public final void setHBCIVersion(String hbciversion) {
        this.hbciversion = hbciversion;
    }

    @Override
    public final String getHBCIVersion() {
        return this.hbciversion != null ? this.hbciversion : "";
    }

    @Override
    public final Properties getUPD() {
        return this.upd;
    }

    @Override
    public final String getBLZ() {
        return this.blz;
    }

    @Override
    public final String getCountry() {
        return this.country;
    }

    @Override
    public final Konto[] getAccounts() {
        ArrayList<Konto> ret = new ArrayList<Konto>();
        if (this.upd != null) {
            String header;
            String number;
            int i = 0;
            while ((number = this.upd.getProperty((header = HBCIUtils.withCounter("KInfo", i)) + ".KTV.number")) != null) {
                String gvHeader;
                String code;
                Konto entry = new Konto();
                entry.blz = this.upd.getProperty(header + ".KTV.KIK.blz");
                entry.country = this.upd.getProperty(header + ".KTV.KIK.country");
                entry.number = number;
                entry.subnumber = this.upd.getProperty(header + ".KTV.subnumber");
                entry.curr = this.upd.getProperty(header + ".cur");
                entry.type = this.upd.getProperty(header + ".konto");
                entry.customerid = this.upd.getProperty(header + ".customerid");
                entry.name = this.upd.getProperty(header + ".name1");
                entry.name2 = this.upd.getProperty(header + ".name2");
                entry.bic = this.upd.getProperty(header + ".KTV.bic");
                entry.iban = this.upd.getProperty(header + ".KTV.iban");
                entry.acctype = this.upd.getProperty(header + ".acctype");
                String st = this.upd.getProperty(header + ".KLimit.limittype");
                if (st != null) {
                    Limit limit = new Limit();
                    limit.type = st.charAt(0);
                    limit.value = new Value(this.upd.getProperty(header + ".KLimit.BTG.value"), this.upd.getProperty(header + ".KLimit.BTG.curr"));
                    st = this.upd.getProperty(header + ".KLimit.limitdays");
                    if (st != null) {
                        limit.days = Integer.parseInt(st);
                    }
                }
                ArrayList<String> codes = new ArrayList<String>();
                int j = 0;
                while ((code = this.upd.getProperty((gvHeader = HBCIUtils.withCounter(header + ".AllowedGV", j)) + ".code")) != null) {
                    codes.add(code);
                    ++j;
                }
                if (!codes.isEmpty()) {
                    entry.allowedGVs = codes;
                }
                ret.add(entry);
                ++i;
            }
        }
        return ret.toArray(new Konto[ret.size()]);
    }

    @Override
    public final void fillAccountInfo(Konto account) {
        String number = HBCIUtils.stripLeadingZeroes(account.number);
        String iban = HBCIUtils.stripLeadingZeroes(account.iban);
        boolean haveNumber = number != null && number.length() != 0;
        boolean haveIBAN = iban != null && iban.length() != 0;
        Konto[] accounts = this.getAccounts();
        for (int i = 0; i < accounts.length; ++i) {
            String temp_number = HBCIUtils.stripLeadingZeroes(accounts[i].number);
            String temp_iban = HBCIUtils.stripLeadingZeroes(accounts[i].iban);
            if ((!haveNumber || !number.equals(temp_number)) && (!haveIBAN || !iban.equals(temp_iban))) continue;
            account.blz = accounts[i].blz;
            account.country = accounts[i].country;
            account.number = accounts[i].number;
            account.subnumber = accounts[i].subnumber;
            account.type = accounts[i].type;
            account.curr = accounts[i].curr;
            account.customerid = accounts[i].customerid;
            account.name = accounts[i].name;
            account.bic = accounts[i].bic;
            account.iban = accounts[i].iban;
            account.acctype = accounts[i].acctype;
            break;
        }
    }

    @Override
    public final Konto getAccount(String number) {
        Konto ret = new Konto();
        ret.number = number;
        this.fillAccountInfo(ret);
        if (ret.blz == null) {
            ret.blz = this.getBLZ();
            ret.country = this.getCountry();
            ret.customerid = this.getCustomerId();
            ret.name = this.getCustomerId();
        }
        return ret;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public final Integer getPort() {
        return this.port != null ? this.port : new Integer(0);
    }

    @Override
    public String getUserId() {
        return this.userid;
    }

    @Override
    public String getCustomerId() {
        return this.customerid != null && this.customerid.length() != 0 ? this.customerid : this.getUserId();
    }

    @Override
    public String getSysId() {
        return this.sysid != null && this.sysid.length() != 0 ? this.sysid : "0";
    }

    @Override
    public final String getCID() {
        return this.cid != null ? this.cid : "";
    }

    @Override
    public final void clearMySigKey() {
        this.setMyPublicSigKey(null);
        this.setMyPrivateSigKey(null);
    }

    @Override
    public final void clearMyEncKey() {
        this.setMyPublicEncKey(null);
        this.setMyPrivateEncKey(null);
    }

    @Override
    public final void clearMyDigKey() {
        this.setMyPublicDigKey(null);
        this.setMyPrivateDigKey(null);
    }

    @Override
    public final String getBPDVersion() {
        String version = this.bpd != null ? this.bpd.getProperty("BPA.version") : null;
        return version != null ? version : "0";
    }

    @Override
    public final String getUPDVersion() {
        String version = this.upd != null ? this.upd.getProperty("UPA.version") : null;
        return version != null ? version : "0";
    }

    @Override
    public final String getInstName() {
        return this.bpd != null ? this.bpd.getProperty("BPA.kiname") : null;
    }

    @Override
    public int getMaxGVperMsg() {
        return this.bpd != null ? Integer.parseInt(this.bpd.getProperty("BPA.numgva")) : -1;
    }

    @Override
    public final int getMaxMsgSizeKB() {
        return this.bpd != null ? Integer.parseInt(this.bpd.getProperty("BPA.maxmsgsize", "0")) : 0;
    }

    @Override
    public final String[] getSuppVersions() {
        String[] ret = new String[]{};
        if (this.bpd != null) {
            String value;
            String header;
            ArrayList<String> temp = new ArrayList<String>();
            int i = 0;
            while ((header = HBCIUtils.withCounter("BPA.SuppVersions.version", i)) != null && (value = this.bpd.getProperty(header)) != null) {
                temp.add(value);
                ++i;
            }
            if (temp.size() != 0) {
                ret = temp.toArray(ret);
            }
        }
        return ret;
    }

    @Override
    public final String getDefaultLang() {
        String value = this.bpd != null ? this.bpd.getProperty("CommListRes.deflang") : null;
        return value != null ? value : "0";
    }

    public final boolean canMixSecMethods() {
        String value;
        boolean ret = false;
        if (this.bpd != null && (value = this.bpd.getProperty("SecMethod.mixing")) != null && value.equals("J")) {
            ret = true;
        }
        return ret;
    }

    @Override
    public final String getLang() {
        String value = this.bpd != null ? this.bpd.getProperty("CommListRes.deflang") : null;
        return value != null ? value : "0";
    }

    @Override
    public final Long getSigId() {
        return this.sigid != null ? this.sigid : new Long(1L);
    }

    @Override
    public final void clearBPD() {
        this.setBPD(null);
    }

    @Override
    public void setBPD(Properties bpd) {
        this.bpd = bpd;
    }

    @Override
    public final void clearUPD() {
        this.setUPD(null);
    }

    @Override
    public final void setUPD(Properties upd) {
        this.upd = upd;
    }

    @Override
    public final void setCountry(String country) {
        this.country = country;
    }

    @Override
    public final void setBLZ(String blz) {
        LogFilter.getInstance().addSecretData(blz, "X", 3);
        this.blz = blz;
    }

    @Override
    public final void setHost(String host) {
        this.host = host;
    }

    @Override
    public final void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public final void setUserId(String userid) {
        LogFilter.getInstance().addSecretData(userid, "X", 2);
        this.userid = userid;
    }

    @Override
    public final void setCustomerId(String customerid) {
        LogFilter.getInstance().addSecretData(customerid, "X", 2);
        this.customerid = customerid;
    }

    @Override
    public final void setSigId(Long sigid) {
        this.sigid = sigid;
    }

    @Override
    public final void setSysId(String sysid) {
        this.sysid = sysid;
    }

    @Override
    public void incSigId() {
        this.setSigId(new Long(this.getSigId() + 1L));
    }

    public static HBCIPassport getInstance(HBCICallback callback, Properties properties, String name, Object init) {
        if (name == null) {
            throw new NullPointerException("name of passport implementation must not be null");
        }
        String className = "org.kapott.hbci.passport.HBCIPassport" + name;
        try {
            if (init == null) {
                init = name;
            }
            HBCIUtils.log("creating new instance of a " + name + " passport", 4);
            Class<?> cl = Class.forName(className);
            Constructor<?> con = cl.getConstructor(Properties.class, HBCICallback.class, Object.class);
            HBCIPassport p = (HBCIPassport)con.newInstance(properties, callback, init);
            return p;
        }
        catch (ClassNotFoundException e) {
            throw new InvalidUserDataException("*** No passport implementation '" + name + "' found - there must be a class " + className);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof HBCI_Exception) {
                throw (HBCI_Exception)cause;
            }
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_PASSPORT_INST", name), ite);
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_PASSPORT_INST", name), e);
        }
    }

    public static HBCIPassport getInstance(HBCICallback callback, Properties properties, Object init) {
        String passportName = properties.getProperty("client.passport.default");
        if (passportName == null) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_NODEFPASS"));
        }
        return AbstractHBCIPassport.getInstance(callback, properties, passportName, init);
    }

    public static HBCIPassport getInstance(HBCICallback callback, Properties properties, String name) {
        return AbstractHBCIPassport.getInstance(callback, properties, name, null);
    }

    public static HBCIPassport getInstance(HBCICallback callback, Properties properties) {
        return AbstractHBCIPassport.getInstance(callback, properties, null);
    }

    @Override
    public Properties getParamSegmentNames() {
        Properties ret = new Properties();
        Enumeration<?> e = this.bpd.propertyNames();
        while (e.hasMoreElements()) {
            String knownVersion;
            String version;
            String key = (String)e.nextElement();
            if (!key.startsWith("Params") || !key.endsWith(".SegHead.code")) continue;
            int dotPos = key.indexOf(46);
            int dotPos2 = key.indexOf(46, dotPos + 1);
            String gvname = key.substring(dotPos + 1, dotPos2);
            int len = gvname.length();
            int versionPos = -1;
            for (int i = len - 1; i >= 0; --i) {
                char ch = gvname.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                versionPos = i + 1;
                break;
            }
            if ((version = gvname.substring(versionPos)).length() == 0 || (knownVersion = (String)ret.get(gvname = gvname.substring(0, versionPos - 3))) != null && Integer.parseInt(version) <= Integer.parseInt(knownVersion)) continue;
            ret.setProperty(gvname, version);
        }
        return ret;
    }

    @Override
    public Properties getJobRestrictions(String specname) {
        char ch;
        int versionPos = specname.length() - 1;
        while ((ch = specname.charAt(versionPos)) >= '0' && ch <= '9') {
            --versionPos;
        }
        return this.getJobRestrictions(specname.substring(0, versionPos + 1), specname.substring(versionPos + 1));
    }

    @Override
    public Properties getJobRestrictions(String gvname, String version) {
        Properties result = new Properties();
        String searchstring = gvname + "Par" + version;
        Enumeration<?> e = this.bpd.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("Params") || key.indexOf("." + searchstring + ".Par") == -1) continue;
            int searchIdx = key.indexOf(searchstring);
            result.setProperty(key.substring(key.indexOf(".", searchIdx + searchstring.length() + 4) + 1), this.bpd.getProperty(key));
        }
        return result;
    }

    @Override
    public Properties getSupportedLowlevelJobs(MsgGen msgGen) {
        Properties paramSegments = this.getParamSegmentNames();
        Properties result = new Properties();
        Enumeration<?> e = paramSegments.propertyNames();
        while (e.hasMoreElements()) {
            String segName = (String)e.nextElement();
            if (!msgGen.getLowlevelGVs().containsKey(segName)) continue;
            result.put(segName, paramSegments.getProperty(segName));
        }
        return result;
    }

    @Override
    public Properties getLowlevelJobRestrictions(String gvname, MsgGen msgGen) {
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        String version = this.getSupportedLowlevelJobs(msgGen).getProperty(gvname);
        if (version == null) {
            throw new HBCI_Exception("*** lowlevel job " + gvname + " not supported");
        }
        return this.getJobRestrictions(gvname, version);
    }

    public boolean isSupported(String jobnameHL, MsgGen msgGen) {
        if (jobnameHL == null || jobnameHL.length() == 0) {
            throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        try {
            Class<?> cl = Class.forName("org.kapott.hbci.GV.GV" + jobnameHL);
            String lowlevelName = (String)cl.getMethod("getLowlevelName", null).invoke(null, (Object[])null);
            return this.getSupportedLowlevelJobs(msgGen).keySet().contains(lowlevelName);
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_HANDLER_HLCHECKERR", jobnameHL), e);
        }
    }

    @Override
    public void setPersistentData(String id, Object o) {
        if (o != null) {
            this.persistentData.put(id, o);
        } else {
            this.persistentData.remove(id);
        }
    }

    public void setPersistentData(Hashtable<String, Object> persistentData) {
        this.persistentData = persistentData;
    }

    @Override
    public Object getPersistentData(String id) {
        return this.persistentData.get(id);
    }

    public Hashtable<String, Object> getPersistentData() {
        return this.persistentData;
    }

    @Override
    public int getMaxGVSegsPerMsg() {
        return 0;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public HBCICallback getCallback() {
        return this.callback;
    }
}

