/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.AccountCRCAlgs;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.structures.Konto;
import org.slf4j.LoggerFactory;

public final class HBCIUtils {
    private static final String VERSION = "HBCI4Java-2.5.12";
    public static final int LOG_NONE = 0;
    public static final int LOG_ERR = 1;
    public static final int LOG_WARN = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    public static final int LOG_DEBUG2 = 5;
    public static final int LOG_INTERN = 6;
    private static char[] base64table = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    public static Properties blzs = new Properties();
    public static Map<String, BankInfo> banks = new HashMap<String, BankInfo>();

    public static String getNameForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getName() != null ? info.getName() : "";
    }

    public static BankInfo getBankInfo(String blz) {
        return banks.get(blz);
    }

    public static List<BankInfo> searchBankInfo(String query) {
        if (query != null) {
            query = query.trim();
        }
        LinkedList<BankInfo> list = new LinkedList<BankInfo>();
        if (query == null || query.length() < 3) {
            return list;
        }
        query = query.toLowerCase();
        for (BankInfo info : banks.values()) {
            String blz = info.getBlz();
            String bic = info.getBic();
            String name = info.getName();
            String loc = info.getLocation();
            if (blz != null && blz.startsWith(query)) {
                list.add(info);
                continue;
            }
            if (bic != null && bic.toLowerCase().startsWith(query)) {
                list.add(info);
                continue;
            }
            if (name != null && name.toLowerCase().contains(query)) {
                list.add(info);
                continue;
            }
            if (loc == null || !loc.toLowerCase().contains(query)) continue;
            list.add(info);
        }
        Collections.sort(list, new Comparator<BankInfo>(){

            @Override
            public int compare(BankInfo o1, BankInfo o2) {
                if (o1 == null || o1.getBlz() == null) {
                    return -1;
                }
                if (o2 == null || o2.getBlz() == null) {
                    return 1;
                }
                return o1.getBlz().compareTo(o2.getBlz());
            }
        });
        return list;
    }

    public static String getBICForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getBic() != null ? info.getBic() : "";
    }

    public static String getIBANForKonto(Konto k) {
        String konto = k.number;
        if (k.subnumber != null && k.subnumber.length() > 0 && k.subnumber.matches("[0-9]{1,8}") && k.number.length() + k.subnumber.length() <= 10) {
            konto = konto + k.subnumber;
        }
        String zeros = "0000000000";
        String filledKonto = zeros.substring(0, 10 - konto.length()) + konto;
        StringBuffer sb = new StringBuffer();
        sb.append(k.blz);
        sb.append(filledKonto);
        sb.append("1314");
        sb.append("00");
        BigInteger mod = new BigInteger(sb.toString()).mod(new BigInteger("97"));
        String checksum = String.valueOf(98 - mod.intValue());
        if (checksum.length() < 2) {
            checksum = "0" + checksum;
        }
        StringBuffer result = new StringBuffer();
        result.append("DE");
        result.append(checksum);
        result.append(k.blz);
        result.append(filledKonto);
        return result.toString();
    }

    public static String getHBCIHostForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getRdhAddress() != null ? info.getRdhAddress() : "";
    }

    public static String getPinTanURLForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getPinTanAddress() != null ? info.getPinTanAddress() : "";
    }

    public static String getHBCIVersionForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getRdhVersion() != null ? info.getRdhVersion().getId() : "";
    }

    public static String getPinTanVersionForBLZ(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return "";
        }
        return info.getPinTanVersion() != null ? info.getPinTanVersion().getId() : "";
    }

    public static String exception2String(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString().trim();
    }

    public static String exception2StringShort(Exception e) {
        StringBuffer st = new StringBuffer();
        for (Throwable e2 = e; e2 != null; e2 = e2.getCause()) {
            String exClass = e2.getClass().getName();
            String msg = e2.getMessage();
            if (msg == null) continue;
            st.setLength(0);
            st.append(exClass);
            st.append(": ");
            st.append(msg);
        }
        return st.toString().trim();
    }

    public static String data2hex(byte[] data) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            String st = Integer.toHexString(data[i]);
            if (st.length() == 1) {
                st = '0' + st;
            }
            st = st.substring(st.length() - 2);
            ret.append(st).append(" ");
        }
        return ret.toString();
    }

    public static String date2StringLocal(Date date) {
        String ret;
        try {
            ret = DateFormat.getDateInstance(3, Locale.getDefault()).format(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date.toString());
        }
        return ret;
    }

    public static Date string2DateLocal(String date) {
        Date ret;
        try {
            ret = DateFormat.getDateInstance(3, Locale.getDefault()).parse(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date);
        }
        return ret;
    }

    public static String time2StringLocal(Date date) {
        String ret;
        try {
            ret = DateFormat.getTimeInstance(3, Locale.getDefault()).format(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date.toString());
        }
        return ret;
    }

    public static Date string2TimeLocal(String date) {
        Date ret;
        try {
            ret = DateFormat.getTimeInstance(3, Locale.getDefault()).parse(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date);
        }
        return ret;
    }

    public static String datetime2StringLocal(Date date) {
        String ret;
        try {
            ret = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault()).format(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date.toString());
        }
        return ret;
    }

    public static Date strings2DateTimeLocal(String date, String time) {
        Date ret;
        try {
            ret = time != null ? DateFormat.getDateTimeInstance(3, 3, Locale.getDefault()).parse(date + " " + time) : DateFormat.getDateInstance(3, Locale.getDefault()).parse(date);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(date + " / " + time);
        }
        return ret;
    }

    public static String date2StringISO(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static Date string2DateISO(String st) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(st);
        }
        catch (ParseException e) {
            throw new InvalidArgumentException(st);
        }
    }

    public static String time2StringISO(Date date) {
        return new SimpleDateFormat("HH:mm:ss").format(date);
    }

    public static Date string2TimeISO(String st) {
        try {
            return new SimpleDateFormat("HH:mm:ss").parse(st);
        }
        catch (ParseException e) {
            throw new InvalidArgumentException(st);
        }
    }

    public static String datetime2StringISO(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static Date strings2DateTimeISO(String date, String time) {
        Date result;
        if (date == null) {
            throw new InvalidArgumentException("*** date must not be null");
        }
        try {
            result = time != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date + " " + time) : new SimpleDateFormat("yyyy-MM-dd").parse(date);
        }
        catch (ParseException e) {
            throw new InvalidArgumentException(date + " / " + time);
        }
        return result;
    }

    private static void errDeprecated(String method) {
        LoggerFactory.getLogger(HBCIUtils.class).info("programming error: the method " + method + "() has been deprecated, is very dangerous and will be removed soon.", (Object)1);
        LoggerFactory.getLogger(HBCIUtils.class).info("programming error: please check your application to replace calls to " + method + "() with calls to either " + method + "Local() or " + method + "ISO()", (Object)1);
    }

    public static String date2String(Date date) {
        HBCIUtils.errDeprecated("date2String");
        return HBCIUtils.date2StringLocal(date);
    }

    public static Date string2Date(String st) {
        HBCIUtils.errDeprecated("string2Date");
        return HBCIUtils.string2DateLocal(st);
    }

    public static String time2String(Date date) {
        HBCIUtils.errDeprecated("time2String");
        return HBCIUtils.time2StringLocal(date);
    }

    public static Date string2Time(String st) {
        HBCIUtils.errDeprecated("string2Time");
        return HBCIUtils.string2TimeLocal(st);
    }

    public static String datetime2String(Date date) {
        HBCIUtils.errDeprecated("datetime2String");
        return HBCIUtils.datetime2StringLocal(date);
    }

    public static Date strings2DateTime(String date, String time) {
        HBCIUtils.errDeprecated("strings2DateTime");
        return HBCIUtils.strings2DateTimeLocal(date, time);
    }

    public static String encodeBase64(byte[] x) {
        try {
            int origSize = x.length;
            if (origSize % 3 != 0) {
                byte[] temp = new byte[(origSize / 3 + 1) * 3];
                System.arraycopy(x, 0, temp, 0, origSize);
                x = temp;
            }
            StringBuffer ret = new StringBuffer();
            for (int readPos = 0; readPos < x.length << 3; readPos += 6) {
                int modulus = readPos & 7;
                if (readPos >> 3 < origSize) {
                    int value = modulus <= 2 ? x[readPos >> 3] >> 2 - modulus & 0x3F : x[readPos >> 3] << modulus - 2 & 0x3F | x[(readPos >> 3) + 1] >> 10 - modulus & (1 << modulus - 2) - 1;
                    ret.append(base64table[value]);
                    continue;
                }
                ret.append('=');
            }
            return ret.toString();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_UTIL_ENCB64"), ex);
        }
    }

    public static byte[] decodeBase64(String st) {
        try {
            byte[] source = st.getBytes("ISO-8859-1");
            byte[] ret = new byte[st.length()];
            int retlen = 0;
            int needFromFirst = 6;
            int needFromSecond = 2;
            boolean abort = false;
            int byteCounter = 0;
            int[] values = new int[2];
            for (int readPos = 0; readPos < source.length; ++readPos) {
                values[0] = 0;
                values[1] = 0;
                for (int step = 0; step < 2; ++step) {
                    int value = 0;
                    while (!(readPos + step >= source.length || (value = source[readPos + step]) >= 48 && value <= 57 || value >= 65 && value <= 90 || value >= 97 && value <= 122 || value == 43 || value == 47 || value == 61)) {
                        ++readPos;
                    }
                    if (!(value >= 48 && value <= 57 || value >= 65 && value <= 90 || value >= 97 && value <= 122 || value == 43 || value == 47)) {
                        abort = true;
                        break;
                    }
                    value = (char)value == '/' ? 63 : ((char)value == '+' ? 62 : ((char)value <= '9' ? 52 + value - 48 : ((char)value <= 'Z' ? (value -= 65) : 26 + value - 97)));
                    if (step == 0) {
                        values[0] = value << 8 - needFromFirst & 0xFF;
                        continue;
                    }
                    values[1] = value >> 6 - needFromSecond & 0xFF;
                }
                if (abort) break;
                ret[retlen++] = (byte)(values[0] | values[1]);
                if ((byteCounter & 3) == 2) {
                    ++readPos;
                    ++byteCounter;
                    needFromFirst = 6;
                    needFromSecond = 2;
                } else {
                    needFromFirst = 6 - needFromSecond;
                    needFromSecond = 8 - needFromFirst;
                }
                ++byteCounter;
            }
            byte[] ret2 = new byte[retlen];
            System.arraycopy(ret, 0, ret2, 0, retlen);
            return ret2;
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_UTIL_DECB64"), ex);
        }
    }

    private static Method getAccountCRCMethodByAlg(String alg) {
        Class<AccountCRCAlgs> cl = null;
        Method method = null;
        try {
            cl = AccountCRCAlgs.class;
            method = cl.getMethod("alg_" + alg, int[].class, int[].class);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(HBCIUtils.class).warn("CRC algorithm " + alg + " not yet implemented");
        }
        return method;
    }

    public static boolean canCheckAccountCRC(String blz) {
        BankInfo info = HBCIUtils.getBankInfo(blz);
        if (info == null) {
            return false;
        }
        String alg = info.getChecksumMethod();
        if (alg == null || alg.length() != 2) {
            return false;
        }
        Method method = HBCIUtils.getAccountCRCMethodByAlg(alg);
        return method != null;
    }

    public static boolean checkAccountCRC(String blz, String number) {
        String alg;
        BankInfo info = HBCIUtils.getBankInfo(blz);
        String string = alg = info != null ? info.getChecksumMethod() : null;
        if (alg == null || alg.length() != 2) {
            LoggerFactory.getLogger(HBCIUtils.class).warn("no crc information about " + blz + " in database");
            return true;
        }
        LoggerFactory.getLogger(HBCIUtils.class).debug("crc-checking " + blz + "/" + number);
        return HBCIUtils.checkAccountCRCByAlg(alg, blz, number);
    }

    private static int[] string2Ints(String st, int target_length) {
        int[] numbers = new int[target_length];
        int st_len = st.length();
        for (int i = 0; i < st_len; ++i) {
            char ch = st.charAt(i);
            numbers[target_length - st_len + i] = ch - 48;
        }
        return numbers;
    }

    public static boolean checkAccountCRCByAlg(String alg, String blz, String number) {
        boolean ret = true;
        if (blz == null || number == null) {
            throw new NullPointerException("blz and number must not be null");
        }
        if (number.length() <= 10) {
            Method method = HBCIUtils.getAccountCRCMethodByAlg(alg);
            if (method != null) {
                try {
                    int[] blz_digits = HBCIUtils.string2Ints(blz, 8);
                    int[] number_digits = HBCIUtils.string2Ints(number, 10);
                    Object[] args = new Object[]{blz_digits, number_digits};
                    ret = (Boolean)method.invoke(null, args);
                    LoggerFactory.getLogger(HBCIUtils.class).debug("\"CRC check for \"+blz+\"/\"+number+\" with alg \"+alg+\": \"+ret");
                }
                catch (Exception e) {
                    throw new HBCI_Exception(e);
                }
            }
        } else {
            LoggerFactory.getLogger(HBCIUtils.class).warn("can not check account numbers with more than 10 digits (" + number + ")- skipping CRC check");
        }
        return ret;
    }

    public static boolean checkAccountCRCByAlg(String alg, String number) {
        return HBCIUtils.checkAccountCRCByAlg(alg, "", number);
    }

    public static boolean checkIBANCRC(String iban) {
        return AccountCRCAlgs.checkIBAN(iban);
    }

    public static boolean checkCredtitorIdCRC(String creditorId) {
        return AccountCRCAlgs.checkCreditorId(creditorId);
    }

    private static void refreshBLZList(String blzpath) throws IOException {
        FileInputStream f;
        if (blzpath == null) {
            blzpath = "";
        }
        if ((f = new FileInputStream(blzpath = blzpath + "blz.properties")) == null) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_BLZLOAD", blzpath));
        }
        HBCIUtils.refreshBLZList(f);
        ((InputStream)f).close();
    }

    public static void refreshBLZList(InputStream in) throws IOException {
        LoggerFactory.getLogger(HBCIUtils.class).debug("trying to load BLZ data");
        blzs.clear();
        blzs.load(in);
        banks.clear();
        for (Map.Entry<Object, Object> e : blzs.entrySet()) {
            String blz = (String)e.getKey();
            String value = (String)e.getValue();
            BankInfo info = BankInfo.parse(value);
            info.setBlz(blz);
            banks.put(blz, info);
        }
    }

    public static BigDecimal string2BigDecimal(String st) {
        BigDecimal result = new BigDecimal(st);
        result.setScale(2, 6);
        return result;
    }

    @Deprecated
    public static double string2Value(String st) {
        return Double.parseDouble(st);
    }

    @Deprecated
    public static String value2String(double value) {
        DecimalFormat format = new DecimalFormat("0.00");
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        format.setDecimalSeparatorAlwaysShown(true);
        return format.format(value);
    }

    public static String version() {
        return VERSION;
    }

    public static void log(String s, int logLevel) {
        switch (logLevel) {
            case 0: 
            case 6: {
                LoggerFactory.getLogger(HBCIUtils.class).trace(s);
                break;
            }
            case 1: {
                LoggerFactory.getLogger(HBCIUtils.class).error(s);
                break;
            }
            case 2: {
                LoggerFactory.getLogger(HBCIUtils.class).warn(s);
                break;
            }
            case 3: {
                LoggerFactory.getLogger(HBCIUtils.class).info(s);
                break;
            }
            case 4: 
            case 5: {
                LoggerFactory.getLogger(HBCIUtils.class).debug(s);
            }
        }
    }

    public static String bigDecimal2String(BigDecimal value) {
        DecimalFormat format = new DecimalFormat("0.##");
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        format.setDecimalSeparatorAlwaysShown(false);
        return format.format(value);
    }

    public static String getLocMsg(String key) {
        try {
            return ResourceBundle.getBundle("hbci4java-messages", Locale.getDefault()).getString(key);
        }
        catch (MissingResourceException re) {
            LoggerFactory.getLogger(HBCIUtils.class).debug(re.getMessage(), (Throwable)re);
            return key;
        }
    }

    public static String getLocMsg(String key, Object o) {
        return HBCIUtils.getLocMsg(key, new Object[]{o});
    }

    public static String getLocMsg(String key, Object[] o) {
        return MessageFormat.format(HBCIUtils.getLocMsg(key), o);
    }

    public static boolean ignoreError(HBCIPassport passport, String paramName, String msg) {
        boolean ret = false;
        String paramValue = "no";
        if (passport != null) {
            paramValue = passport.getProperties().getProperty(paramName, "no");
        }
        if (paramValue.equals("yes")) {
            LoggerFactory.getLogger(HBCIUtils.class).info(msg, (Object)1);
            LoggerFactory.getLogger(HBCIUtils.class).info("ignoring error because param " + paramName + "=yes", (Object)1);
            ret = true;
        }
        return ret;
    }

    public static long string2Long(String st, long factor) {
        BigDecimal result = new BigDecimal(st);
        result = result.multiply(new BigDecimal(factor));
        return result.longValue();
    }

    public static String withCounter(String st, int idx) {
        return st + (idx != 0 ? "_" + Integer.toString(idx + 1) : "");
    }

    public static int getPosiOfNextDelimiter(String st, int posi) {
        int len = st.length();
        boolean quoting = false;
        while (posi < len) {
            char ch = st.charAt(posi);
            if (!quoting) {
                if (ch == '?') {
                    quoting = true;
                } else if (ch == '@') {
                    int endpos = st.indexOf(64, posi + 1);
                    String binlen_st = st.substring(posi + 1, endpos);
                    int binlen = Integer.parseInt(binlen_st);
                    posi += binlen_st.length() + 1 + binlen;
                } else if (ch == '\'' || ch == '+' || ch == ':') {
                    break;
                }
            } else {
                quoting = false;
            }
            ++posi;
        }
        return posi;
    }

    public static String stripLeadingZeroes(String st) {
        String ret = null;
        if (st != null) {
            int start;
            int l = st.length();
            for (start = 0; start < l && st.charAt(start) == '0'; ++start) {
            }
            ret = st.substring(start);
        }
        return ret;
    }

    public static void log(Exception e) {
        LoggerFactory.getLogger(HBCIUtils.class).error(e.getMessage(), (Throwable)e);
    }

    public static String getParam(String s, String s1) {
        return s1;
    }

    public static HBCICallback getCallback() {
        return null;
    }

    public static String getParam(String s) {
        return HBCIUtils.getParam(s, null);
    }

    public static void setParam(String s, Object o) {
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }
}

