/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.kapott.hbci.comm.CommPinTan;
import org.kapott.hbci.exceptions.CanNotParseMessageException;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIKernel;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.protocol.MSG;
import org.kapott.hbci.rewrite.Rewrite;
import org.kapott.hbci.security.Crypt;
import org.kapott.hbci.security.Sig;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class HBCIKernelImpl
implements HBCIKernel {
    public static final boolean SIGNIT = true;
    public static final boolean DONT_SIGNIT = false;
    public static final boolean CRYPTIT = true;
    public static final boolean DONT_CRYPTIT = false;
    public static final boolean NEED_SIG = true;
    public static final boolean DONT_NEED_SIG = false;
    public static final boolean NEED_CRYPT = true;
    public static final boolean DONT_NEED_CRYPT = false;
    private MsgGen gen;
    private String currentMsgName;
    private HBCIPassportInternal passport;
    private CommPinTan commPinTan;

    public HBCIKernelImpl(HBCIPassportInternal passport) {
        this.passport = passport;
        this.createMsgGen();
        this.commPinTan = new CommPinTan(this.gen, passport.getProperties().getProperty("kernel.rewriter"), passport.getHost(), passport.getCallback()).withProxy(passport.getProxy(), passport.getProxyUser(), passport.getProxyPass());
    }

    private void createMsgGen() {
        String filename;
        ClassLoader cl;
        InputStream syntaxStream;
        String xmlpath = HBCIUtils.getParam("kernel.kernel.xmlpath");
        if (xmlpath == null) {
            xmlpath = "";
        }
        if ((syntaxStream = (cl = this.getClass().getClassLoader()).getResourceAsStream(filename = xmlpath + "hbci-" + this.passport.getHBCIVersion() + ".xml")) == null) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_KRNL_CANTLOAD_SYN", filename));
        }
        try {
            this.gen = new MsgGen(syntaxStream);
            this.currentMsgName = null;
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_MSGGEN_INIT"), e);
        }
    }

    @Override
    public String getHBCIVersion() {
        return this.passport.getHBCIVersion();
    }

    public String getHBCIVersion(int dummy) {
        String ret = "";
        NodeList nodes = this.gen.getSyntax().getElementById("MsgHeadUser").getElementsByTagName("value");
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Element node = (Element)nodes.item(i);
            if (!node.getAttribute("path").equals("hbciversion")) continue;
            ret = node.getFirstChild().getNodeValue();
            break;
        }
        return ret;
    }

    public void rawNewMsg(String name) {
        if (name == null || name.length() == 0) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_EMPTY_MSGNAME"));
        }
        this.currentMsgName = name;
        HBCIUtils.log("creating new raw message " + name, 5);
        this.gen.reset();
    }

    public void rawSet(String key, String value) {
        HBCIUtils.log("setting raw property " + this.currentMsgName + "." + key + " to \"" + value + "\"", 5);
        if (this.currentMsgName == null) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_NORAWMSG"));
        }
        if (key == null) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_KEYNULL"));
        }
        if (value == null) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_VALUENULL", key));
        }
        if (value.length() != 0) {
            this.gen.set(this.currentMsgName + "." + key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBCIMsgStatus rawDoIt(boolean signit, boolean cryptit, boolean needSig, boolean needCrypt) {
        HBCIMsgStatus ret = new HBCIMsgStatus();
        MSG msg = null;
        try {
            String errmsg;
            boolean crypted;
            block32: {
                String errmsg2;
                HBCIUtils.log("generating raw message " + this.currentMsgName, 4);
                this.passport.getCallback().status(21, this.currentMsgName);
                msg = this.gen.generate(this.currentMsgName);
                Hashtable<String, Object> kernelData = this.createKernelData(ret, signit, cryptit, needSig, needCrypt);
                String rewriters_st = this.passport.getProperties().getProperty("kernel.rewriter");
                ArrayList<Rewrite> al = new ArrayList<Rewrite>();
                StringTokenizer tok = new StringTokenizer(rewriters_st, ",");
                while (tok.hasMoreTokens()) {
                    String rewriterName = tok.nextToken().trim();
                    if (rewriterName.length() == 0) continue;
                    Class<?> cl = this.getClass().getClassLoader().loadClass("org.kapott.hbci.rewrite.R" + rewriterName);
                    Constructor<?> con = cl.getConstructor(null);
                    Rewrite rewriter = (Rewrite)con.newInstance(null);
                    rewriter.setKernelData(kernelData);
                    al.add(rewriter);
                }
                Rewrite[] rewriters = al.toArray(new Rewrite[al.size()]);
                for (int i = 0; i < rewriters.length; ++i) {
                    MSG old = msg;
                    msg = rewriters[i].outgoingClearText(old, this.gen);
                }
                if (signit) {
                    String errmsg3;
                    HBCIUtils.log("trying to insert signature", 4);
                    this.passport.getCallback().status(22, null);
                    Sig sig = new Sig(msg);
                    if (!sig.signIt(this.passport, this.gen) && !HBCIUtils.ignoreError(null, "client.errors.ignoreSignErrors", errmsg3 = HBCIUtils.getLocMsg("EXCMSG_CANTSIGN"))) {
                        throw new HBCI_Exception(errmsg3);
                    }
                    for (int i = 0; i < rewriters.length; ++i) {
                        MSG old = msg;
                        msg = rewriters[i].outgoingSigned(old, this.gen);
                    }
                }
                Properties paths = new Properties();
                msg.getElementPaths(paths, null, null, null);
                ret.addData(paths);
                Hashtable<String, String> current = new Hashtable<String, String>();
                msg.extractValues(current);
                Properties origs = new Properties();
                Enumeration<String> e = current.keys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    String value = current.get(key);
                    origs.setProperty("orig_" + key, value);
                }
                ret.addData(origs);
                String outstring = msg.toString(0);
                HBCIUtils.log("sending message: " + outstring, 5);
                int maxmsgsize = this.passport.getMaxMsgSizeKB();
                if (maxmsgsize != 0 && outstring.length() >> 10 > maxmsgsize && !HBCIUtils.ignoreError(null, "client.errors.ignoreMsgSizeErrors", errmsg2 = HBCIUtils.getLocMsg("EXCMSG_MSGTOOLARGE", new Object[]{Integer.toString(outstring.length() >> 10), Integer.toString(maxmsgsize)}))) {
                    throw new HBCI_Exception(errmsg2);
                }
                if (cryptit) {
                    String errmsg4;
                    HBCIUtils.log("trying to encrypt message", 4);
                    this.passport.getCallback().status(23, null);
                    Crypt crypt = new Crypt(msg);
                    msg = crypt.cryptIt(this.passport, this.gen, "Crypted");
                    if (!msg.getName().equals("Crypted") && !HBCIUtils.ignoreError(null, "client.errors.ignoreCryptErrors", errmsg4 = HBCIUtils.getLocMsg("EXCMSG_CANTCRYPT"))) {
                        throw new HBCI_Exception(errmsg4);
                    }
                    for (int i = 0; i < rewriters.length; ++i) {
                        MSG oldMsg = msg;
                        msg = rewriters[i].outgoingCrypted(oldMsg, this.gen);
                    }
                    HBCIUtils.log("encrypted message to be sent: " + msg.toString(0), 5);
                }
                String msgPath = msg.getPath();
                String msgnum = msg.getValueOfDE(msgPath + ".MsgHead.msgnum");
                String dialogid = msg.getValueOfDE(msgPath + ".MsgHead.dialogid");
                String hbciversion = msg.getValueOfDE(msgPath + ".MsgHead.hbciversion");
                HBCIUtils.log("communicating dialogid/msgnum " + dialogid + "/" + msgnum, 4);
                MSG old = msg;
                msg = this.commPinTan.pingpong(kernelData, this.currentMsgName, old);
                crypted = msg.getName().equals("CryptedRes");
                if (crypted) {
                    this.passport.getCallback().status(25, null);
                    HBCIUtils.log("acquire crypt instance", 4);
                    Crypt crypt = new Crypt(msg);
                    HBCIUtils.log("decrypting using " + crypt, 4);
                    String newmsgstring = crypt.decryptIt(this.gen, this.passport);
                    this.gen.set("_origSignedMsg", newmsgstring);
                    HBCIUtils.log("rewriting message", 4);
                    for (int i = 0; i < rewriters.length; ++i) {
                        HBCIUtils.log("applying rewriter " + rewriters[i].getClass().getSimpleName(), 4);
                        newmsgstring = rewriters[i].incomingClearText(newmsgstring, this.gen);
                    }
                    HBCIUtils.log("rewriting done", 4);
                    HBCIUtils.log("decrypted message after rewriting: " + newmsgstring, 5);
                    try {
                        this.passport.getCallback().status(28, this.currentMsgName + "Res");
                        HBCIUtils.log("message to pe parsed: " + msg.toString(0), 5);
                        MSG oldMsg = msg;
                        msg = new MSG(this.currentMsgName + "Res", newmsgstring, newmsgstring.length(), this.gen, true, true);
                    }
                    catch (Exception ex) {
                        throw new CanNotParseMessageException(HBCIUtils.getLocMsg("EXCMSG_CANTPARSE"), newmsgstring, ex);
                    }
                }
                HBCIUtils.log("received message after decryption: " + msg.toString(0), 5);
                for (int i = 0; i < rewriters.length; ++i) {
                    MSG oldMsg = msg;
                    msg = rewriters[i].incomingData(oldMsg, this.gen);
                }
                HBCIUtils.log("extracting data from received message", 4);
                Properties p = msg.getData();
                p.setProperty("_msg", this.gen.get("_origSignedMsg"));
                ret.addData(p);
                msgPath = msg.getPath();
                try {
                    String hbciversion2 = msg.getValueOfDE(msgPath + ".MsgHead.hbciversion");
                    if (!hbciversion2.equals(hbciversion)) {
                        throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVVERSION", new Object[]{hbciversion2, hbciversion}));
                    }
                    String msgnum2 = msg.getValueOfDE(msgPath + ".MsgHead.msgnum");
                    if (!msgnum2.equals(msgnum)) {
                        throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVMSGNUM_HEAD", new Object[]{msgnum2, msgnum}));
                    }
                    msgnum2 = msg.getValueOfDE(msgPath + ".MsgTail.msgnum");
                    if (!msgnum2.equals(msgnum)) {
                        throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVMSGNUM_TAIL", new Object[]{msgnum2, msgnum}));
                    }
                    String dialogid2 = msg.getValueOfDE(msgPath + ".MsgHead.dialogid");
                    if (!dialogid.equals("0") && !dialogid2.equals(dialogid)) {
                        throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVDIALOGID", new Object[]{dialogid2, dialogid}));
                    }
                    if (!dialogid.equals("0") && !msg.getValueOfDE(msgPath + ".MsgHead.MsgRef.dialogid").equals(dialogid)) {
                        throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVDIALOGID_REF"));
                    }
                    if (!msg.getValueOfDE(msgPath + ".MsgHead.MsgRef.msgnum").equals(msgnum)) {
                        throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_INVMSGNUM_REF"));
                    }
                }
                catch (HBCI_Exception e2) {
                    String errmsg5 = HBCIUtils.getLocMsg("EXCMSG_MSGCHECK") + ": " + HBCIUtils.exception2String(e2);
                    if (HBCIUtils.ignoreError(this.passport, "client.errors.ignoreMsgCheckErrors", errmsg5)) break block32;
                    throw e2;
                }
            }
            HBCIUtils.log("looking for a signature", 4);
            this.passport.getCallback().status(26, null);
            Sig sig = new Sig(msg);
            boolean sigOk = sig.verify(this.passport, this.gen);
            HBCIUtils.log("looking if message is encrypted", 4);
            if (needCrypt && !crypted && !HBCIUtils.ignoreError(this.passport, "client.errors.ignoreCryptErrors", errmsg = HBCIUtils.getLocMsg("EXCMSG_NOTCRYPTED"))) {
                throw new HBCI_Exception(errmsg);
            }
            if (!sigOk && !HBCIUtils.ignoreError(null, "client.errors.ignoreSignErrors", errmsg = HBCIUtils.getLocMsg("EXCMSG_INVSIG"))) {
                throw new HBCI_Exception(errmsg);
            }
        }
        catch (Exception e) {
            String paramName = "client.errors.ignoreDialogEndErrors";
            if (this.currentMsgName.startsWith("DialogEnd") && HBCIUtils.getParam(paramName, "no").equals("yes")) {
                HBCIUtils.log(e);
                HBCIUtils.log("error while receiving DialogEnd response - but ignoring it because of special setting", 2);
            } else {
                ret.addException(e);
            }
        }
        finally {
            this.currentMsgName = null;
            this.gen.reset();
        }
        return ret;
    }

    public void reset() {
        this.gen.reset();
        this.currentMsgName = null;
    }

    private Hashtable<String, Object> createKernelData(HBCIMsgStatus ret, boolean signit, boolean cryptit, boolean needSig, boolean needCrypt) {
        Hashtable<String, Object> kernelData = new Hashtable<String, Object>();
        kernelData.put("msgStatus", ret);
        kernelData.put("msgName", this.currentMsgName);
        kernelData.put("signIt", signit);
        kernelData.put("cryptIt", cryptit);
        kernelData.put("needSig", needSig);
        kernelData.put("needCrypt", needCrypt);
        return kernelData;
    }

    @Override
    public List<String> getLowlevelJobParameterNames(String gvname, String version) {
        return this.getMsgGen().getGVParameterNames(gvname, version);
    }

    @Override
    public List<String> getLowlevelJobResultNames(String gvname, String version) {
        return this.getMsgGen().getGVResultNames(gvname, version);
    }

    @Override
    public List<String> getLowlevelJobRestrictionNames(String gvname, String version) {
        return this.getMsgGen().getGVRestrictionNames(gvname, version);
    }

    public MsgGen getMsgGen() {
        return this.gen;
    }
}

