/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.lang.reflect.Constructor;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;

public class HBCIJobFactory {
    public static HBCIJobImpl newJob(String jobname, HBCIPassportInternal passport, MsgGen msgGen) {
        HBCIJobImpl ret;
        block4: {
            HBCIUtils.log("creating new job " + jobname, 4);
            if (jobname == null || jobname.length() == 0) {
                throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
            }
            ret = null;
            String className = "org.kapott.hbci.GV.GV" + jobname;
            try {
                Class<?> cl = Class.forName(className);
                Constructor<?> cons = cl.getConstructor(HBCIPassportInternal.class, MsgGen.class);
                ret = (HBCIJobImpl)cons.newInstance(passport, msgGen);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidUserDataException("*** there is no highlevel job named " + jobname + " - need class " + className);
            }
            catch (Exception e) {
                String msg = HBCIUtils.getLocMsg("EXCMSG_JOB_CREATE_ERR", jobname);
                if (HBCIUtils.ignoreError(null, "client.errors.ignoreCreateJobErrors", msg)) break block4;
                throw new HBCI_Exception(msg, e);
            }
        }
        return ret;
    }
}

