/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.exceptions.ProcessException;
import org.kapott.hbci.manager.HBCIKernelImpl;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public final class HBCIInstitute
implements IHandlerData {
    private static final String BPD_KEY_LASTUPDATE = "_lastupdate";
    private static final String BPD_KEY_HBCIVERSION = "_hbciversion";
    private HBCIPassportInternal passport;
    private HBCIKernelImpl kernel;

    public HBCIInstitute(HBCIKernelImpl kernel, HBCIPassportInternal passport) {
        this.kernel = kernel;
        this.passport = passport;
    }

    void updateBPD(Properties result) {
        HBCIUtils.log("extracting BPD from results", 4);
        Properties p = new Properties();
        Enumeration<Object> e = result.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("BPD.")) continue;
            p.setProperty(key.substring("BPD.".length()), result.getProperty(key));
        }
        if (p.size() != 0) {
            p.setProperty(BPD_KEY_HBCIVERSION, this.kernel.getHBCIVersion());
            p.setProperty(BPD_KEY_LASTUPDATE, String.valueOf(System.currentTimeMillis()));
            this.passport.setBPD(p);
            HBCIUtils.log("installed new BPD with version " + this.passport.getBPDVersion(), 3);
            this.passport.getCallback().status(4, this.passport.getBPD());
        }
    }

    void extractKeys(Properties result) {
        boolean foundChanges;
        block5: {
            foundChanges = false;
            try {
                HBCIUtils.log("extracting public institute keys from results", 4);
                for (int i = 0; i < 3; ++i) {
                    String head = HBCIUtils.withCounter("SendPubKey", i);
                    String keyType = result.getProperty(head + ".KeyName.keytype");
                    if (keyType == null) continue;
                    String keyCountry = result.getProperty(head + ".KeyName.KIK.country");
                    String keyBLZ = result.getProperty(head + ".KeyName.KIK.blz");
                    String keyUserId = result.getProperty(head + ".KeyName.userid");
                    String keyNum = result.getProperty(head + ".KeyName.keynum");
                    String keyVersion = result.getProperty(head + ".KeyName.keyversion");
                    HBCIUtils.log("found key " + keyCountry + "_" + keyBLZ + "_" + keyUserId + "_" + keyType + "_" + keyNum + "_" + keyVersion, 3);
                    byte[] keyExponent = result.getProperty(head + ".PubKey.exponent").getBytes("ISO-8859-1");
                    byte[] keyModulus = result.getProperty(head + ".PubKey.modulus").getBytes("ISO-8859-1");
                    KeyFactory fac = KeyFactory.getInstance("RSA");
                    RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, keyModulus), new BigInteger(1, keyExponent));
                    PublicKey key = fac.generatePublic(spec);
                    if (keyType.equals("S")) {
                        this.passport.setInstSigKey(new HBCIKey(keyCountry, keyBLZ, keyUserId, keyNum, keyVersion, key));
                        foundChanges = true;
                        continue;
                    }
                    if (!keyType.equals("V")) continue;
                    this.passport.setInstEncKey(new HBCIKey(keyCountry, keyBLZ, keyUserId, keyNum, keyVersion, key));
                    foundChanges = true;
                }
            }
            catch (Exception e) {
                String msg = HBCIUtils.getLocMsg("EXCMSG_EXTR_IKEYS_ERR");
                if (HBCIUtils.ignoreError(null, "client.errors.ignoreExtractKeysErrors", msg + ": " + HBCIUtils.exception2String(e))) break block5;
                throw new HBCI_Exception(msg, e);
            }
        }
        if (foundChanges) {
            this.passport.getCallback().status(6, null);
        }
    }

    private void doDialogEnd(String dialogid, boolean needSig) {
        this.passport.getCallback().status(19, null);
        this.kernel.rawNewMsg("DialogEndAnon");
        this.kernel.rawSet("MsgHead.dialogid", dialogid);
        this.kernel.rawSet("MsgHead.msgnum", "2");
        this.kernel.rawSet("DialogEndS.dialogid", dialogid);
        this.kernel.rawSet("MsgTail.msgnum", "2");
        HBCIMsgStatus status = this.kernel.rawDoIt(false, false, needSig, false);
        this.passport.getCallback().status(20, status);
        if (!status.isOK()) {
            HBCIUtils.log("dialog end failed: " + status.getErrorString(), 1);
            String msg = HBCIUtils.getLocMsg("ERR_INST_ENDFAILED");
            if (!HBCIUtils.ignoreError(null, "client.errors.ignoreDialogEndErrors", msg + ": " + status.getErrorString())) {
                throw new ProcessException(msg, status);
            }
        }
    }

    private boolean isBPDExpired() {
        Properties bpd = this.passport.getBPD();
        String maxAge = HBCIUtils.getParam("bpd.maxage.days", "7");
        HBCIUtils.log("[BPD] max age: " + maxAge + " days", 3);
        long maxMillis = -1L;
        try {
            int days = Integer.parseInt(maxAge);
            if (days == 0) {
                HBCIUtils.log("[BPD] auto-expiry disabled", 3);
                return false;
            }
            if (days > 0) {
                maxMillis = (long)(days * 24 * 60 * 60) * 1000L;
            }
        }
        catch (NumberFormatException e) {
            HBCIUtils.log(e);
            return false;
        }
        long lastUpdate = 0L;
        if (bpd != null) {
            String s = bpd.getProperty(BPD_KEY_LASTUPDATE, Long.toString(lastUpdate));
            try {
                lastUpdate = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                HBCIUtils.log(e);
                return false;
            }
            HBCIUtils.log("[BPD] last update: " + (lastUpdate == 0L ? "never" : new Date(lastUpdate)), 3);
        }
        long now = System.currentTimeMillis();
        if (maxMillis < 0L || now - lastUpdate > maxMillis) {
            HBCIUtils.log("[BPD] expired, will be updated now", 3);
            return true;
        }
        return false;
    }

    public void fetchBPD() {
        Properties bpd = this.passport.getBPD();
        String hbciVersionOfBPD = bpd != null ? bpd.getProperty(BPD_KEY_HBCIVERSION) : null;
        String version = this.passport.getBPDVersion();
        if (version.equals("0") || this.isBPDExpired() || hbciVersionOfBPD == null || !hbciVersionOfBPD.equals(this.kernel.getHBCIVersion())) {
            try {
                if (!version.equals("0")) {
                    HBCIUtils.log("resetting BPD version from " + version + " to 0", 3);
                    this.passport.getBPD().setProperty("BPA.version", "0");
                }
                this.passport.getCallback().status(3, null);
                HBCIUtils.log("fetching BPD", 3);
                this.kernel.rawNewMsg("DialogInitAnon");
                this.kernel.rawSet("Idn.KIK.blz", this.passport.getBLZ());
                this.kernel.rawSet("Idn.KIK.country", this.passport.getCountry());
                this.kernel.rawSet("ProcPrep.BPD", "0");
                this.kernel.rawSet("ProcPrep.UPD", this.passport.getUPDVersion());
                this.kernel.rawSet("ProcPrep.lang", "0");
                this.kernel.rawSet("ProcPrep.prodName", HBCIUtils.getParam("client.product.name", "HBCI4Java"));
                this.kernel.rawSet("ProcPrep.prodVersion", HBCIUtils.getParam("client.product.version", "2.5"));
                HBCIMsgStatus status = this.kernel.rawDoIt(false, false, false, false);
                Properties result = status.getData();
                this.updateBPD(result);
                if (!status.isDialogClosed()) {
                    try {
                        this.doDialogEnd(result.getProperty("MsgHead.dialogid"), false);
                    }
                    catch (Exception ex) {
                        HBCIUtils.log(ex);
                    }
                }
                if (!status.isOK()) {
                    HBCIUtils.log("fetching BPD failed", 1);
                    throw new ProcessException(HBCIUtils.getLocMsg("ERR_INST_BPDFAILED"), status);
                }
            }
            catch (Exception e) {
                HBCI_Exception he;
                if (e instanceof HBCI_Exception && (he = (HBCI_Exception)e).isFatal()) {
                    throw he;
                }
                HBCIUtils.log("FAILED! - maybe this institute does not support anonymous logins", 3);
                HBCIUtils.log("we will nevertheless go on", 3);
            }
        }
        HBCIUtils.log("checking if requested hbci parameters are supported", 4);
        if (this.passport.getBPD() != null) {
            String msg;
            if (!this.passport.isSupported() && !HBCIUtils.ignoreError(null, "client.errors.ignoreSecMechCheckErrors", msg = HBCIUtils.getLocMsg("EXCMSG_SECMETHNOTSUPP"))) {
                throw new InvalidUserDataException(msg);
            }
            if (!Arrays.asList(this.passport.getSuppVersions()).contains(this.kernel.getHBCIVersion(0)) && !HBCIUtils.ignoreError(null, "client.errors.ignoreVersionCheckErrors", msg = HBCIUtils.getLocMsg("EXCMSG_VERSIONNOTSUPP"))) {
                throw new InvalidUserDataException(msg);
            }
        } else {
            HBCIUtils.log("can not check if requested parameters are supported", 2);
        }
    }

    public void register() {
        this.fetchBPD();
        this.passport.setPersistentData("_registered_institute", Boolean.TRUE);
    }

    @Override
    public MsgGen getMsgGen() {
        return this.kernel.getMsgGen();
    }

    @Override
    public HBCIPassportInternal getPassport() {
        return this.passport;
    }
}

