/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.kapott.hbci.GV.GVTemplate;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIInstitute;
import org.kapott.hbci.manager.HBCIJobFactory;
import org.kapott.hbci.manager.HBCIKernel;
import org.kapott.hbci.manager.HBCIUser;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.IHandlerData;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIDialogStatus;
import org.kapott.hbci.status.HBCIExecStatus;

public final class HBCIHandler
implements IHandlerData {
    private HBCIDialog dialog;

    public HBCIHandler(HBCIDialog hbciDialog) {
        try {
            this.dialog = hbciDialog;
            this.registerInstitute();
            this.registerUser();
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CANT_CREATE_HANDLE"), e);
        }
        Properties upd = hbciDialog.getPassport().getUPD();
        if (upd != null && !upd.containsKey("_fetchedMetaInfo")) {
            this.updateMetaInfo();
        }
    }

    public Object getProperty(String key) {
        return this.dialog.getPassport().getProperties().get(key);
    }

    public void updateMetaInfo() {
        Properties bpd = this.dialog.getPassport().getBPD();
        if (bpd == null) {
            HBCIUtils.log("have no bpd, skip fetching of meta info", 2);
            return;
        }
        try {
            HBCIExecStatus status;
            Properties lowlevel = this.getPassport().getSupportedLowlevelJobs(this.getMsgGen());
            if (lowlevel.getProperty("SEPAInfo") != null) {
                HBCIUtils.log("fetching SEPA information", 3);
                HBCIJobImpl sepainfo = HBCIJobFactory.newJob("SEPAInfo", this.getPassport(), this.getMsgGen());
                this.addJobToDialog(sepainfo);
            }
            if (lowlevel.getProperty("TANMediaList") != null) {
                HBCIUtils.log("fetching TAN media list", 3);
                HBCIJobImpl tanMedia = HBCIJobFactory.newJob("TANMediaList", this.getPassport(), this.getMsgGen());
                this.addJobToDialog(tanMedia);
            }
            if ((status = this.execute(false)).isOK()) {
                HBCIUtils.log("successfully fetched meta info", 3);
                this.dialog.getPassport().getUPD().setProperty("_fetchedMetaInfo", new Date().toString());
            } else {
                HBCIUtils.log("error while fetching meta info: " + status.toString(), 1);
            }
        }
        catch (Exception e) {
            HBCIUtils.log(e);
        }
    }

    public void updateSEPAInfo() {
        Properties bpd = this.dialog.getPassport().getBPD();
        if (bpd == null) {
            HBCIUtils.log("have no bpd, skipping SEPA information fetching", 2);
            return;
        }
        try {
            if (this.getPassport().getSupportedLowlevelJobs(this.getMsgGen()).getProperty("SEPAInfo") != null) {
                HBCIUtils.log("trying to fetch SEPA information from institute", 3);
                HBCIJobImpl sepainfo = HBCIJobFactory.newJob("SEPAInfo", this.getPassport(), this.getMsgGen());
                this.addJobToDialog(sepainfo);
                HBCIExecStatus status = this.execute(false);
                if (status.isOK()) {
                    HBCIUtils.log("successfully fetched information about SEPA accounts from institute", 3);
                    this.dialog.getPassport().getUPD().setProperty("_fetchedSEPA", "1");
                } else {
                    HBCIUtils.log("error while fetching information about SEPA accounts from institute:", 1);
                    HBCIUtils.log(status.toString(), 1);
                }
            } else {
                HBCIUtils.log("institute does not support SEPA accounts, so we skip fetching information about SEPA", 4);
            }
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception(e);
        }
    }

    private void registerInstitute() {
        try {
            HBCIUtils.log("registering institute", 4);
            HBCIInstitute inst = new HBCIInstitute(this.dialog.getKernel(), this.dialog.getPassport());
            inst.register();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CANT_REG_INST"), ex);
        }
    }

    private void registerUser() {
        try {
            HBCIUtils.log("registering user", 4);
            HBCIUser user = new HBCIUser(this.dialog.getKernel(), this.dialog.getPassport());
            user.register();
        }
        catch (Exception ex) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CANT_REG_USER"), ex);
        }
    }

    public HBCIDialog getDialog() {
        return this.dialog;
    }

    public HBCIJob newLowlevelJob(String gvname) {
        HBCIUtils.log("generating new lowlevel-job " + gvname, 4);
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        GVTemplate ret = new GVTemplate(gvname, this.getPassport(), this.getMsgGen());
        return ret;
    }

    public void addJobToDialog(HBCIJob job) {
        try {
            this.dialog.addTask((HBCIJobImpl)job);
        }
        finally {
            if (this.dialog != null && this.dialog.getAllTasks().size() == 0) {
                HBCIUtils.log("removing empty dialog for customerid " + this.getPassport().getCustomerId() + " from list of dialogs", 4);
                this.dialog = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBCIExecStatus execute(boolean closeDialog) {
        String origCustomerId = this.dialog.getPassport().getCustomerId();
        try {
            HBCIExecStatus ret = new HBCIExecStatus();
            HBCIUtils.log("executing dialog", 4);
            try {
                HBCIDialogStatus dialogStatus = this.dialog.doIt(closeDialog);
                ret.addDialogStatus(dialogStatus);
            }
            catch (Exception e) {
                ret.addException(e);
            }
            HBCIExecStatus hBCIExecStatus = ret;
            return hBCIExecStatus;
        }
        finally {
            this.dialog.getPassport().setCustomerId(origCustomerId);
        }
    }

    @Override
    public HBCIPassportInternal getPassport() {
        return this.dialog.getPassport();
    }

    public HBCIKernel getKernel() {
        return this.dialog.getKernel();
    }

    @Override
    public MsgGen getMsgGen() {
        return this.dialog.getKernel().getMsgGen();
    }

    public List<String> getLowlevelJobParameterNames(String gvname) {
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        String version = this.getPassport().getSupportedLowlevelJobs(this.getMsgGen()).getProperty(gvname);
        if (version == null) {
            throw new HBCI_Exception("*** lowlevel job " + gvname + " not supported");
        }
        return this.dialog.getKernel().getLowlevelJobParameterNames(gvname, version);
    }

    public List<String> getLowlevelJobResultNames(String gvname) {
        if (gvname == null || gvname.length() == 0) {
            throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXCMSG_EMPTY_JOBNAME"));
        }
        String version = this.getPassport().getSupportedLowlevelJobs(this.getMsgGen()).getProperty(gvname);
        if (version == null) {
            throw new HBCI_Exception("*** lowlevel job " + gvname + " not supported");
        }
        return this.dialog.getKernel().getLowlevelJobResultNames(gvname, version);
    }

    public void status(int statusMsgSend, Object o) {
        this.dialog.getPassport().getCallback().status(statusMsgSend, o);
    }

    public void callback(int closeConnection, String callb_close_conn, int typeNone, StringBuffer stringBuffer) {
        this.dialog.getPassport().getCallback().callback(closeConnection, callb_close_conn, typeNone, stringBuffer);
    }
}

