/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.datatypes.factory.SyntaxDEFactory;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HHDVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChallengeInfo {
    private Map<String, Job> data = null;

    public ChallengeInfo() {
        HBCIUtils.log("initializing challenge info engine", 4);
        String xmlpath = HBCIUtils.getParam("kernel.kernel.challengedatapath", "");
        InputStream dataStream = null;
        String filename = xmlpath + "challengedata.xml";
        dataStream = ChallengeInfo.class.getClassLoader().getResourceAsStream(filename);
        if (dataStream == null) {
            throw new InvalidUserDataException("*** can not load challenge information from " + filename);
        }
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setValidating(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(dataStream);
            dataStream.close();
        }
        catch (Exception e) {
            throw new HBCI_Exception("*** can not load challengedata from file " + filename, e);
        }
        this.data = new HashMap<String, Job>();
        NodeList jobs = doc.getElementsByTagName("job");
        int size = jobs.getLength();
        for (int i = 0; i < size; ++i) {
            Element job = (Element)jobs.item(i);
            String code = job.getAttribute("code");
            this.data.put(code, new Job(job));
        }
        HBCIUtils.log("challenge information loaded", 4);
    }

    public Job getData(String code) {
        return this.data.get(code);
    }

    public void applyParams(HBCIJobImpl task, HBCIJob hktan, Properties secmech) {
        String code = task.getHBCICode();
        Job job = this.getData(code);
        if (job == null) {
            HBCIUtils.log("have no challenge data for " + code + ", will not apply challenge params", 3);
            return;
        }
        HHDVersion version = HHDVersion.find(secmech);
        HBCIUtils.log("using hhd version " + (Object)((Object)version), 5);
        HhdVersion hhd = job.getVersion(version.getChallengeVersion());
        if (hhd == null) {
            HBCIUtils.log("have no challenge data for " + code + " in " + (Object)((Object)version) + ", will not apply challenge params", 3);
            return;
        }
        String klass = hhd.getKlass();
        HBCIUtils.log("using challenge klass " + klass, 5);
        hktan.setParam("challengeklass", klass);
        List<Param> params = hhd.getParams();
        for (int i = 0; i < params.size(); ++i) {
            int num = i + 1;
            Param param = params.get(i);
            if (!param.isComplied(secmech)) {
                HBCIUtils.log("skipping challenge parameter " + num + " (" + param.path + "), condition " + param.conditionName + "=" + param.conditionValue + " not complied", 5);
                continue;
            }
            String value = param.getValue(task);
            if (value == null || value.length() == 0) {
                HBCIUtils.log("challenge parameter " + num + " (" + param.path + ") is empty", 5);
                continue;
            }
            HBCIUtils.log("adding challenge parameter " + num + " " + param.path + "=" + value, 5);
            hktan.setParam("ChallengeKlassParam" + num, value);
        }
    }

    public static class Param {
        private String type = null;
        private String path = null;
        private String conditionName = null;
        private String conditionValue = null;

        private Param(Element param) {
            Node content = param.getFirstChild();
            this.path = content != null ? content.getNodeValue() : null;
            this.type = param.getAttribute("type");
            this.conditionName = param.getAttribute("condition-name");
            this.conditionValue = param.getAttribute("condition-value");
        }

        public boolean isComplied(Properties secmech) {
            if (this.conditionName == null || this.conditionName.length() == 0) {
                return true;
            }
            String value = secmech.getProperty(this.conditionName, "");
            return value.equals(this.conditionValue);
        }

        public String getType() {
            return this.type;
        }

        public String getPath() {
            return this.path;
        }

        private String getValue(HBCIJobImpl job) {
            if (this.path == null || this.path.length() == 0) {
                return null;
            }
            String value = job.getChallengeParam(this.path);
            return this.format(value);
        }

        public String format(String value) {
            if (value == null || value.trim().length() == 0) {
                return null;
            }
            if (this.type == null || this.type.trim().length() == 0) {
                return value;
            }
            SyntaxDEFactory factory = SyntaxDEFactory.getInstance();
            SyntaxDE syntax = factory.createSyntaxDE(this.type, this.path, value, 0, 0);
            return syntax.toString(0);
        }
    }

    public static class HhdVersion {
        private String klass = null;
        private List<Param> params = new ArrayList<Param>();

        private HhdVersion(Element spec) {
            this.klass = ((Element)spec.getElementsByTagName("klass").item(0)).getFirstChild().getNodeValue();
            NodeList list = spec.getElementsByTagName("param");
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Element param = (Element)list.item(i);
                this.params.add(new Param(param));
            }
        }

        public String getKlass() {
            return this.klass;
        }

        public List<Param> getParams() {
            return this.params;
        }
    }

    public static class Job {
        private Map<String, HhdVersion> versions = new HashMap<String, HhdVersion>();

        private Job(Element job) {
            NodeList specs = job.getElementsByTagName("challengeinfo");
            int size = specs.getLength();
            for (int i = 0; i < size; ++i) {
                Element spec = (Element)specs.item(i);
                String version = spec.getAttribute("spec");
                this.versions.put(version, new HhdVersion(spec));
            }
        }

        public HhdVersion getVersion(String version) {
            return this.versions.get(version);
        }
    }
}

