/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes;

import java.math.BigInteger;
import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;

public class SyntaxBin
extends SyntaxDE {
    private static String expandNumber(String x) {
        try {
            return new String(new BigInteger(x).toByteArray(), "ISO-8859-1");
        }
        catch (Exception ex) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_BINNUMERR"), ex);
        }
    }

    private static String expand(String x) {
        char format = x.charAt(0);
        String st = x.substring(1);
        String ret = null;
        switch (format) {
            case 'N': {
                ret = SyntaxBin.expandNumber(st);
                break;
            }
            case 'B': {
                ret = st;
                break;
            }
            default: {
                throw new InvalidArgumentException(HBCIUtils.getLocMsg("EXC_DTBIN_NO_VALID_FORMAT", Character.toString(format)));
            }
        }
        return ret;
    }

    public SyntaxBin(String x, int minlen, int maxlen) {
        super(SyntaxBin.expand(x), minlen, maxlen);
    }

    @Override
    public void init(String x, int minlen, int maxlen) {
        super.init(SyntaxBin.expand(x), minlen, maxlen);
    }

    @Override
    public String toString(int zero) {
        String con = this.getContent();
        String header = "@" + Integer.toString(con.length()) + "@";
        return header + con;
    }

    private int getHeaderLen(String st) {
        int idx = 0;
        int delimFound = 0;
        int len = st.length();
        while (idx < len && delimFound != 2) {
            if (st.charAt(idx++) != '@') continue;
            ++delimFound;
        }
        return idx;
    }

    private String parse(String st) {
        int headerLen = this.getHeaderLen(st);
        String ret = "";
        if (headerLen != 0) {
            int size = Integer.parseInt(st.substring(1, headerLen - 1));
            ret = st.substring(headerLen, headerLen + size);
        }
        return ret;
    }

    private void initData(StringBuffer res, int minsize, int maxsize) {
        int startidx = SyntaxBin.skipPreDelim(res);
        int endidx = SyntaxBin.findNextDelim(res, startidx);
        String st = res.substring(startidx, endidx);
        String temp = this.parse(st);
        this.setContent(temp, minsize, maxsize);
        res.delete(0, endidx);
    }

    public SyntaxBin(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    @Override
    public void init(StringBuffer res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }
}

