/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.comm;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.comm.Filter;
import org.kapott.hbci.comm.PinTanProxyAuthenticator;
import org.kapott.hbci.comm.PinTanSSLHostnameVerifier;
import org.kapott.hbci.comm.PinTanSSLSocketFactory;
import org.kapott.hbci.exceptions.CanNotParseMessageException;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.ParseErrorException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.protocol.MSG;
import org.kapott.hbci.rewrite.Rewrite;

public final class CommPinTan {
    private MsgGen msgGen;
    private String rewriter;
    private HBCICallback callback;
    private URL url;
    private HttpURLConnection conn;
    private Filter filter = Filter.getInstance("Base64");
    public static final String ENCODING = "ISO-8859-1";
    private SSLSocketFactory mySocketFactory;
    private HostnameVerifier myHostnameVerifier;
    private static final int HTTP_CONNECT_TIMEOUT = 60000;
    private static final int HTTP_READ_TIMEOUT = 300000;

    public CommPinTan() {
    }

    public CommPinTan(MsgGen msgGen, String rewriter, String host, HBCICallback callback) {
        this.msgGen = msgGen;
        this.rewriter = rewriter;
        this.callback = callback;
        try {
            HBCIUtils.log("connect: " + host, 3);
            this.url = new URL(host);
            this.mySocketFactory = new PinTanSSLSocketFactory();
            this.myHostnameVerifier = new PinTanSSLHostnameVerifier();
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_CONNERR"), e);
        }
    }

    public CommPinTan withProxy(String proxyHost, String proxyUser, String proxyPass) {
        String[] proxyData;
        if (proxyHost != null && (proxyData = proxyHost.split(":")).length == 2) {
            HBCIUtils.log("HTTPS connections will be made using proxy " + proxyData[0] + "(Port " + proxyData[1] + ")", 3);
            Properties sysProps = System.getProperties();
            sysProps.put("https.proxyHost", proxyData[0]);
            sysProps.put("https.proxyPort", proxyData[1]);
            HBCIUtils.log("initializing HBCI4Java proxy authentication callback", 4);
            Authenticator.setDefault(new PinTanProxyAuthenticator(proxyUser, proxyPass));
        }
        return this;
    }

    public MSG pingpong(Hashtable<String, Object> kernelData, String msgName, MSG msg) {
        HBCIUtils.log("---------------- request ----------------", 4);
        msg.log(4);
        this.callback.status(24, null);
        this.callback.status(30, msg.toString(0));
        this.ping(msg);
        this.callback.status(27, null);
        String st = this.pong(this.msgGen).toString();
        this.callback.status(31, st);
        HBCIUtils.log("---------------- response ----------------", 4);
        String[] split = st.split("'");
        for (int i = 0; i < split.length; ++i) {
            HBCIUtils.log(split[i], 4);
        }
        MSG retmsg = null;
        try {
            ArrayList<Rewrite> al = new ArrayList<Rewrite>();
            StringTokenizer tok = new StringTokenizer(this.rewriter, ",");
            while (tok.hasMoreTokens()) {
                String rewriterName = tok.nextToken().trim();
                if (rewriterName.length() == 0) continue;
                Class<?> cl = this.getClass().getClassLoader().loadClass("org.kapott.hbci.rewrite.R" + rewriterName);
                Constructor<?> con = cl.getConstructor(null);
                Rewrite rewriter = (Rewrite)con.newInstance(null);
                rewriter.setKernelData(kernelData);
                al.add(rewriter);
            }
            Rewrite[] rewriters = al.toArray(new Rewrite[al.size()]);
            for (int i = 0; i < rewriters.length; ++i) {
                st = rewriters[i].incomingCrypted(st, this.msgGen);
            }
            this.callback.status(28, "CryptedRes");
            try {
                HBCIUtils.log("trying to parse message as crypted message", 4);
                retmsg = new MSG("CryptedRes", st, st.length(), this.msgGen, false, true);
            }
            catch (ParseErrorException e) {
                HBCIUtils.log("message seems not to be encrypted; tring to parse it as " + msgName + "Res message", 4);
                this.msgGen.set("_origSignedMsg", st);
                for (int i = 0; i < rewriters.length; ++i) {
                    st = rewriters[i].incomingClearText(st, this.msgGen);
                }
                this.callback.status(28, msgName + "Res");
                retmsg = new MSG(msgName + "Res", st, st.length(), this.msgGen, true, true);
            }
        }
        catch (Exception ex) {
            throw new CanNotParseMessageException(HBCIUtils.getLocMsg("EXCMSG_CANTPARSE"), st, ex);
        }
        return retmsg;
    }

    protected void ping(MSG msg) {
        try {
            byte[] b = this.filter.encode(msg.toString(0));
            HBCIUtils.log("connecting to server", 4);
            this.conn = (HttpURLConnection)this.url.openConnection();
            this.conn.setConnectTimeout(60000);
            this.conn.setReadTimeout(300000);
            boolean debugging = ((PinTanSSLSocketFactory)this.mySocketFactory).debug();
            if (debugging) {
                HttpsURLConnection connSSL = (HttpsURLConnection)this.conn;
                HBCIUtils.log("activating modified socket factory for debugging=" + debugging, 4);
                connSSL.setSSLSocketFactory(this.mySocketFactory);
                HBCIUtils.log("activating modified hostname verifier because cert checking is disabled", 4);
                connSSL.setHostnameVerifier(this.myHostnameVerifier);
            }
            this.conn.setDoOutput(true);
            this.conn.setRequestMethod("POST");
            this.conn.setRequestProperty("Content-Type", "application/octet-stream");
            this.conn.setFixedLengthStreamingMode(b.length);
            this.conn.connect();
            OutputStream out = this.conn.getOutputStream();
            HBCIUtils.log("POST data to output stream", 4);
            out.write(b);
            out.flush();
            HBCIUtils.log("closing output stream", 4);
            out.close();
        }
        catch (Exception e) {
            HBCI_Exception he = new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_SENDERR"), e);
            he.setFatal(true);
            throw he;
        }
    }

    protected StringBuffer pong(MsgGen gen) {
        try {
            int num;
            byte[] b = new byte[1024];
            StringBuffer ret = new StringBuffer();
            HBCIUtils.log(HBCIUtils.getLocMsg("STATUS_MSG_RECV"), 4);
            int msgsize = this.conn.getContentLength();
            if (msgsize != -1) {
                HBCIUtils.log("found messagesize: " + msgsize, 4);
            } else {
                HBCIUtils.log("can not determine message size, trying to detect automatically", 4);
            }
            InputStream i = this.conn.getInputStream();
            while (msgsize != 0 && (num = i.read(b)) > 0) {
                HBCIUtils.log("received " + num + " bytes", 5);
                ret.append(new String(b, 0, num, ENCODING));
                if ((msgsize -= num) >= 0) {
                    HBCIUtils.log("we still need " + msgsize + " bytes", 5);
                    continue;
                }
                HBCIUtils.log("read " + num + " bytes, looking for more", 5);
            }
            HBCIUtils.log("closing communication line", 4);
            this.conn.disconnect();
            return new StringBuffer(this.filter.decode(ret.toString()));
        }
        catch (Exception e) {
            throw new HBCI_Exception(HBCIUtils.getLocMsg("EXCMSG_RECVERR"), e);
        }
    }
}

