/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIRetVal;
import org.kapott.hbci.status.HBCIStatus;

public class HBCIJobResultImpl
implements Serializable,
HBCIJobResult {
    private HBCIPassportInternal passport;
    private Properties resultData;
    public HBCIStatus jobStatus;
    public HBCIStatus globStatus;

    public HBCIJobResultImpl(HBCIPassportInternal passport) {
        this.passport = passport;
        this.resultData = new Properties();
        this.jobStatus = new HBCIStatus();
        this.globStatus = new HBCIStatus();
    }

    public void storeResult(String key, String value) {
        if (value != null) {
            this.resultData.setProperty(key, value);
        }
    }

    @Override
    public int getRetNumber() {
        return this.jobStatus.getRetVals().size();
    }

    @Override
    public HBCIRetVal getRetVal(int idx) {
        return this.jobStatus.getRetVals().get(idx);
    }

    @Override
    public boolean isOK() {
        return this.globStatus.getStatusCode() != 2 && this.jobStatus.getStatusCode() != 2 && (this.globStatus.getStatusCode() != 1 || this.jobStatus.getStatusCode() != 1);
    }

    @Override
    public String getDialogId() {
        return this.resultData.getProperty("basic.dialogid");
    }

    @Override
    public String getMsgNum() {
        return this.resultData.getProperty("basic.msgnum");
    }

    @Override
    public String getSegNum() {
        return this.resultData.getProperty("basic.segnum");
    }

    @Override
    public String getJobId() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(new Date()) + "/" + this.getDialogId() + "/" + this.getMsgNum() + "/" + this.getSegNum();
    }

    @Override
    public Properties getResultData() {
        return this.resultData;
    }

    @Override
    public HBCIStatus getGlobStatus() {
        return this.globStatus;
    }

    @Override
    public HBCIStatus getJobStatus() {
        return this.jobStatus;
    }

    @Override
    public HBCIPassportInternal getPassport() {
        return this.passport;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        Object[] a = this.resultData.keySet().toArray();
        Arrays.sort(a);
        for (int i = 0; i < a.length; ++i) {
            String key = (String)a[i];
            ret.append(key).append(" = ").append(this.resultData.getProperty(key)).append(System.getProperty("line.separator"));
        }
        return ret.toString().trim();
    }
}

