/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.BigDecimalValue;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.TypedValue;

public final class GVRWPDepotUms
extends HBCIJobResultImpl {
    private List<Entry> entries = new ArrayList<Entry>();
    public String rest;

    public GVRWPDepotUms(HBCIPassportInternal passport) {
        super(passport);
    }

    public void addEntry(Entry ums) {
        this.entries.add(ums);
    }

    public Entry[] getEntries() {
        return this.entries.toArray(new Entry[this.entries.size()]);
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        String linesep = System.getProperty("line.separator");
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.get(i);
            ret.append("Entry #").append(i).append(":").append(linesep);
            ret.append(e.toString() + linesep + linesep);
        }
        ret.append("rest: ").append(this.rest);
        return ret.toString().trim();
    }

    public static final class Entry {
        public Date timestamp;
        public Konto depot;
        public final List<FinancialInstrument> instruments = new ArrayList<FinancialInstrument>();

        public String toString() {
            StringBuilder rv = new StringBuilder();
            String sep = System.getProperty("line.separator");
            rv.append("timestamp: ").append(this.timestamp).append(sep);
            rv.append("depot: ").append(this.depot).append(sep);
            for (int i = 0; i < this.instruments.size(); ++i) {
                rv.append("====> Instrument ").append(i).append(":").append(sep);
                rv.append(this.instruments.get(i));
                rv.append("<====").append(sep);
            }
            return rv.toString();
        }

        public static class FinancialInstrument {
            public String isin;
            public String wkn;
            public String name;
            public TypedValue startSaldo;
            public TypedValue endSaldo;
            public TypedValue preis;
            public Date preisdatum;
            public final List<Transaction> transactions = new ArrayList<Transaction>();

            public String toString() {
                StringBuilder rv = new StringBuilder();
                String sep = System.getProperty("line.separator");
                rv.append("isin: ").append(this.isin).append(sep);
                rv.append("wkn: ").append(this.wkn).append(sep);
                rv.append("name: ").append(this.name).append(sep);
                rv.append("startSaldo: ").append(this.startSaldo).append(sep);
                rv.append("endSaldo: ").append(this.endSaldo).append(sep);
                rv.append("preis: ").append(this.preis).append(sep);
                rv.append("preisdatum: ").append(this.preisdatum).append(sep);
                for (int i = 0; i < this.transactions.size(); ++i) {
                    rv.append("--> Transaction ").append(i).append(":").append(sep);
                    rv.append(this.transactions.get(i));
                    rv.append("<--").append(sep);
                }
                return rv.toString();
            }

            public static class Transaction {
                public static final int INDICATOR_SETTLEMENT_CLEARING = 1;
                public static final int INDICATOR_CORPORATE_ACTION = 2;
                @Deprecated
                public static final int INDICATOR_KAPITALMASSNAHME = 2;
                public static final int INDICATOR_LEIHE = 3;
                public static final int INDICATOR_SICHERHEITEN = 4;
                public static final int RICHTUNG_LIEFERUNG = 1;
                public static final int RICHTUNG_ERHALT = 2;
                public static final int BEZAHLUNG_GEGEN_ZAHLUNG = 1;
                public static final int BEZAHLUNG_FREI = 2;
                public String kundenreferenz;
                public TypedValue anzahl;
                public BigDecimalValue betrag;
                public BigDecimalValue stueckzinsen;
                public int stueckzins_tage;
                public int transaction_indicator;
                public int richtung;
                public int bezahlung;
                public boolean ccp_eligibility;
                public Date datum;
                public Date datum_valuta;
                public boolean storno;
                public String gegenpartei;
                public String freitext_details;

                public String toString() {
                    StringBuilder rv = new StringBuilder();
                    String sep = System.getProperty("line.separator");
                    rv.append("kundenreferenz: ").append(this.kundenreferenz).append(sep);
                    rv.append("anzahl: ").append(this.anzahl).append(sep);
                    rv.append("betrag: ").append(this.betrag).append(sep);
                    rv.append("stueckzinsen: ").append(this.stueckzinsen).append(sep);
                    rv.append("stueckzins_tage: ").append(this.stueckzins_tage).append(sep);
                    rv.append("transaction_indicator: ").append(this.transaction_indicator).append(": ");
                    switch (this.transaction_indicator) {
                        case 2: {
                            rv.append("Corporate Action");
                            break;
                        }
                        case 1: {
                            rv.append("Settlement/Clearing");
                            break;
                        }
                        case 3: {
                            rv.append("Leihe");
                            break;
                        }
                        case 4: {
                            rv.append("Sicherheiten");
                            break;
                        }
                        default: {
                            rv.append("Unbekannt");
                        }
                    }
                    rv.append(sep);
                    rv.append("richtung: ").append(this.richtung).append(": ");
                    switch (this.richtung) {
                        case 2: {
                            rv.append("Erhalt");
                            break;
                        }
                        case 1: {
                            rv.append("Lieferung");
                            break;
                        }
                        default: {
                            rv.append("Unbekannt");
                        }
                    }
                    rv.append(sep);
                    rv.append("bezahlung: ").append(this.bezahlung).append(": ");
                    switch (this.bezahlung) {
                        case 2: {
                            rv.append("frei");
                            break;
                        }
                        case 1: {
                            rv.append("gegen Zahlung");
                            break;
                        }
                        default: {
                            rv.append("Unbekannt");
                        }
                    }
                    rv.append(sep);
                    rv.append("ccp_eligibility: ").append(this.ccp_eligibility).append(sep);
                    rv.append("datum: ").append(this.datum).append(sep);
                    rv.append("datum_valuta: ").append(this.datum_valuta).append(sep);
                    rv.append("storno: ").append(this.storno).append(sep);
                    rv.append("gegenpartei: ").append(this.gegenpartei).append(sep);
                    rv.append("freitext_details: ").append(this.freitext_details).append(sep);
                    return rv.toString();
                }
            }
        }
    }
}

