/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.exceptions.JobNotSupportedException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.protocol.SEG;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.status.HBCIRetVal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public abstract class HBCIJobImpl
implements HBCIJob {
    private MsgGen gen;
    private String name;
    private String jobName;
    private String segVersion;
    private Properties llParams;
    protected HBCIJobResultImpl jobResult;
    protected HBCIPassport passport;
    private int idx;
    private boolean executed;
    private int contentCounter;
    private Hashtable<String, String[][]> constraints;
    private Hashtable<String, Integer> logFilterLevels;
    private String externalId;
    private HashSet<String> indexedConstraints;
    private static final Pattern INDEX_PATTERN = Pattern.compile("(\\w+\\.\\w+\\.\\w+)(\\.\\w+)?");

    public String getJobName() {
        return this.jobName;
    }

    protected HBCIJobImpl(HBCIPassport passport, MsgGen gen, String jobnameLL, HBCIJobResultImpl jobResult) {
        this.passport = passport;
        this.gen = gen;
        this.findSpecNameForGV(jobnameLL);
        this.llParams = new Properties();
        this.jobResult = jobResult;
        this.contentCounter = 0;
        this.constraints = new Hashtable();
        this.logFilterLevels = new Hashtable();
        this.indexedConstraints = new HashSet();
        this.executed = false;
        this.llParams.setProperty(this.name, "requested");
    }

    public String getHBCICode() {
        StringBuffer ret = null;
        StringBuffer searchString = new StringBuffer(this.name);
        for (int i = searchString.length() - 1; i >= 0; --i) {
            if (searchString.charAt(i) >= '0' && searchString.charAt(i) <= '9') continue;
            searchString.insert(i + 1, "Par");
            searchString.append(".SegHead.code");
            break;
        }
        StringBuffer tempkey = new StringBuffer();
        Enumeration<?> i = this.passport.getBPD().propertyNames();
        while (i.hasMoreElements()) {
            String key = (String)i.nextElement();
            if (key.indexOf("Params") != 0) continue;
            tempkey.setLength(0);
            tempkey.append(key);
            tempkey.delete(0, tempkey.indexOf(".") + 1);
            if (!tempkey.toString().equals(searchString.toString())) continue;
            ret = new StringBuffer(this.passport.getBPD().getProperty(key));
            ret.replace(1, 2, "K");
            ret.deleteCharAt(ret.length() - 1);
            break;
        }
        if (ret != null) {
            return ret.toString();
        }
        return null;
    }

    private void findSpecNameForGV(String jobnameLL) {
        int maxVersion = 0;
        StringBuffer key = new StringBuffer();
        Properties bpd = this.passport.getBPD();
        Enumeration<?> i = bpd.propertyNames();
        while (i.hasMoreElements()) {
            String path = (String)i.nextElement();
            key.setLength(0);
            key.append(path);
            if (key.indexOf("Params") != 0) continue;
            key.delete(0, key.indexOf(".") + 1);
            if (key.indexOf(jobnameLL + "Par") != 0 || !key.toString().endsWith(".SegHead.code")) continue;
            int maxAllowedVersion = Integer.parseInt(HBCIUtils.getParam("kernel.gv." + bpd.getProperty(path, "default") + ".segversion.max", "0"));
            key.delete(0, jobnameLL.length() + "Par".length());
            String st = key.substring(0, key.indexOf("."));
            int version = 0;
            try {
                version = Integer.parseInt(st);
            }
            catch (Exception e) {
                HBCIUtils.log("found invalid job version: key=" + key + ", jobnameLL=" + jobnameLL + " (this is a known, but harmless bug)", 2);
            }
            if (maxAllowedVersion > 0 && version > maxAllowedVersion) {
                HBCIUtils.log("skipping segment version " + version + " for task " + jobnameLL + ", larger than allowed version " + maxAllowedVersion, 3);
                continue;
            }
            if (version == 0) continue;
            HBCIUtils.log("task " + jobnameLL + " is supported with segment version " + st, 5);
            if (version <= maxVersion) continue;
            maxVersion = version;
        }
        if (maxVersion == 0) {
            String msg = HBCIUtils.getLocMsg("EXCMSG_GVNOTSUPP", jobnameLL);
            if (!HBCIUtils.ignoreError(this.passport, "client.errors.ignoreJobNotSupported", msg)) {
                throw new JobNotSupportedException(jobnameLL);
            }
            maxVersion = 1;
            HBCIUtils.log("Using segment version " + maxVersion + " for job " + jobnameLL + ", although not found in BPD. This may fail", 2);
        }
        this.jobName = jobnameLL;
        this.segVersion = Integer.toString(maxVersion);
        this.name = jobnameLL + this.segVersion;
    }

    public void setSegVersion(String version) {
        String[] value;
        String[] names;
        if (version == null || version.length() == 0) {
            HBCIUtils.log("tried to change segment version for task " + this.jobName + " explicit, but no version given", 2);
            return;
        }
        if (version.equals(this.segVersion)) {
            return;
        }
        HBCIUtils.log("changing segment version for task " + this.jobName + " explicit from " + this.segVersion + " to " + version, 3);
        String oldName = this.name;
        this.segVersion = version;
        this.name = this.jobName + version;
        for (String s : names = this.llParams.keySet().toArray(new String[this.llParams.size()])) {
            if (!s.startsWith(oldName)) continue;
            value = this.llParams.getProperty(s);
            String newName = s.replaceFirst(oldName, this.name);
            this.llParams.remove(s);
            this.llParams.setProperty(newName, (String)value);
        }
        Enumeration<String> e = this.constraints.keys();
        while (e.hasMoreElements()) {
            String frontendName = e.nextElement();
            String[][] values = this.constraints.get(frontendName);
            for (int i = 0; i < values.length; ++i) {
                value = values[i];
                if (!value[0].startsWith(oldName)) continue;
                value[0] = value[0].replaceFirst(oldName, this.name);
            }
        }
    }

    public int getMaxNumberPerMsg() {
        int ret = 1;
        StringBuffer searchString = new StringBuffer(this.name);
        for (int i = searchString.length() - 1; i >= 0; --i) {
            if (searchString.charAt(i) >= '0' && searchString.charAt(i) <= '9') continue;
            searchString.insert(i + 1, "Par");
            searchString.append(".maxnum");
            break;
        }
        StringBuffer tempkey = new StringBuffer();
        Enumeration<?> i = this.passport.getBPD().propertyNames();
        while (i.hasMoreElements()) {
            String key = (String)i.nextElement();
            if (key.indexOf("Params") != 0) continue;
            tempkey.setLength(0);
            tempkey.append(key);
            tempkey.delete(0, tempkey.indexOf(".") + 1);
            if (!tempkey.toString().equals(searchString.toString())) continue;
            ret = Integer.parseInt(this.passport.getBPD().getProperty(key));
            break;
        }
        return ret;
    }

    public int getMinSigs() {
        int ret = 0;
        StringBuffer searchString = new StringBuffer(this.name);
        for (int i = searchString.length() - 1; i >= 0; --i) {
            if (searchString.charAt(i) >= '0' && searchString.charAt(i) <= '9') continue;
            searchString.insert(i + 1, "Par");
            searchString.append(".minsigs");
            break;
        }
        StringBuffer tempkey = new StringBuffer();
        Enumeration<?> i = this.passport.getBPD().propertyNames();
        while (i.hasMoreElements()) {
            String key = (String)i.nextElement();
            if (key.indexOf("Params") != 0) continue;
            tempkey.setLength(0);
            tempkey.append(key);
            tempkey.delete(0, tempkey.indexOf(".") + 1);
            if (!tempkey.toString().equals(searchString.toString())) continue;
            ret = Integer.parseInt(this.passport.getBPD().getProperty(key));
            break;
        }
        return ret;
    }

    public int getSecurityClass() {
        int ret = 1;
        StringBuffer searchString = new StringBuffer(this.name);
        for (int i = searchString.length() - 1; i >= 0; --i) {
            if (searchString.charAt(i) >= '0' && searchString.charAt(i) <= '9') continue;
            searchString.insert(i + 1, "Par");
            searchString.append(".secclass");
            break;
        }
        StringBuffer tempkey = new StringBuffer();
        Enumeration<?> i = this.passport.getBPD().propertyNames();
        while (i.hasMoreElements()) {
            String key = (String)i.nextElement();
            if (key.indexOf("Params") != 0) continue;
            tempkey.setLength(0);
            tempkey.append(key);
            tempkey.delete(0, tempkey.indexOf(".") + 1);
            if (!tempkey.toString().equals(searchString.toString())) continue;
            ret = Integer.parseInt(this.passport.getBPD().getProperty(key));
            break;
        }
        return ret;
    }

    protected void addConstraint(String frontendName, String destinationName, String defValue, int logFilterLevel) {
        this.addConstraint(frontendName, destinationName, defValue, logFilterLevel, false);
    }

    protected void addConstraint(String frontendName, String destinationName, String defValue, int logFilterLevel, boolean indexed) {
        String[] value = new String[]{this.getName() + "." + destinationName, defValue};
        String[][] values = this.constraints.get(frontendName);
        if (values == null) {
            values = new String[][]{value};
        } else {
            ArrayList a = new ArrayList(Arrays.asList(values));
            a.add(value);
            values = (String[][])a.toArray((T[])values);
        }
        this.constraints.put(frontendName, values);
        if (indexed) {
            this.indexedConstraints.add(frontendName);
        }
        if (logFilterLevel > 0) {
            this.logFilterLevels.put(frontendName, new Integer(logFilterLevel));
        }
    }

    public void verifyConstraints() {
        for (String frontendName : this.constraints.keySet()) {
            String[][] values = this.constraints.get(frontendName);
            for (int j = 0; j < values.length; ++j) {
                String[] value = values[j];
                String destination = value[0];
                String defValue = value[1];
                String givenContent = this.getLowlevelParam(destination);
                if (givenContent == null && this.indexedConstraints.contains(frontendName)) {
                    givenContent = this.getLowlevelParam(this.insertIndex(destination, 0));
                }
                String content = null;
                content = defValue;
                if (givenContent != null && givenContent.length() != 0) {
                    content = givenContent;
                }
                if (content == null) {
                    String msg = HBCIUtils.getLocMsg("EXC_MISSING_HL_PROPERTY", frontendName);
                    if (!HBCIUtils.ignoreError(this.passport, "client.errors.ignoreWrongJobDataErrors", msg)) {
                        throw new InvalidUserDataException(msg);
                    }
                    content = "";
                }
                if (content.length() == 0 || givenContent != null) continue;
                this.setLowlevelParam(destination, content);
            }
        }
        SEG seg = null;
        try {
            seg = this.createJobSegment();
            seg.validate();
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** the job segment for this task can not be created", ex);
        }
    }

    public SEG createJobSegment() {
        return this.createJobSegment(0);
    }

    public SEG createJobSegment(int segnum) {
        SEG seg;
        try {
            seg = new SEG(this.getName(), this.getName(), null, 0, this.gen.getSyntax());
            Enumeration<?> e = this.getLowlevelParams().propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = this.getLowlevelParams().getProperty(key);
                seg.propagateValue(key, value, true, false);
            }
            seg.propagateValue(this.getName() + ".SegHead.seq", Integer.toString(segnum), false, true);
        }
        catch (Exception ex) {
            throw new HBCI_Exception("*** the job segment for this task can not be created", ex);
        }
        return seg;
    }

    public List<String> getJobParameterNames() {
        return this.gen.getGVParameterNames(this.name);
    }

    @Override
    public List<String> getJobResultNames() {
        return this.gen.getGVResultNames(this.name);
    }

    @Override
    public Properties getJobRestrictions() {
        return this.passport.getJobRestrictions(this.name);
    }

    @Override
    public void setParam(String paramname, Konto acc) {
        this.setParam(paramname, null, acc);
    }

    @Override
    public void setParam(String paramname, Integer index, Konto acc) {
        if (this.acceptsParam(paramname + ".country") && acc.country != null && acc.country.length() != 0) {
            this.setParam(paramname + ".country", index, acc.country);
        }
        if (this.acceptsParam(paramname + ".blz") && acc.blz != null && acc.blz.length() != 0) {
            this.setParam(paramname + ".blz", index, acc.blz);
        }
        if (this.acceptsParam(paramname + ".number") && acc.number != null && acc.number.length() != 0) {
            this.setParam(paramname + ".number", index, acc.number);
        }
        if (this.acceptsParam(paramname + ".subnumber") && acc.subnumber != null && acc.subnumber.length() != 0) {
            this.setParam(paramname + ".subnumber", index, acc.subnumber);
        }
        if (this.acceptsParam(paramname + ".name") && acc.name != null && acc.name.length() != 0) {
            this.setParam(paramname + ".name", index, acc.name);
        }
        if (this.acceptsParam(paramname + ".curr") && acc.curr != null && acc.curr.length() != 0) {
            this.setParam(paramname + ".curr", index, acc.curr);
        }
        if (this.acceptsParam(paramname + ".bic") && acc.bic != null && acc.bic.length() != 0) {
            this.setParam(paramname + ".bic", index, acc.bic);
        }
        if (this.acceptsParam(paramname + ".iban") && acc.iban != null && acc.iban.length() != 0) {
            this.setParam(paramname + ".iban", index, acc.iban);
        }
    }

    @Override
    public void setParam(String paramname, Value v) {
        this.setParam(paramname, null, v);
    }

    @Override
    public void setParam(String paramname, Integer index, Value v) {
        if (this.acceptsParam(paramname + ".value")) {
            this.setParam(paramname + ".value", index, HBCIUtils.bigDecimal2String(v.getBigDecimalValue()));
        }
        String curr = v.getCurr();
        if (this.acceptsParam(paramname + ".curr") && curr != null && curr.length() != 0) {
            this.setParam(paramname + ".curr", index, curr);
        }
    }

    @Override
    public void setParam(String paramName, Date date) {
        this.setParam(paramName, null, date);
    }

    @Override
    public void setParam(String paramName, Integer index, Date date) {
        this.setParam(paramName, index, HBCIUtils.date2StringISO(date));
    }

    @Override
    public void setParam(String paramName, int i) {
        this.setParam(paramName, Integer.toString(i));
    }

    protected boolean acceptsParam(String hlParamName) {
        return this.constraints.get(hlParamName) != null;
    }

    @Override
    public void setParam(String paramName, String value) {
        this.setParam(paramName, null, value);
    }

    @Override
    public void setParam(String paramName, Integer index, String value) {
        String msg;
        String[][] destinations = this.constraints.get(paramName);
        if (destinations == null) {
            msg = HBCIUtils.getLocMsg("EXCMSG_PARAM_NOTNEEDED", new String[]{paramName, this.getName()});
            if (!HBCIUtils.ignoreError(this.passport, "client.errors.ignoreWrongJobDataErrors", msg)) {
                throw new InvalidUserDataException(msg);
            }
            destinations = new String[][]{};
        }
        if (value == null || value.length() == 0) {
            msg = HBCIUtils.getLocMsg("EXCMSG_PARAM_EMPTY", new String[]{paramName, this.getName()});
            if (!HBCIUtils.ignoreError(this.passport, "client.errors.ignoreWrongJobDataErrors", msg)) {
                throw new InvalidUserDataException(msg);
            }
            value = "";
        }
        if (index != null && !this.indexedConstraints.contains(paramName) && !HBCIUtils.ignoreError(this.passport, "client.errors.ignoreWrongJobDataErrors", msg = HBCIUtils.getLocMsg("EXCMSG_PARAM_NOTINDEXED", new String[]{paramName, this.getName()}))) {
            throw new InvalidUserDataException(msg);
        }
        for (int i = 0; i < destinations.length; ++i) {
            String[] valuePair = destinations[i];
            String lowlevelname = valuePair[0];
            if (index != null && this.indexedConstraints.contains(paramName)) {
                lowlevelname = this.insertIndex(lowlevelname, index);
            }
            this.setLowlevelParam(lowlevelname, value);
        }
    }

    public void setContinueOffset(int loop) {
        String offset = this.getContinueOffset(loop);
        this.setLowlevelParam(this.getName() + ".offset", offset != null ? offset : "");
    }

    protected void setLowlevelParam(String key, String value) {
        HBCIUtils.log("setting lowlevel parameter " + key + " = " + value, 4);
        this.llParams.setProperty(key, value);
    }

    @Override
    public Properties getLowlevelParams() {
        return this.llParams;
    }

    public void setLowlevelParams(Properties llParams) {
        this.llParams = llParams;
    }

    public String getLowlevelParam(String key) {
        return this.getLowlevelParams().getProperty(key);
    }

    public void setIdx(int idx) {
        this.idx = idx;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSegVersion() {
        return this.segVersion;
    }

    public boolean needsContinue(int loop) {
        boolean needs = false;
        if (this.executed) {
            HBCIRetVal retval = null;
            int num = this.jobResult.getRetNumber();
            for (int i = 0; i < num; ++i) {
                retval = this.jobResult.getRetVal(i);
                if (!retval.code.equals("3040") || retval.params.length == 0 || --loop != 0) continue;
                needs = true;
                break;
            }
        } else {
            needs = true;
        }
        return needs;
    }

    private String getContinueOffset(int loop) {
        String ret = null;
        int num = this.jobResult.getRetNumber();
        for (int i = 0; i < num; ++i) {
            HBCIRetVal retval = this.jobResult.getRetVal(i);
            if (!retval.code.equals("3040") || retval.params.length == 0 || --loop != 0) continue;
            ret = retval.params[0];
            break;
        }
        return ret;
    }

    public void fillJobResult(HBCIMsgStatus status, int offset) {
        block5: {
            try {
                this.executed = true;
                Properties result = status.getData();
                Hashtable<Integer, String> keyHeaders = new Hashtable<Integer, String>();
                Enumeration<Object> i = result.keys();
                while (i.hasMoreElements()) {
                    String segref;
                    String key = (String)i.nextElement();
                    if (!key.startsWith("GVRes") || !key.endsWith(".SegHead.ref") || Integer.parseInt(segref = result.getProperty(key)) - offset != this.idx) continue;
                    int resnum = 0;
                    if (key.startsWith("GVRes_")) {
                        resnum = Integer.parseInt(key.substring(key.indexOf(95) + 1, key.indexOf(46)));
                    }
                    keyHeaders.put(new Integer(resnum), key.substring(0, key.length() - ".SegHead.ref".length()));
                }
                this.saveBasicValues(result, this.idx + offset);
                this.saveReturnValues(status, this.idx + offset);
                Object[] resnums = keyHeaders.keySet().toArray(new Object[0]);
                Arrays.sort(resnums);
                for (int i2 = 0; i2 < resnums.length; ++i2) {
                    String header = (String)keyHeaders.get(resnums[i2]);
                    this.extractPlaintextResults(status, header, this.contentCounter);
                    this.extractResults(status, header, this.contentCounter++);
                }
            }
            catch (Exception e) {
                String msg = HBCIUtils.getLocMsg("EXCMSG_CANTSTORERES", this.getName());
                if (HBCIUtils.ignoreError(this.passport, "client.errors.ignoreJobResultStoreErrors", msg + ": " + HBCIUtils.exception2String(e))) break block5;
                throw new HBCI_Exception(msg, e);
            }
        }
    }

    private void saveBasicValues(Properties result, int ref) {
        if (this.jobResult.getDialogId() == null) {
            String msgheadName = "orig_" + result.getProperty("1");
            this.jobResult.storeResult("basic.dialogid", result.getProperty(msgheadName + ".dialogid"));
            this.jobResult.storeResult("basic.msgnum", result.getProperty(msgheadName + ".msgnum"));
            this.jobResult.storeResult("basic.segnum", Integer.toString(ref));
            HBCIUtils.log("basic values for " + this.getName() + " set to " + this.jobResult.getDialogId() + "/" + this.jobResult.getMsgNum() + "/" + this.jobResult.getSegNum(), 4);
        }
    }

    protected void saveReturnValues(HBCIMsgStatus status, int sref) {
        List<HBCIRetVal> retVals = status.segStatus.getRetVals();
        String segref = Integer.toString(sref);
        retVals.forEach(retVal -> {
            if (retVal.segref != null && retVal.segref.equals(segref)) {
                this.jobResult.jobStatus.addRetVal((HBCIRetVal)retVal);
            }
        });
        this.jobResult.globStatus = status.globStatus;
    }

    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
    }

    private void extractPlaintextResults(HBCIMsgStatus status, String header, int idx) {
        Properties result = status.getData();
        Enumeration<Object> e = result.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(header + ".")) continue;
            this.jobResult.storeResult(HBCIUtils.withCounter("content", idx) + "." + key.substring(header.length() + 1), result.getProperty(key));
        }
    }

    @Override
    public HBCIJobResult getJobResult() {
        return this.jobResult;
    }

    private void _checkAccountCRC(String frontendname, String blz, String number) {
        String old_number;
        String old_blz;
        if (blz == null || number == null) {
            return;
        }
        if (blz.length() == 0 || number.length() == 0) {
            return;
        }
        String orig_blz = blz;
        String orig_number = number;
        do {
            boolean crcok = HBCIUtils.checkAccountCRC(blz, number);
            old_blz = blz;
            old_number = number;
            if (crcok) continue;
            StringBuffer sb = new StringBuffer(blz).append("|").append(number);
            this.passport.getCallback().callback(19, HBCIUtils.getLocMsg("CALLB_HAVE_CRC_ERROR"), 2, sb);
            int idx = sb.indexOf("|");
            blz = sb.substring(0, idx);
            number = sb.substring(idx + 1);
        } while (!blz.equals(old_blz) || !number.equals(old_number));
        if (!blz.equals(orig_blz)) {
            this.setParam(frontendname + ".KIK.blz", blz);
        }
        if (!number.equals(orig_number)) {
            this.setParam(frontendname + ".number", number);
        }
    }

    private void _checkIBANCRC(String frontendname, String iban) {
        String old_iban;
        if (iban == null || iban.length() == 0) {
            return;
        }
        String orig_iban = iban;
        do {
            boolean crcok = HBCIUtils.checkIBANCRC(iban);
            old_iban = iban;
            if (crcok) continue;
            StringBuffer sb = new StringBuffer(iban);
            this.passport.getCallback().callback(30, HBCIUtils.getLocMsg("CALLB_HAVE_IBAN_ERROR"), 2, sb);
            iban = sb.toString();
        } while (!iban.equals(old_iban));
        if (!iban.equals(orig_iban)) {
            this.setParam(frontendname + ".iban", iban);
        }
    }

    protected void checkAccountCRC(String frontendname) {
        String[][] data2;
        String[][] data = this.constraints.get(frontendname + ".blz");
        if (data != null && data.length != 0) {
            String paramname = data[0][0];
            String lowlevelHeader = paramname.substring(0, paramname.lastIndexOf(".KIK.blz"));
            String blz = this.llParams.getProperty(lowlevelHeader + ".KIK.blz");
            String number = this.llParams.getProperty(lowlevelHeader + ".number");
            this._checkAccountCRC(frontendname, blz, number);
        }
        if ((data2 = this.constraints.get(frontendname + ".iban")) != null && data2.length != 0) {
            String paramname = data2[0][0];
            String lowlevelHeader = paramname.substring(0, paramname.lastIndexOf(".iban"));
            String iban = this.llParams.getProperty(lowlevelHeader + ".iban");
            this._checkIBANCRC(frontendname, iban);
        }
    }

    public String getChallengeParam(String path) {
        String result;
        if (path.equals("SegHead.code")) {
            result = this.getHBCICode();
        } else {
            String valuePath = this.getName() + "." + path;
            result = this.getLowlevelParam(valuePath);
        }
        return result;
    }

    public Konto getOrderAccount() {
        String prefix = this.getName() + ".My.";
        String number = this.getLowlevelParam(prefix + "number");
        String iban = this.getLowlevelParam(prefix + "iban");
        if (!(number != null && number.length() != 0 || iban != null && iban.length() != 0)) {
            prefix = this.getName() + ".KTV.";
            number = this.getLowlevelParam(prefix + "number");
            iban = this.getLowlevelParam(prefix + "iban");
            if (!(number != null && number.length() != 0 || iban != null && iban.length() != 0)) {
                return null;
            }
        }
        Konto k = new Konto();
        k.number = number;
        k.iban = iban;
        k.bic = this.getLowlevelParam(prefix + "bic");
        k.subnumber = this.getLowlevelParam(prefix + "subnumber");
        k.blz = this.getLowlevelParam(prefix + "KIK.blz");
        k.country = this.getLowlevelParam(prefix + "KIK.country");
        return k;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(String id) {
        this.externalId = id;
    }

    protected boolean twoDigitValueInList(String value, String list) {
        boolean found = false;
        int len = list.length();
        if ((len & 1) != 0) {
            throw new InvalidArgumentException("list must have 2*n digits");
        }
        if (value.length() != 2) {
            throw new InvalidArgumentException("value must have 2 digits");
        }
        for (int i = 0; i < len; i += 2) {
            String x = list.substring(i, i + 2);
            if (!value.equals(x)) continue;
            found = true;
            break;
        }
        return found;
    }

    private String insertIndex(String key, Integer index) {
        Matcher m;
        if (index != null && (m = INDEX_PATTERN.matcher(key)).matches()) {
            return m.group(1) + '[' + index + ']' + (m.group(2) != null ? m.group(2) : "");
        }
        return key;
    }
}

