/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.text.SimpleDateFormat;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRWPDepotUms;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.BigDecimalValue;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.TypedValue;
import org.kapott.hbci.swift.Swift;

public class GVWPDepotUms
extends HBCIJobImpl {
    private StringBuffer buffer = new StringBuffer();

    public static String getLowlevelName() {
        return "WPDepotUms";
    }

    public GVWPDepotUms(HBCIPassportInternal passport, MsgGen msgGen) {
        super(passport, msgGen, GVWPDepotUms.getLowlevelName(), new GVRWPDepotUms(passport));
        this.addConstraint("my.number", "Depot.number", null, 2);
        this.addConstraint("my.subnumber", "Depot.subnumber", "", 3);
        this.addConstraint("my.country", "Depot.KIK.country", passport.getUPD().getProperty("KInfo.KTV.KIK.country"), 0);
        this.addConstraint("my.blz", "Depot.KIK.blz", passport.getUPD().getProperty("KInfo.KTV.KIK.blz"), 3);
        this.addConstraint("quality", "quality", "", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
        this.addConstraint("startdate", "startdate", "", 0);
        this.addConstraint("enddate", "enddate", "", 0);
        this.addConstraint("dummy", "alldepots", "N", 0);
    }

    private TypedValue parseTypedValue(String st) {
        boolean neg;
        String st_type = st.substring(7, 11);
        String curr = "";
        boolean withCurr = false;
        int saldo_type = -1;
        if (st_type.equals("FAMT")) {
            saldo_type = 2;
        } else if (st_type.equals("ACTU")) {
            saldo_type = 2;
            withCurr = true;
        } else if (st_type.equals("UNIT")) {
            saldo_type = 1;
        } else if (st_type.equals("PRCT")) {
            saldo_type = 3;
        }
        int pos1 = 12;
        boolean bl = neg = st.charAt(pos1) == 'N';
        if (neg) {
            ++pos1;
        }
        if (withCurr) {
            curr = st.substring(pos1, pos1 + 3);
            pos1 += 3;
        }
        return new TypedValue((neg ? "-" : "") + st.substring(pos1).replace(',', '.'), curr, saldo_type);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        this.buffer.append(Swift.decodeUmlauts(result.getProperty(header + ".data536")));
        SimpleDateFormat date_time_format = new SimpleDateFormat("yyyyMMdd hhmmss");
        SimpleDateFormat date_only_format = new SimpleDateFormat("yyyyMMdd");
        while (this.buffer.length() != 0) {
            try {
                int i;
                String st_time;
                String st_date;
                GVRWPDepotUms.Entry entry;
                String onerecord;
                block70: {
                    onerecord = Swift.getOneBlock(this.buffer);
                    entry = new GVRWPDepotUms.Entry();
                    String st_timestamp = null;
                    st_date = null;
                    st_time = null;
                    int option = 67;
                    i = 0;
                    while (true) {
                        if ((st_timestamp = Swift.getTagValue(onerecord, "98" + (char)option, i++)) == null) {
                            if (option == 67) {
                                option = 65;
                                i = 0;
                                continue;
                            }
                            break block70;
                        }
                        if (st_timestamp.substring(1, 5).equals("PREP")) break;
                    }
                    st_date = st_timestamp.substring(7, 15);
                    if (option == 67) {
                        st_time = st_timestamp.substring(15, 21);
                    }
                }
                if (st_time != null) {
                    entry.timestamp = date_time_format.parse(st_date + " " + st_time);
                } else if (st_date != null) {
                    entry.timestamp = date_only_format.parse(st_date);
                }
                String st_depot = Swift.getTagValue(onerecord, "97A", 0);
                int pos1 = st_depot.indexOf("//");
                int pos2 = st_depot.indexOf("/", pos1 + 2);
                if (pos2 < 0) {
                    pos2 = st_depot.length();
                }
                entry.depot = new Konto();
                entry.depot.blz = st_depot.substring(pos1 + 2, pos2);
                if (pos2 < st_depot.length()) {
                    entry.depot.number = st_depot.substring(pos2 + 1);
                }
                this.passport.fillAccountInfo(entry.depot);
                i = 0;
                String st = Swift.getTagValue(onerecord, "17B", 0);
                if (st.substring(st.indexOf("//") + 2).equals("Y")) {
                    int fin_end;
                    int fin_start = onerecord.indexOf(":16R:FIN");
                    while ((fin_end = onerecord.indexOf(":16S:FIN", fin_start)) != -1) {
                        int trans_end;
                        String qualifier;
                        String oneinstrument = onerecord.substring(fin_start, fin_end + 8);
                        fin_start += oneinstrument.length();
                        GVRWPDepotUms.Entry.FinancialInstrument instrument = new GVRWPDepotUms.Entry.FinancialInstrument();
                        int trans_start = oneinstrument.indexOf(":16R:TRAN\r\n");
                        String oneinstrument_header = trans_start >= 0 ? oneinstrument.substring(0, trans_start + 9) : oneinstrument;
                        st = Swift.getTagValue(oneinstrument_header, "35B", 0);
                        boolean haveISIN = st.substring(0, 5).equals("ISIN ");
                        if (haveISIN) {
                            pos1 = st.indexOf("\r\n");
                            instrument.isin = st.substring(5, pos1);
                            if (pos1 + 2 < st.length() && st.substring(pos1 + 2, pos1 + 6).equals("/DE/")) {
                                pos2 = st.indexOf("\r\n", pos1 + 6);
                                if (pos2 == -1) {
                                    pos2 = st.length();
                                }
                                instrument.wkn = st.substring(pos1 + 6, pos2);
                                pos1 = pos2;
                            }
                        } else {
                            pos1 = st.indexOf("\r\n");
                            instrument.wkn = st.substring(4, pos1);
                        }
                        if ((pos1 += 2) < st.length()) {
                            instrument.name = st.substring(pos1);
                        }
                        if (instrument.name != null) {
                            int p;
                            StringBuffer sb = new StringBuffer(instrument.name);
                            while ((p = sb.indexOf("\r\n")) != -1) {
                                sb.replace(p, p + 2, " ");
                            }
                            instrument.name = sb.toString();
                        }
                        i = 0;
                        while ((st = Swift.getTagValue(oneinstrument_header, "93B", i++)) != null) {
                            qualifier = st.substring(1, 5);
                            if ("FIOP".equals(qualifier) || instrument.startSaldo == null && "INOP".equals(qualifier)) {
                                instrument.startSaldo = this.parseTypedValue(st);
                                continue;
                            }
                            if ("FICL".equals(qualifier) || instrument.endSaldo == null && "INCL".equals(qualifier)) {
                                instrument.endSaldo = this.parseTypedValue(st);
                                continue;
                            }
                            System.out.println("Unbekannter 93B: " + st);
                        }
                        i = 0;
                        while ((st = Swift.getTagValue(oneinstrument_header, "98A", i++)) != null) {
                            qualifier = st.substring(1, 5);
                            if ("PRIC".equals(qualifier)) {
                                instrument.preisdatum = date_only_format.parse(st.substring(7, 15));
                                continue;
                            }
                            System.out.println("Unbekannter 98A: " + st);
                        }
                        i = 0;
                        while ((st = Swift.getTagValue(oneinstrument_header, "90A", i++)) != null) {
                            instrument.preis = this.parseTypedValue(st);
                        }
                        i = 0;
                        while ((st = Swift.getTagValue(oneinstrument_header, "90B", i++)) != null) {
                            instrument.preis = this.parseTypedValue(st);
                        }
                        while (trans_start >= 0 && (trans_end = oneinstrument.indexOf(":16S:TRAN\r\n", trans_start)) >= 0) {
                            String oneparty;
                            String deag;
                            int party_end;
                            int party_start;
                            int detail_end;
                            int detail_start;
                            String onelink;
                            String rela;
                            int link_end;
                            String onetransaction = oneinstrument.substring(trans_start, trans_end + 9);
                            trans_start = trans_end + 9;
                            GVRWPDepotUms.Entry.FinancialInstrument.Transaction transaction = new GVRWPDepotUms.Entry.FinancialInstrument.Transaction();
                            int link_start = onetransaction.indexOf(":16R:LINK");
                            if (link_start >= 0 && (link_end = onetransaction.indexOf(":16S:LINK", link_start)) >= 0 && (rela = Swift.getTagValue(onelink = onetransaction.substring(link_start, link_end + 8), "20C", 0)) != null) {
                                transaction.kundenreferenz = rela.substring(7);
                            }
                            if ((detail_start = onetransaction.indexOf(":16R:TRANSDET")) >= 0 && (detail_end = onetransaction.indexOf(":16S:TRANSDET", detail_start)) >= 0) {
                                String freitext;
                                String t98a;
                                String t22h;
                                String t22f;
                                String t19a;
                                String t99a;
                                String onedetail = onetransaction.substring(detail_start, detail_end + 12);
                                String quantity = Swift.getTagValue(onedetail, "36B", 0);
                                if (quantity != null) {
                                    if (quantity.startsWith(":PSTA")) {
                                        transaction.anzahl = this.parseTypedValue(quantity);
                                    } else {
                                        System.out.println("Unbekannter 36B: " + quantity);
                                    }
                                }
                                if ((t99a = Swift.getTagValue(onedetail, "99A", 0)) != null) {
                                    if (t99a.startsWith(":DAAC")) {
                                        int neg = 0;
                                        if (t99a.charAt(7) == 'N') {
                                            neg = 1;
                                        }
                                        transaction.stueckzins_tage = Integer.parseInt(t99a.substring(7 + neg));
                                        if (neg != 0) {
                                            transaction.stueckzins_tage = -transaction.stueckzins_tage;
                                        }
                                    } else {
                                        System.out.println("Unbekannter 99A: " + t99a);
                                    }
                                }
                                int tagidx = 0;
                                while ((t19a = Swift.getTagValue(onedetail, "19A", tagidx++)) != null) {
                                    int off;
                                    if (t19a.startsWith(":PSTA")) {
                                        off = 7;
                                        if (t19a.charAt(off) == 'N') {
                                            ++off;
                                        }
                                        transaction.betrag = new BigDecimalValue(t19a.substring(off + 3).replace(',', '.'), t19a.substring(off, off + 3));
                                        if (off <= 7) continue;
                                        transaction.betrag.setValue(transaction.betrag.getValue().negate());
                                        continue;
                                    }
                                    if (t19a.startsWith(":ACRU")) {
                                        off = 7;
                                        if (t19a.charAt(off) == 'N') {
                                            ++off;
                                        }
                                        transaction.stueckzinsen = new BigDecimalValue(t19a.substring(off + 3).replace(',', '.'), t19a.substring(off, off + 3));
                                        if (off <= 7) continue;
                                        transaction.stueckzinsen.setValue(transaction.stueckzinsen.getValue().negate());
                                        continue;
                                    }
                                    System.out.println("Unbekannter 19A: " + t19a);
                                }
                                tagidx = 0;
                                while ((t22f = Swift.getTagValue(onedetail, "22F", tagidx++)) != null) {
                                    if (t22f.startsWith(":TRAN")) {
                                        if (t22f.endsWith("SETT")) {
                                            transaction.transaction_indicator = 1;
                                            continue;
                                        }
                                        if (t22f.endsWith("CORP")) {
                                            transaction.transaction_indicator = 2;
                                            continue;
                                        }
                                        if (t22f.endsWith("BOLE")) {
                                            transaction.transaction_indicator = 3;
                                            continue;
                                        }
                                        if (t22f.endsWith("COLL")) {
                                            transaction.transaction_indicator = 4;
                                            continue;
                                        }
                                        System.out.println("Unbekannter 22F->TRAN: " + t22f);
                                        transaction.transaction_indicator = -1;
                                        continue;
                                    }
                                    if (t22f.startsWith(":CCPT")) {
                                        if (t22f.endsWith("YCCP")) {
                                            transaction.ccp_eligibility = true;
                                            continue;
                                        }
                                        System.out.println("Unbekannter 22F->CCPT: " + t22f);
                                        continue;
                                    }
                                    System.out.println("Unbekannter 22F: " + t22f);
                                }
                                tagidx = 0;
                                while ((t22h = Swift.getTagValue(onedetail, "22H", tagidx++)) != null) {
                                    if (t22h.startsWith(":REDE")) {
                                        if (t22h.endsWith("DELI")) {
                                            transaction.richtung = 1;
                                            continue;
                                        }
                                        if (t22h.endsWith("RECE")) {
                                            transaction.richtung = 2;
                                            continue;
                                        }
                                        System.out.println("Unbekannter 22H->REDE: " + t22h);
                                        transaction.richtung = -1;
                                        continue;
                                    }
                                    if (t22h.startsWith(":PAYM")) {
                                        if (t22h.endsWith("APMT")) {
                                            transaction.bezahlung = 1;
                                            continue;
                                        }
                                        if (t22h.endsWith("FREE")) {
                                            transaction.bezahlung = 2;
                                            continue;
                                        }
                                        System.out.println("Unbekannter 22H->PAYM: " + t22h);
                                        transaction.bezahlung = -1;
                                        continue;
                                    }
                                    System.out.println("Unbekannter 22F: " + t22h);
                                }
                                tagidx = 0;
                                while ((t98a = Swift.getTagValue(onedetail, "98A", tagidx++)) != null) {
                                    String datum;
                                    if (t98a.startsWith(":ESET")) {
                                        datum = t98a.substring(7);
                                        transaction.datum = date_only_format.parse(datum);
                                        continue;
                                    }
                                    if (t98a.startsWith(":SETT")) {
                                        datum = t98a.substring(7);
                                        transaction.datum_valuta = date_only_format.parse(datum);
                                        continue;
                                    }
                                    System.out.println("Unbekannter 98A: " + t98a);
                                }
                                String move = Swift.getTagValue(onedetail, "25D", 0);
                                if (move != null) {
                                    if (move.startsWith(":MOVE")) {
                                        if (move.endsWith("REVE")) {
                                            transaction.storno = true;
                                        }
                                    } else {
                                        System.out.println("Unbekannter 25D: " + move);
                                    }
                                }
                                if ((freitext = Swift.getTagValue(onedetail, "70E", 0)) != null) {
                                    if (freitext.startsWith(":TRDE")) {
                                        transaction.freitext_details = freitext.substring(7);
                                    } else {
                                        System.out.println("Unbekannter 70E: " + freitext);
                                    }
                                }
                            }
                            if ((party_start = onetransaction.indexOf(":16R:SETPRTY")) >= 0 && (party_end = onetransaction.indexOf(":16S:SETPRTY", party_start)) >= 0 && (deag = Swift.getTagValue(oneparty = onetransaction.substring(party_start, party_end + 10), "95Q", 0)) != null) {
                                transaction.gegenpartei = deag.substring(7);
                            }
                            instrument.transactions.add(transaction);
                            trans_start = oneinstrument.indexOf(":16R:TRAN\r\n", trans_start);
                        }
                        entry.instruments.add(instrument);
                    }
                }
                ((GVRWPDepotUms)this.jobResult).addEntry(entry);
                this.buffer.delete(0, onerecord.length());
            }
            catch (Exception e) {
                throw new HBCI_Exception("*** error while extracting data", e);
            }
        }
        ((GVRWPDepotUms)this.jobResult).rest = this.buffer.toString();
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

