/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.text.SimpleDateFormat;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRWPDepotList;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.BigDecimalValue;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.swift.Swift;
import org.kapott.hbci.swift.SwiftLegacy;

public final class GVWPDepotList
extends HBCIJobImpl {
    private StringBuffer buffer = new StringBuffer();

    public static String getLowlevelName() {
        return "WPDepotList";
    }

    public GVWPDepotList(HBCIPassportInternal passport, MsgGen msgGen) {
        super(passport, msgGen, GVWPDepotList.getLowlevelName(), new GVRWPDepotList(passport));
        this.addConstraint("my.number", "Depot.number", null, 2);
        this.addConstraint("my.subnumber", "Depot.subnumber", "", 3);
        this.addConstraint("my.country", "Depot.KIK.country", passport.getUPD().getProperty("KInfo.KTV.KIK.country"), 0);
        this.addConstraint("my.blz", "Depot.KIK.blz", passport.getUPD().getProperty("KInfo.KTV.KIK.blz"), 3);
        this.addConstraint("quality", "quality", "", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        StringBuffer paramName = new StringBuffer(header).append(".data535");
        this.buffer.append(Swift.decodeUmlauts(result.getProperty(paramName.toString())));
        SimpleDateFormat date_time_format = new SimpleDateFormat("yyyyMMdd hhmmss");
        SimpleDateFormat date_only_format = new SimpleDateFormat("yyyyMMdd");
        while (this.buffer.length() != 0) {
            try {
                String st;
                int i;
                int option;
                String st_time;
                String st_date;
                String st_timestamp;
                GVRWPDepotList.Entry entry;
                String onerecord;
                block57: {
                    onerecord = Swift.getOneBlock(this.buffer);
                    entry = new GVRWPDepotList.Entry();
                    st_timestamp = null;
                    st_date = null;
                    st_time = null;
                    option = 67;
                    i = 0;
                    while (true) {
                        if ((st_timestamp = Swift.getTagValue(onerecord, "98" + (char)option, i++)) == null) {
                            if (option == 67) {
                                option = 65;
                                i = 0;
                                continue;
                            }
                            break block57;
                        }
                        if (st_timestamp.substring(1, 5).equals("STAT")) break;
                    }
                    st_date = st_timestamp.substring(7, 15);
                    if (option == 67) {
                        st_time = st_timestamp.substring(15, 21);
                    }
                }
                entry.timestamp = st_time != null ? date_time_format.parse(st_date + " " + st_time) : date_only_format.parse(st_date);
                String st_depot = Swift.getTagValue(onerecord, "97A", 0);
                int pos1 = st_depot.indexOf("//");
                int pos2 = st_depot.indexOf("/", pos1 + 2);
                entry.depot = new Konto();
                entry.depot.blz = st_depot.substring(pos1 + 2, pos2);
                entry.depot.number = st_depot.substring(pos2 + 1);
                this.passport.fillAccountInfo(entry.depot);
                i = 0;
                while ((st = Swift.getTagValue(onerecord, "19A", i++)) != null) {
                    if (!st.substring(1, 5).equals("HOLP")) continue;
                    pos1 = 7;
                    if (st.charAt(pos1) == 'N') {
                        ++pos1;
                    }
                    entry.total = new BigDecimalValue(st.substring(pos1 + 3).replace(',', '.'), st.substring(pos1, pos1 + 3));
                    if (pos1 <= 7) break;
                    entry.total.setValue(entry.total.getValue().negate());
                    break;
                }
                if ((st = Swift.getTagValue(onerecord, "17B", 0)).substring(st.indexOf("//") + 2).equals("Y")) {
                    int subpos = onerecord.indexOf(":16R:FIN");
                    while ((pos2 = onerecord.indexOf(":16S:FIN", subpos)) != -1) {
                        GVRWPDepotList.Entry.Gattung gattung;
                        String onegattung;
                        block58: {
                            onegattung = onerecord.substring(subpos, pos2 + 8);
                            subpos += onegattung.length();
                            gattung = new GVRWPDepotList.Entry.Gattung();
                            st = Swift.getTagValue(onegattung, "35B", 0);
                            boolean haveISIN = st.substring(0, 5).equals("ISIN ");
                            if (haveISIN) {
                                pos1 = st.indexOf("\r\n");
                                gattung.isin = st.substring(5, pos1);
                                if (pos1 + 2 < st.length() && st.substring(pos1 + 2, pos1 + 6).equals("/DE/")) {
                                    pos2 = st.indexOf("\r\n", pos1 + 6);
                                    if (pos2 == -1) {
                                        pos2 = st.length();
                                    }
                                    gattung.wkn = st.substring(pos1 + 6, pos2);
                                    pos1 = pos2;
                                }
                            } else {
                                pos1 = st.indexOf("\r\n");
                                gattung.wkn = st.substring(4, pos1);
                            }
                            if ((pos1 += 2) < st.length()) {
                                gattung.name = st.substring(pos1);
                            }
                            if (gattung.name != null) {
                                int p;
                                StringBuffer sb = new StringBuffer(gattung.name);
                                while ((p = sb.indexOf("\r\n")) != -1) {
                                    sb.replace(p, p + 2, " ");
                                }
                                gattung.name = sb.toString();
                            }
                            if ((st = SwiftLegacy.getTagValue(onegattung, "90", new String[]{"A", "B"}, 0)) != null) {
                                String curr;
                                gattung.pricequalifier = st.substring(1, 5).equals("MRKT") ? 1 : 2;
                                int next = 0;
                                if (st.substring(7, 11).equals("PRCT")) {
                                    gattung.pricetype = 1;
                                    curr = "%";
                                    next = 12;
                                } else {
                                    gattung.pricetype = 2;
                                    curr = st.substring(12, 15);
                                    next = 15;
                                }
                                gattung.price = new BigDecimalValue(st.substring(next).replace(',', '.'), curr);
                            }
                            if ((st = Swift.getTagValue(onegattung, "94B", 0)) != null) {
                                String st_source = st.substring(7, 11);
                                if (st_source.equals("LMAR")) {
                                    gattung.source = 1;
                                } else if (st_source.equals("THEO")) {
                                    gattung.source = 2;
                                } else if (st_source.equals("VEND")) {
                                    gattung.source = 3;
                                }
                                pos1 = st.indexOf("/", 11);
                                if (pos1 != -1) {
                                    gattung.source_comment = st.substring(pos1 + 1);
                                }
                            }
                            st_timestamp = null;
                            st_date = null;
                            st_time = null;
                            option = 67;
                            i = 0;
                            while (true) {
                                if ((st_timestamp = Swift.getTagValue(onegattung, "98" + (char)option, i++)) == null) {
                                    if (option == 67) {
                                        option = 65;
                                        i = 0;
                                        continue;
                                    }
                                    break block58;
                                }
                                if (st_timestamp.substring(1, 5).equals("PRIC")) break;
                            }
                            st_date = st_timestamp.substring(7, 15);
                            if (option == 67) {
                                st_time = st_timestamp.substring(15, 21);
                            }
                        }
                        if (st_date != null) {
                            gattung.timestamp_price = st_time != null ? date_time_format.parse(st_date + " " + st_time) : date_only_format.parse(st_date);
                        }
                        st = Swift.getTagValue(onegattung, "93B", 0);
                        String st_type = st.substring(7, 11);
                        String curr = "EUR";
                        if (st_type.equals("FAMT")) {
                            gattung.saldo_type = 2;
                            curr = "";
                        } else if (st_type.equals("UNIT")) {
                            gattung.saldo_type = 1;
                            curr = "";
                        }
                        pos1 = 12;
                        gattung.saldo = st.charAt(pos1) == 'N' ? new BigDecimalValue("-" + st.substring(pos1 + 1).replace(',', '.'), curr) : new BigDecimalValue(st.substring(pos1).replace(',', '.'), curr);
                        st = Swift.getTagValue(onegattung, "99A", 0);
                        if (st != null) {
                            gattung.days = st.charAt(7) == 'N' ? -1 * Integer.parseInt(st.substring(8)) : Integer.parseInt(st.substring(7));
                        }
                        i = 0;
                        while ((st = Swift.getTagValue(onegattung, "19A", i++)) != null) {
                            if (!st.substring(1, 5).equals("HOLD")) continue;
                            pos1 = 7;
                            if (st.charAt(pos1) == 'N') {
                                ++pos1;
                            }
                            gattung.depotwert = new BigDecimalValue(st.substring(pos1 + 3).replace(',', '.'), st.substring(pos1, pos1 + 3));
                            if (pos1 <= 7) break;
                            gattung.depotwert.setValue(gattung.depotwert.getValue().negate());
                            break;
                        }
                        i = 0;
                        while ((st = Swift.getTagValue(onegattung, "19A", i++)) != null) {
                            if (!st.substring(1, 5).equals("ACRU")) continue;
                            pos1 = 7;
                            if (st.charAt(pos1) == 'N') {
                                ++pos1;
                            }
                            gattung.stueckzinsbetrag = new BigDecimalValue(st.substring(pos1 + 3).replace(',', '.'), st.substring(pos1, pos1 + 3));
                            if (pos1 <= 7) break;
                            gattung.stueckzinsbetrag.setValue(gattung.stueckzinsbetrag.getValue().negate());
                            break;
                        }
                        if ((st = Swift.getTagValue(onegattung, "92B", 0)) != null) {
                            gattung.xchg_cur1 = st.substring(7, 10);
                            gattung.xchg_cur2 = st.substring(11, 14);
                            gattung.xchg_kurs = Double.parseDouble(st.substring(15).replace(',', '.'));
                        }
                        if ((st = Swift.getTagValue(onegattung, "70E", 0)) != null) {
                            String formtext = st.substring(7);
                            gattung.curr = SwiftLegacy.getLineFieldValue(formtext, "1", 0);
                            gattung.wptype = SwiftLegacy.getLineFieldValue(formtext, "1", 1);
                            gattung.branche = SwiftLegacy.getLineFieldValue(formtext, "1", 2);
                            gattung.countryEmittent = SwiftLegacy.getLineFieldValue(formtext, "1", 3);
                            st = SwiftLegacy.getLineFieldValue(formtext, "1", 4);
                            if (st != null) {
                                gattung.kauf = date_only_format.parse(st);
                            }
                            if ((st = SwiftLegacy.getLineFieldValue(formtext, "1", 5)) != null) {
                                gattung.faellig = date_only_format.parse(st);
                            }
                            if ((st = SwiftLegacy.getLineFieldValue(formtext, "2", 0)) != null) {
                                gattung.einstandspreis = new BigDecimalValue(st.replace(',', '.'), "%");
                            }
                            if ((st = SwiftLegacy.getLineFieldValue(formtext, "2", 1)) != null) {
                                gattung.einstandspreis.setCurr(st);
                            }
                            if ((st = SwiftLegacy.getLineFieldValue(formtext, "2", 2)) != null) {
                                gattung.zinssatz = HBCIUtils.string2Long(st.replace(',', '.'), 1000L);
                            }
                        }
                        int subsaldopos = onegattung.indexOf(":16R:SUBBAL");
                        while ((pos2 = onegattung.indexOf(":16S:SUBBAL", subsaldopos)) != -1) {
                            String formtext;
                            String onesubsaldo = onegattung.substring(subsaldopos, pos2 + 11);
                            subsaldopos += onesubsaldo.length();
                            GVRWPDepotList.Entry.Gattung.SubSaldo subsaldo = new GVRWPDepotList.Entry.Gattung.SubSaldo();
                            st = Swift.getTagValue(onesubsaldo, "93C", 0);
                            subsaldo.qualifier = st.substring(1, 5);
                            st_type = st.substring(7, 11);
                            curr = "EUR";
                            if (st_type.equals("FAMT")) {
                                subsaldo.saldo_type = 2;
                                curr = "";
                            } else if (st_type.equals("UNIT")) {
                                subsaldo.saldo_type = 1;
                                curr = "";
                            }
                            subsaldo.locked = st.substring(12, 16).equals("NAVL");
                            pos1 = 17;
                            subsaldo.saldo = st.charAt(pos1) == 'N' ? new BigDecimalValue("-" + st.substring(pos1 + 1).replace(',', '.'), curr) : new BigDecimalValue(st.substring(pos1).replace(',', '.'), curr);
                            st = Swift.getTagValue(onesubsaldo, "94C", 0);
                            if (st != null) {
                                subsaldo.country = st.substring(7);
                            }
                            if ((formtext = Swift.getTagValue(onesubsaldo, "70C", 0)) != null) {
                                st = SwiftLegacy.getLineFieldValue(formtext, "2", 0);
                                if (st != null) {
                                    subsaldo.verwahrung = Integer.parseInt(st);
                                }
                                subsaldo.lager = SwiftLegacy.getLineFieldValue(formtext, "2", 1);
                                st = SwiftLegacy.getLineFieldValue(formtext, "2", 2);
                                if (st != null) {
                                    subsaldo.lockeduntil = date_only_format.parse(st);
                                }
                                subsaldo.comment = SwiftLegacy.getLineFieldValue(formtext, "3", 0);
                                st = SwiftLegacy.getLineFieldValue(formtext, "4", 0);
                                if (st != null) {
                                    subsaldo.comment = subsaldo.comment == null ? st : subsaldo.comment + " " + st;
                                }
                            }
                            gattung.addSubSaldo(subsaldo);
                        }
                        entry.addEntry(gattung);
                    }
                }
                ((GVRWPDepotList)this.jobResult).addEntry(entry);
                this.buffer.delete(0, onerecord.length());
            }
            catch (Exception e) {
                throw new HBCI_Exception("*** error while extracting data", e);
            }
        }
        ((GVRWPDepotList)this.jobResult).rest = this.buffer.toString();
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

