/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Properties;
import org.kapott.hbci.GV.GVUeb;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;

public final class GVUebBZU
extends GVUeb {
    public static String getLowlevelName() {
        return "Ueb";
    }

    public GVUebBZU(HBCIPassportInternal passport, MsgGen msgGen) {
        super(passport, msgGen, GVUebBZU.getLowlevelName());
        this.addConstraint("src.country", "My.KIK.country", "DE", 0);
        this.addConstraint("src.blz", "My.KIK.blz", null, 3);
        this.addConstraint("src.number", "My.number", null, 2);
        this.addConstraint("src.subnumber", "My.subnumber", "", 3);
        this.addConstraint("dst.country", "Other.KIK.country", "DE", 0);
        this.addConstraint("dst.blz", "Other.KIK.blz", null, 3);
        this.addConstraint("dst.number", "Other.number", null, 2);
        this.addConstraint("dst.subnumber", "Other.subnumber", "", 3);
        this.addConstraint("btg.value", "BTG.value", null, 3);
        this.addConstraint("btg.curr", "BTG.curr", null, 0);
        this.addConstraint("name", "name", null, 2);
        this.addConstraint("bzudata", "usage.usage", null, 3);
        this.addConstraint("name2", "name2", "", 2);
        this.addConstraint("key", "key", "67", 0);
        Properties parameters = this.getJobRestrictions();
        int maxusage = Integer.parseInt(parameters.getProperty("maxusage"));
        for (int i = 1; i < maxusage; ++i) {
            String name = HBCIUtils.withCounter("usage", i);
            this.addConstraint(name, "usage." + name, "", 3);
        }
    }

    private void checkBZUData(String bzudata) {
        String msg;
        if (bzudata == null) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_BZUMISSING"));
        }
        int len = bzudata.length();
        if (len != 13) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_INV_BZULEN", Integer.toString(len)));
        }
        byte[] digits = bzudata.getBytes();
        int p = 10;
        int s = 0;
        for (int j = 1; j <= 13; ++j) {
            s = p % 11 + (digits[j - 1] - 48);
            int mod = s % 10;
            if (mod == 0) {
                mod = 10;
            }
            p = mod << 1;
        }
        if (s % 10 != 1 && !HBCIUtils.ignoreError(this.passport, "client.errors.ignoreWrongJobDataErrors", msg = HBCIUtils.getLocMsg("EXCMSG_BZUERR", bzudata))) {
            throw new InvalidUserDataException(msg);
        }
    }

    @Override
    public void setParam(String paramName, String value) {
        if (paramName.equals("bzudata")) {
            this.checkBZUData(value);
        }
        super.setParam(paramName, value);
    }
}

