/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.GV.parsers.SEPAParserFactory;
import org.kapott.hbci.GV_Result.GVRTermUebList;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.PainVersion;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public final class GVTermUebSEPAList
extends AbstractSEPAGV {
    private static final PainVersion DEFAULT = PainVersion.PAIN_001_001_02;

    @Override
    protected PainVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected PainVersion.Type getPainType() {
        return PainVersion.Type.PAIN_001;
    }

    public static String getLowlevelName() {
        return "TermUebSEPAList";
    }

    public GVTermUebSEPAList(HBCIPassportInternal passport, MsgGen msgGen) {
        super(passport, msgGen, GVTermUebSEPAList.getLowlevelName(), (HBCIJobResultImpl)new GVRTermUebList(passport));
        this.addConstraint("src.bic", "My.bic", null, 3);
        this.addConstraint("src.iban", "My.iban", null, 2);
        if (this.canNationalAcc(passport, msgGen)) {
            this.addConstraint("src.country", "My.KIK.country", "", 0);
            this.addConstraint("src.blz", "My.KIK.blz", "", 3);
            this.addConstraint("src.number", "My.number", "", 2);
            this.addConstraint("src.subnumber", "My.subnumber", "", 3);
        }
        this.addConstraint("_sepadescriptor", "sepadescr", this.getPainVersion().getURN(), 0);
        this.addConstraint("startdate", "startdate", "", 0);
        this.addConstraint("enddate", "enddate", "", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        GVRTermUebList.Entry entry = new GVRTermUebList.Entry();
        entry.my = new Konto();
        entry.my.country = result.getProperty(header + ".My.KIK.country");
        entry.my.blz = result.getProperty(header + ".My.KIK.blz");
        entry.my.number = result.getProperty(header + ".My.number");
        entry.my.subnumber = result.getProperty(header + ".My.subnumber");
        entry.my.iban = result.getProperty(header + ".My.iban");
        entry.my.bic = result.getProperty(header + ".My.bic");
        this.passport.fillAccountInfo(entry.my);
        entry.other = new Konto();
        String sepadescr = result.getProperty(header + ".sepadescr");
        String pain = result.getProperty(header + ".sepapain");
        PainVersion version = PainVersion.choose(sepadescr, pain);
        ISEPAParser parser = SEPAParserFactory.get(version);
        ArrayList<Properties> sepaResults = new ArrayList<Properties>();
        try {
            parser.parse(new ByteArrayInputStream(pain.getBytes("ISO-8859-1")), sepaResults);
        }
        catch (Exception e) {
            throw new HBCI_Exception("Error parsing SEPA pain document", e);
        }
        if (sepaResults.isEmpty()) {
            return;
        }
        Properties sepaResult = sepaResults.get(0);
        entry.other.iban = sepaResult.getProperty("dst.iban");
        entry.other.bic = sepaResult.getProperty("dst.bic");
        entry.other.name = sepaResult.getProperty("dst.name");
        entry.value = new Value(sepaResult.getProperty("value"), sepaResult.getProperty("curr"));
        entry.addUsage(sepaResult.getProperty("usage"));
        entry.orderid = result.getProperty(header + ".orderid");
        entry.date = HBCIUtils.string2DateISO(sepaResult.getProperty("date"));
        entry.can_change = result.getProperty(header + ".canchange") == null || result.getProperty(header + ".canchange").equals("J");
        entry.can_delete = result.getProperty(header + ".candel") == null || result.getProperty(header + ".candel").equals("J");
        ((GVRTermUebList)this.jobResult).addEntry(entry);
        if (entry.orderid != null && entry.orderid.length() != 0) {
            Properties p2 = new Properties();
            Enumeration<?> e = result.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(header + ".") || key.startsWith(header + ".SegHead.") || key.endsWith(".orderid")) continue;
                p2.setProperty(key.substring(header.length() + 1), result.getProperty(key));
            }
            this.passport.setPersistentData("termueb_" + entry.orderid, p2);
        }
    }

    @Override
    public String getPainJobName() {
        return "UebSEPA";
    }
}

