/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV_Result.GVRTermUeb;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.PainVersion;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVTermUebSEPA
extends AbstractSEPAGV {
    private static final PainVersion DEFAULT = PainVersion.PAIN_001_001_02;

    @Override
    protected PainVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected PainVersion.Type getPainType() {
        return PainVersion.Type.PAIN_001;
    }

    public static String getLowlevelName() {
        return "TermUebSEPA";
    }

    public GVTermUebSEPA(HBCIPassportInternal passport, MsgGen msgGen) {
        super(passport, msgGen, GVTermUebSEPA.getLowlevelName(), (HBCIJobResultImpl)new GVRTermUeb(passport));
        this.addConstraint("src.bic", "My.bic", null, 3);
        this.addConstraint("src.iban", "My.iban", null, 2);
        if (this.canNationalAcc(passport, msgGen)) {
            this.addConstraint("src.country", "My.KIK.country", "", 0);
            this.addConstraint("src.blz", "My.KIK.blz", "", 3);
            this.addConstraint("src.number", "My.number", "", 2);
            this.addConstraint("src.subnumber", "My.subnumber", "", 3);
        }
        this.addConstraint("_sepadescriptor", "sepadescr", this.getPainVersion().getURN(), 0);
        this.addConstraint("_sepapain", "sepapain", null, 2);
        this.addConstraint("src.bic", "sepa.src.bic", null, 3);
        this.addConstraint("src.iban", "sepa.src.iban", null, 2);
        this.addConstraint("src.name", "sepa.src.name", null, 2);
        this.addConstraint("dst.bic", "sepa.dst.bic", null, 3);
        this.addConstraint("dst.iban", "sepa.dst.iban", null, 2);
        this.addConstraint("dst.name", "sepa.dst.name", null, 2);
        this.addConstraint("btg.value", "sepa.btg.value", null, 0);
        this.addConstraint("btg.curr", "sepa.btg.curr", "EUR", 0);
        this.addConstraint("usage", "sepa.usage", "", 0);
        this.addConstraint("date", "sepa.date", null, 0);
        this.addConstraint("sepaid", "sepa.sepaid", this.getSEPAMessageId(), 0);
        this.addConstraint("pmtinfid", "sepa.pmtinfid", this.getSEPAMessageId(), 0);
        this.addConstraint("endtoendid", "sepa.endtoendid", "NOTPROVIDED", 0);
        this.addConstraint("purposecode", "sepa.purposecode", "", 0);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        String orderid = result.getProperty(header + ".orderid");
        ((GVRTermUeb)this.jobResult).setOrderId(orderid);
        if (orderid != null && orderid.length() != 0) {
            Properties p = this.getLowlevelParams();
            Properties p2 = new Properties();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                p2.setProperty(key.substring(key.indexOf(".") + 1), p.getProperty(key));
            }
            this.passport.setPersistentData("termueb_" + orderid, p2);
        }
    }

    @Override
    public String getPainJobName() {
        return "UebSEPA";
    }
}

