/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRTermUebEdit;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;

public final class GVTermUebEdit
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "TermUebEdit";
    }

    public GVTermUebEdit(HBCIPassportInternal passport, MsgGen msgGen) {
        super(passport, msgGen, GVTermUebEdit.getLowlevelName(), new GVRTermUebEdit(passport));
        this.addConstraint("src.country", "My.KIK.country", "DE", 0);
        this.addConstraint("src.blz", "My.KIK.blz", null, 3);
        this.addConstraint("src.number", "My.number", null, 2);
        this.addConstraint("src.subnumber", "My.subnumber", "", 3);
        this.addConstraint("dst.country", "Other.KIK.country", "DE", 0);
        this.addConstraint("dst.blz", "Other.KIK.blz", null, 3);
        this.addConstraint("dst.number", "Other.number", "", 2);
        this.addConstraint("dst.subnumber", "Other.subnumber", "", 3);
        this.addConstraint("btg.value", "BTG.value", null, 3);
        this.addConstraint("btg.curr", "BTG.curr", null, 0);
        this.addConstraint("name", "name", null, 2);
        this.addConstraint("date", "date", null, 0);
        this.addConstraint("orderid", "id", null, 0);
        this.addConstraint("name2", "name2", "", 2);
        this.addConstraint("key", "key", "51", 0);
        Properties parameters = this.getJobRestrictions();
        int maxusage = Integer.parseInt(parameters.getProperty("maxusage"));
        for (int i = 0; i < maxusage; ++i) {
            String name = HBCIUtils.withCounter("usage", i);
            this.addConstraint(name, "usage." + name, "", 3);
        }
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        String orderid = result.getProperty(header + ".orderid");
        ((GVRTermUebEdit)this.jobResult).setOrderId(orderid);
        ((GVRTermUebEdit)this.jobResult).setOrderIdOld(result.getProperty(header + ".orderidold"));
        if (orderid != null && orderid.length() != 0) {
            Properties p = this.getLowlevelParams();
            Properties p2 = new Properties();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.endsWith(".id")) continue;
                p2.setProperty(key.substring(key.indexOf(".") + 1), p.getProperty(key));
            }
            this.passport.setPersistentData("termueb_" + orderid, p2);
        }
    }

    @Override
    public void setParam(String paramName, String value) {
        super.setParam(paramName, value);
        if (paramName.equals("orderid")) {
            Properties p = (Properties)this.passport.getPersistentData("termueb_" + value);
            if (p == null) {
                String msg = HBCIUtils.getLocMsg("EXCMSG_NOSUCHSCHEDTRANS", value);
                if (!HBCIUtils.ignoreError(this.passport, "client.errors.ignoreWrongJobDataErrors", msg)) {
                    throw new InvalidUserDataException(msg);
                }
                p = new Properties();
            }
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String key2 = this.getName() + "." + key;
                if (this.getLowlevelParams().getProperty(key2) != null) continue;
                this.setLowlevelParam(key2, p.getProperty(key));
            }
        }
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("src");
        this.checkAccountCRC("dst");
    }
}

