/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRFestCondList;
import org.kapott.hbci.GV_Result.GVRFestList;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class GVFestList
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "FestList";
    }

    public GVFestList(String name, HBCIPassportInternal passport, MsgGen msgGen) {
        super(passport, msgGen, name, new GVRFestList(passport));
    }

    public GVFestList(HBCIPassportInternal passport, MsgGen msgGen) {
        this(GVFestList.getLowlevelName(), passport, msgGen);
        this.addConstraint("my.number", "KTV.number", null, 2);
        this.addConstraint("my.subnumber", "KTV.subnumber", "", 3);
        this.addConstraint("my.blz", "KTV.KIK.blz", null, 3);
        this.addConstraint("my.country", "KTV.KIK.country", "DE", 0);
        this.addConstraint("dummy", "allaccounts", "N", 0);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        GVRFestList.Entry entry = new GVRFestList.Entry();
        entry.anlagebetrag = new Value(result.getProperty(header + ".Anlagebetrag.value"), result.getProperty(header + ".Anlagebetrag.curr"));
        if (result.getProperty(header + ".Anlagekto.number") != null) {
            entry.anlagekonto = new Konto();
            entry.anlagekonto.blz = result.getProperty(header + ".Anlagekto.KIK.blz");
            entry.anlagekonto.country = result.getProperty(header + ".Anlagekto.KIK.country");
            entry.anlagekonto.number = result.getProperty(header + ".Anlagekto.number");
            entry.anlagekonto.subnumber = result.getProperty(header + ".Anlagekto.subnumber");
            this.passport.fillAccountInfo(entry.anlagekonto);
        }
        if (result.getProperty(header + ".Ausbuchungskto.number") != null) {
            entry.ausbuchungskonto = new Konto();
            entry.ausbuchungskonto.blz = result.getProperty(header + ".Ausbuchungskto.KIK.blz");
            entry.ausbuchungskonto.country = result.getProperty(header + ".Ausbuchungskto.KIK.country");
            entry.ausbuchungskonto.number = result.getProperty(header + ".Ausbuchungskto.number");
            entry.ausbuchungskonto.subnumber = result.getProperty(header + ".Ausbuchungskto.subnumber");
            this.passport.fillAccountInfo(entry.ausbuchungskonto);
        }
        entry.belastungskonto = new Konto();
        entry.belastungskonto.blz = result.getProperty(header + ".Belastungskto.KIK.blz");
        entry.belastungskonto.country = result.getProperty(header + ".Belastungskto.KIK.country");
        entry.belastungskonto.number = result.getProperty(header + ".Belastungskto.number");
        entry.belastungskonto.subnumber = result.getProperty(header + ".Belastungskto.subnumber");
        this.passport.fillAccountInfo(entry.belastungskonto);
        if (result.getProperty(header + ".Zinskto.number") != null) {
            entry.zinskonto = new Konto();
            entry.zinskonto.blz = result.getProperty(header + ".Zinskto.KIK.blz");
            entry.zinskonto.country = result.getProperty(header + ".Zinskto.KIK.country");
            entry.zinskonto.number = result.getProperty(header + ".Zinskto.number");
            entry.zinskonto.subnumber = result.getProperty(header + ".Zinskto.subnumber");
            this.passport.fillAccountInfo(entry.zinskonto);
        }
        entry.id = result.getProperty(header + ".kontakt");
        String st = result.getProperty(header + ".kontoauszug");
        entry.kontoauszug = st != null ? Integer.parseInt(st) : 0;
        st = result.getProperty(header + ".status");
        entry.status = st != null ? Integer.parseInt(st) : 0;
        entry.verlaengern = result.getProperty(header + ".wiederanlage").equals("2");
        if (result.getProperty(header + ".Zinsbetrag.value") != null) {
            entry.zinsbetrag = new Value(result.getProperty(header + ".Zinsbetrag.value"), result.getProperty(header + ".Zinsbetrag.curr"));
        }
        entry.konditionen = new GVRFestCondList.Cond();
        entry.konditionen.ablaufdatum = HBCIUtils.string2DateISO(result.getProperty(header + ".FestCond.ablaufdate"));
        entry.konditionen.anlagedatum = HBCIUtils.string2DateISO(result.getProperty(header + ".FestCond.anlagedate"));
        entry.konditionen.id = result.getProperty(header + ".FestCond.condid");
        entry.konditionen.name = result.getProperty(header + ".FestCond.condbez");
        if (result.getProperty(header + ".FestCondVersion.version") != null) {
            entry.konditionen.date = HBCIUtils.strings2DateTimeISO(result.getProperty(header + ".FestCondVersion.date"), result.getProperty(header + ".FestCondVersion.time"));
            entry.konditionen.version = result.getProperty(header + ".FestCondVersion.version");
        }
        if ((st = result.getProperty(header + ".FestCond.zinsmethode")).equals("A")) {
            entry.konditionen.zinsmethode = 0;
        } else if (st.equals("B")) {
            entry.konditionen.zinsmethode = 1;
        } else if (st.equals("C")) {
            entry.konditionen.zinsmethode = 2;
        } else if (st.equals("D")) {
            entry.konditionen.zinsmethode = 3;
        } else if (st.equals("E")) {
            entry.konditionen.zinsmethode = 4;
        } else if (st.equals("F")) {
            entry.konditionen.zinsmethode = 5;
        }
        entry.konditionen.zinssatz = HBCIUtils.string2Long(result.getProperty(header + ".FestCond.zinssatz"), 1000L);
        entry.konditionen.minbetrag = new Value(result.getProperty(header + ".FestCond.MinBetrag.value"), result.getProperty(header + ".FestCond.MinBetrag.curr"));
        entry.konditionen.name = result.getProperty(header + ".FestCond.condbez");
        if (result.getProperty(header + ".FestCond.MaxBetrag.value") != null) {
            entry.konditionen.maxbetrag = new Value(result.getProperty(header + ".FestCond.MaxBetrag.value"), result.getProperty(header + ".FestCond.MaxBetrag.curr"));
        }
        if (result.getProperty(header + ".Prolong.laufzeit") != null) {
            entry.verlaengerung = new GVRFestList.Entry.Prolong();
            entry.verlaengerung.betrag = new Value(result.getProperty(header + ".Prolong.BTG.value"), result.getProperty(header + ".Prolong.BTG.curr"));
            entry.verlaengerung.laufzeit = Integer.parseInt(result.getProperty(header + ".Prolong.laufzeit"));
            entry.verlaengerung.verlaengern = result.getProperty(header + ".Prolong.wiederanlage").equals("2");
        }
        ((GVRFestList)this.jobResult).addEntry(entry);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

