/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.Properties;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV_Result.GVRFestCondList;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Value;

public class GVFestCondList
extends HBCIJobImpl {
    public static String getLowlevelName() {
        return "FestCondList";
    }

    public GVFestCondList(HBCIPassportInternal passport, MsgGen msgGen) {
        super(passport, msgGen, GVFestCondList.getLowlevelName(), new GVRFestCondList(passport));
        this.addConstraint("curr", "curr", "EUR", 0);
        this.addConstraint("maxentries", "maxentries", "", 0);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        int i = 0;
        while (true) {
            GVRFestCondList.Cond entry = new GVRFestCondList.Cond();
            String condheader = HBCIUtils.withCounter(header + ".FestCond", i);
            if (result.getProperty(condheader + ".anlagedate") == null) break;
            entry.ablaufdatum = HBCIUtils.string2DateISO(result.getProperty(condheader + ".ablaufdate"));
            entry.anlagedatum = HBCIUtils.string2DateISO(result.getProperty(condheader + ".anlagedate"));
            entry.id = result.getProperty(condheader + ".condid");
            entry.name = result.getProperty(condheader + ".condbez");
            entry.date = HBCIUtils.strings2DateTimeISO(result.getProperty(header + ".FestCondVersion.date"), result.getProperty(header + ".FestCondVersion.time"));
            entry.version = result.getProperty(header + ".FestCondVersion.version");
            String st = result.getProperty(condheader + ".zinsmethode");
            if (st.equals("A")) {
                entry.zinsmethode = 0;
            } else if (st.equals("B")) {
                entry.zinsmethode = 1;
            } else if (st.equals("C")) {
                entry.zinsmethode = 2;
            } else if (st.equals("D")) {
                entry.zinsmethode = 3;
            } else if (st.equals("E")) {
                entry.zinsmethode = 4;
            } else if (st.equals("F")) {
                entry.zinsmethode = 5;
            }
            entry.zinssatz = HBCIUtils.string2Long(result.getProperty(condheader + ".zinssatz"), 1000L);
            entry.minbetrag = new Value(result.getProperty(condheader + ".MinBetrag.value"), result.getProperty(condheader + ".MinBetrag.curr"));
            entry.name = result.getProperty(condheader + ".condbez");
            if (result.getProperty(condheader + ".MaxBetrag.value") != null) {
                entry.maxbetrag = new Value(result.getProperty(condheader + ".MaxBetrag.value"), result.getProperty(condheader + ".MaxBetrag.curr"));
            }
            ((GVRFestCondList)this.jobResult).addEntry(entry);
            ++i;
        }
    }
}

