/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV_Result.GVRDauerEdit;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.PainVersion;
import org.kapott.hbci.status.HBCIMsgStatus;

public class GVDauerSEPAEdit
extends AbstractSEPAGV {
    private static final PainVersion DEFAULT = PainVersion.PAIN_001_001_02;

    @Override
    protected PainVersion getDefaultPainVersion() {
        return DEFAULT;
    }

    @Override
    protected PainVersion.Type getPainType() {
        return PainVersion.Type.PAIN_001;
    }

    public static String getLowlevelName() {
        return "DauerSEPAEdit";
    }

    public GVDauerSEPAEdit(HBCIPassportInternal passport, MsgGen msgGen) {
        super(passport, msgGen, GVDauerSEPAEdit.getLowlevelName(), (HBCIJobResultImpl)new GVRDauerEdit(passport));
        this.addConstraint("src.bic", "My.bic", null, 3);
        this.addConstraint("src.iban", "My.iban", null, 2);
        if (this.canNationalAcc(passport, msgGen)) {
            this.addConstraint("src.country", "My.KIK.country", "", 0);
            this.addConstraint("src.blz", "My.KIK.blz", "", 3);
            this.addConstraint("src.number", "My.number", "", 2);
            this.addConstraint("src.subnumber", "My.subnumber", "", 3);
        }
        this.addConstraint("_sepadescriptor", "sepadescr", this.getPainVersion().getURN(), 0);
        this.addConstraint("_sepapain", "sepapain", null, 2);
        this.addConstraint("orderid", "orderid", null, 0);
        this.addConstraint("src.bic", "sepa.src.bic", null, 3);
        this.addConstraint("src.iban", "sepa.src.iban", null, 2);
        this.addConstraint("src.name", "sepa.src.name", null, 2);
        this.addConstraint("dst.bic", "sepa.dst.bic", null, 3);
        this.addConstraint("dst.iban", "sepa.dst.iban", null, 2);
        this.addConstraint("dst.name", "sepa.dst.name", null, 2);
        this.addConstraint("btg.value", "sepa.btg.value", null, 0);
        this.addConstraint("btg.curr", "sepa.btg.curr", "EUR", 0);
        this.addConstraint("usage", "sepa.usage", "", 0);
        this.addConstraint("date", "date", "", 0);
        this.addConstraint("sepaid", "sepa.sepaid", this.getSEPAMessageId(), 0);
        this.addConstraint("pmtinfid", "sepa.pmtinfid", this.getSEPAMessageId(), 0);
        this.addConstraint("endtoendid", "sepa.endtoendid", "NOTPROVIDED", 0);
        this.addConstraint("purposecode", "sepa.purposecode", "", 0);
        this.addConstraint("firstdate", "DauerDetails.firstdate", null, 0);
        this.addConstraint("timeunit", "DauerDetails.timeunit", null, 0);
        this.addConstraint("turnus", "DauerDetails.turnus", null, 0);
        this.addConstraint("execday", "DauerDetails.execday", null, 0);
        this.addConstraint("lastdate", "DauerDetails.lastdate", "", 0);
    }

    @Override
    public void setParam(String paramName, String value) {
        String timeunit;
        Properties res = this.getJobRestrictions();
        if (paramName.equals("timeunit")) {
            String msg;
            if (!(value.equals("W") || value.equals("M") || HBCIUtils.ignoreError(this.passport, "client.errors.ignoreWrongJobDataErrors", msg = HBCIUtils.getLocMsg("EXCMSG_INV_TIMEUNIT", value)))) {
                throw new InvalidUserDataException(msg);
            }
        } else if (paramName.equals("turnus")) {
            String timeunit2 = this.getLowlevelParams().getProperty(this.getName() + ".DauerDetails.timeunit");
            if (timeunit2 != null) {
                String st;
                if (timeunit2.equals("W")) {
                    String st2 = res.getProperty("turnusweeks");
                    if (st2 != null) {
                        String msg;
                        String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                        if (!(st2.equals("00") || this.twoDigitValueInList(value2, st2) || HBCIUtils.ignoreError(this.passport, "client.errors.ignoreWrongJobDataErrors", msg = HBCIUtils.getLocMsg("EXCMSG_INV_TURNUS", value)))) {
                            throw new InvalidUserDataException(msg);
                        }
                    }
                } else if (timeunit2.equals("M") && (st = res.getProperty("turnusmonths")) != null) {
                    String msg;
                    String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                    if (!(st.equals("00") || this.twoDigitValueInList(value2, st) || HBCIUtils.ignoreError(this.passport, "client.errors.ignoreWrongJobDataErrors", msg = HBCIUtils.getLocMsg("EXCMSG_INV_TURNUS", value)))) {
                        throw new InvalidUserDataException(msg);
                    }
                }
            }
        } else if (paramName.equals("execday") && (timeunit = this.getLowlevelParams().getProperty(this.getName() + ".DauerDetails.timeunit")) != null) {
            String st;
            if (timeunit.equals("W")) {
                String msg;
                String st3 = res.getProperty("daysperweek");
                if (st3 != null && !st3.equals("0") && st3.indexOf(value) == -1 && !HBCIUtils.ignoreError(this.passport, "client.errors.ignoreWrongJobDataErrors", msg = HBCIUtils.getLocMsg("EXCMSG_INV_EXECDAY", value))) {
                    throw new InvalidUserDataException(msg);
                }
            } else if (timeunit.equals("M") && (st = res.getProperty("dayspermonth")) != null) {
                String msg;
                String value2 = new DecimalFormat("00").format(Integer.parseInt(value));
                if (!(st.equals("00") || this.twoDigitValueInList(value2, st) || HBCIUtils.ignoreError(this.passport, "client.errors.ignoreWrongJobDataErrors", msg = HBCIUtils.getLocMsg("EXCMSG_INV_EXECDAY", value)))) {
                    throw new InvalidUserDataException(msg);
                }
            }
        }
        super.setParam(paramName, value);
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        Properties result = msgstatus.getData();
        String orderid = result.getProperty(header + ".orderid");
        ((GVRDauerEdit)this.jobResult).setOrderId(orderid);
        ((GVRDauerEdit)this.jobResult).setOrderIdOld(result.getProperty(header + ".orderidold"));
        if (orderid != null && orderid.length() != 0) {
            Properties p = this.getLowlevelParams();
            Properties p2 = new Properties();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                p2.setProperty(key.substring(key.indexOf(".") + 1), p.getProperty(key));
            }
            this.passport.setPersistentData("dauer_" + orderid, p2);
        }
    }

    @Override
    public String getPainJobName() {
        return "UebSEPA";
    }
}

