/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.kapott.hbci.GV.GVSEPAInfo;
import org.kapott.hbci.GV.HBCIJobImpl;
import org.kapott.hbci.GV.generators.ISEPAGenerator;
import org.kapott.hbci.GV.generators.SEPAGeneratorFactory;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.MsgGen;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.PainVersion;

public abstract class AbstractSEPAGV
extends HBCIJobImpl {
    public static final String ENDTOEND_ID_NOTPROVIDED = "NOTPROVIDED";
    protected final Properties sepaParams = new Properties();
    private PainVersion pain = null;
    private ISEPAGenerator generator = null;

    protected abstract PainVersion getDefaultPainVersion();

    protected abstract PainVersion.Type getPainType();

    public AbstractSEPAGV(HBCIPassportInternal passport, MsgGen msgGen, String name) {
        super(passport, msgGen, name, new HBCIJobResultImpl(passport));
        this.pain = this.determinePainVersion(passport, msgGen, name);
    }

    public AbstractSEPAGV(HBCIPassportInternal passport, MsgGen msgGen, String name, HBCIJobResultImpl jobResult) {
        super(passport, msgGen, name, jobResult);
        this.pain = this.determinePainVersion(passport, msgGen, name);
    }

    protected boolean canNationalAcc(HBCIPassportInternal passport, MsgGen msgGen) {
        Object o = passport.getPersistentData("cannationalacc");
        if (o != null) {
            String s = o.toString();
            HBCIUtils.log("value of \"cannationalacc\" overwritten in passport, value: " + s, 3);
            return s.equalsIgnoreCase("J");
        }
        HBCIUtils.log("searching for value of \"cannationalacc\" in HISPAS", 4);
        if (passport.getSupportedLowlevelJobs(msgGen).getProperty("SEPAInfo") == null) {
            HBCIUtils.log("no HISPAS data found", 3);
            return false;
        }
        Properties props = passport.getLowlevelJobRestrictions("SEPAInfo", msgGen);
        String value = props.getProperty("cannationalacc");
        HBCIUtils.log("cannationalacc=" + value, 4);
        return value != null && value.equalsIgnoreCase("J");
    }

    private PainVersion determinePainVersion(HBCIPassportInternal passport, MsgGen msgGen, String gvName) {
        PainVersion globalVersion = this.determinePainVersionInternal(passport, msgGen, GVSEPAInfo.getLowlevelName());
        PainVersion jobVersion = this.determinePainVersionInternal(passport, msgGen, gvName);
        if (globalVersion == null && jobVersion == null) {
            PainVersion def = this.getDefaultPainVersion();
            HBCIUtils.log("unable to determine matching pain version, using default: " + def, 2);
            return def;
        }
        if (jobVersion == null) {
            HBCIUtils.log("have no job-specific pain version, using global pain version: " + globalVersion, 4);
            return globalVersion;
        }
        HBCIUtils.log("using job-specific pain version: " + jobVersion, 4);
        return jobVersion;
    }

    private PainVersion determinePainVersionInternal(HBCIPassportInternal passport, MsgGen msgGen, String gvName) {
        HBCIUtils.log("searching for supported pain versions for GV " + gvName, 4);
        if (passport.getSupportedLowlevelJobs(msgGen).getProperty(gvName) == null) {
            HBCIUtils.log("don't have any BPD for GV " + gvName, 4);
            return null;
        }
        ArrayList<PainVersion> found = new ArrayList<PainVersion>();
        Properties props = passport.getLowlevelJobRestrictions(gvName, msgGen);
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("suppformats")) continue;
            String urn = props.getProperty(key);
            try {
                PainVersion version = PainVersion.byURN(urn);
                if (version.getType() != this.getPainType()) continue;
                if (!version.isSupported(this.getPainJobName())) {
                    HBCIUtils.log("  unsupported " + version, 4);
                    continue;
                }
                HBCIUtils.log("  found " + version, 4);
                found.add(version);
            }
            catch (Exception ex) {
                HBCIUtils.log("ignoring invalid pain version " + urn, 2);
                HBCIUtils.log(ex);
            }
        }
        return PainVersion.findGreatest(found);
    }

    @Override
    protected void setLowlevelParam(String key, String value) {
        String intern = this.getName() + ".sepa.";
        if (key.startsWith(intern)) {
            String realKey = key.substring(intern.length());
            this.sepaParams.setProperty(realKey, value);
            HBCIUtils.log("setting SEPA param " + realKey + " = " + value, 4);
        } else {
            super.setLowlevelParam(key, value);
        }
    }

    @Override
    public String getLowlevelParam(String key) {
        String result;
        String intern = this.getName() + ".sepa.";
        if (key.startsWith(intern)) {
            String realKey = key.substring(intern.length());
            result = this.getSEPAParam(realKey);
        } else {
            result = super.getLowlevelParam(key);
        }
        return result;
    }

    public String getSEPAMessageId() {
        String result = this.getSEPAParam("messageId");
        if (result == null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSSS");
            result = format.format(new Date());
            result = result.substring(0, Math.min(result.length(), 35));
            this.setSEPAParam("messageId", result);
        }
        return result;
    }

    protected final ISEPAGenerator getSEPAGenerator() {
        block3: {
            if (this.generator == null) {
                try {
                    this.generator = SEPAGeneratorFactory.get(this, this.getPainVersion());
                }
                catch (Exception e) {
                    String msg = HBCIUtils.getLocMsg("EXCMSG_JOB_CREATE_ERR", this.getPainJobName());
                    if (HBCIUtils.ignoreError(null, "client.errors.ignoreCreateJobErrors", msg)) break block3;
                    throw new HBCI_Exception(msg, e);
                }
            }
        }
        return this.generator;
    }

    protected PainVersion getPainVersion() {
        return this.pain;
    }

    protected void createSEPAFromParams() {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        ISEPAGenerator gen = this.getSEPAGenerator();
        try {
            boolean validate = HBCIUtils.getParam("sepa.schema.validation", "0").equals("1");
            HBCIUtils.log("schema validation enabled: " + validate, 4);
            gen.generate(this.sepaParams, o, validate);
        }
        catch (HBCI_Exception he) {
            throw he;
        }
        catch (Exception e) {
            throw new HBCI_Exception("*** the _sepapain segment for this job can not be created", e);
        }
        if (o.size() == 0) {
            throw new HBCI_Exception("*** the _sepapain segment for this job can not be created");
        }
        try {
            String xml = o.toString("ISO-8859-1");
            HBCIUtils.log("generated XML:\n" + xml, 4);
            this.setParam("_sepapain", "B" + xml);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void addConstraint(String frontendName, String destinationName, String defValue, int logFilterLevel, boolean indexed) {
        super.addConstraint(frontendName, destinationName, defValue, logFilterLevel, indexed);
        if (destinationName.startsWith("sepa.") && defValue != null) {
            this.sepaParams.put(frontendName, defValue);
        }
    }

    @Override
    public void verifyConstraints() {
        if (this.acceptsParam("_sepapain")) {
            this.createSEPAFromParams();
        }
        super.verifyConstraints();
    }

    protected void setSEPAParam(String name, String value) {
        this.sepaParams.setProperty(name, value);
    }

    public String getSEPAParam(String name) {
        return this.sepaParams.getProperty(name);
    }

    public String getPainJobName() {
        return this.getJobName();
    }
}

