/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.swift;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.kapott.hbci.datatypes.SyntaxDTAUS;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.exceptions.InvalidArgumentException;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.LogFilter;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class DTAUS {
    public static final int TYPE_CREDIT = 1;
    public static final int TYPE_DEBIT = 2;
    public static final byte CURR_DM = 32;
    public static final byte CURR_EUR = 49;
    private static final byte ALIGN_LEFT = 1;
    private static final byte ALIGN_RIGHT = 2;
    private Konto myAccount;
    private int type;
    private Date execdate;
    private byte curr;
    private String referenceId;
    private ArrayList<Transaction> entries;
    private long sumDM;
    private long sumEUR;
    private long sumBLZ;
    private long sumNumber;

    public DTAUS(Konto myAccount, int type) {
        this(myAccount, type, null);
    }

    public DTAUS(Konto myAccount, int type, Date execdate) {
        LogFilter.getInstance().addSecretData(myAccount.blz, "X", 3);
        LogFilter.getInstance().addSecretData(myAccount.customerid, "X", 2);
        LogFilter.getInstance().addSecretData(myAccount.name, "X", 2);
        LogFilter.getInstance().addSecretData(myAccount.name2, "X", 2);
        LogFilter.getInstance().addSecretData(myAccount.number, "X", 2);
        LogFilter.getInstance().addSecretData(myAccount.subnumber, "X", 3);
        this.myAccount = myAccount;
        this.type = type;
        this.execdate = execdate;
        this.entries = new ArrayList();
        if (myAccount.curr.equals("EUR")) {
            this.curr = (byte)49;
        } else if (myAccount.curr.equals("DEM")) {
            this.curr = (byte)32;
        } else {
            throw new InvalidUserDataException("*** invalid currency of this account: " + myAccount.curr);
        }
    }

    public DTAUS(String dtaus) {
        this.entries = new ArrayList();
        this.parseDTAUS(dtaus);
    }

    public void addEntry(Transaction entry) {
        this.entries.add(entry);
    }

    public byte getCurr() {
        return this.curr;
    }

    public ArrayList<Transaction> getEntries() {
        return this.entries;
    }

    public Date getExecdate() {
        return this.execdate;
    }

    public Konto getMyAccount() {
        return this.myAccount;
    }

    public int getType() {
        return this.type;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getReferenceId() {
        return this.referenceId != null ? this.referenceId : "";
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        this.sumBLZ = 0L;
        this.sumNumber = 0L;
        this.sumDM = 0L;
        this.sumEUR = 0L;
        ret.append("0128A");
        switch (this.type) {
            case 1: {
                ret.append("GK");
                break;
            }
            case 2: {
                ret.append("LK");
                break;
            }
            default: {
                throw new InvalidUserDataException("*** type of DTAUS order not set (DEBIT/CREDIT)");
            }
        }
        ret.append(this.expand(this.myAccount.blz, 8, (byte)32, 2));
        ret.append(this.expand("", 8, (byte)48, 1));
        ret.append(this.expand(SyntaxDTAUS.check(this.myAccount.name), 27, (byte)32, 1));
        SimpleDateFormat form = new SimpleDateFormat("ddMMyy");
        ret.append(form.format(new Date()));
        ret.append(this.expand("", 4, (byte)32, 1));
        ret.append(this.expand(this.myAccount.number, 10, (byte)48, 2));
        ret.append(this.expand(this.getReferenceId(), 10, (byte)48, 2));
        ret.append(this.expand("", 15, (byte)32, 1));
        if (this.execdate == null) {
            ret.append(this.expand("", 8, (byte)32, 1));
        } else {
            form = new SimpleDateFormat("ddMMyyyy");
            ret.append(form.format(this.execdate));
        }
        ret.append(this.expand("", 24, (byte)32, 1));
        ret.append((char)this.curr);
        for (Transaction entry : this.entries) {
            ret.append(entry.toString());
        }
        ret.append("0128E");
        ret.append(this.expand("", 5, (byte)32, 1));
        ret.append(this.expand(Integer.toString(this.entries.size()), 7, (byte)48, 2));
        ret.append(this.expand(Long.toString(this.curr == 32 ? this.sumDM : 0L), 13, (byte)48, 2));
        ret.append(this.expand(Long.toString(this.sumNumber), 17, (byte)48, 2));
        ret.append(this.expand(Long.toString(this.sumBLZ), 17, (byte)48, 2));
        ret.append(this.expand(Long.toString(this.curr == 49 ? this.sumEUR : 0L), 13, (byte)48, 2));
        ret.append(this.expand("", 51, (byte)32, 1));
        return ret.toString();
    }

    private String expand(String st, int len, byte filler, int align) {
        if (st.length() < len) {
            try {
                byte[] fill = new byte[len - st.length()];
                Arrays.fill(fill, filler);
                String fillst = new String(fill, "ISO-8859-1");
                if (align == 1) {
                    st = st + fillst;
                }
                if (align == 2) {
                    st = fillst + st;
                }
                throw new HBCI_Exception("*** invalid align type: " + align);
            }
            catch (Exception e) {
                throw new HBCI_Exception(e);
            }
        } else if (st.length() > len) {
            throw new InvalidArgumentException("*** string too long: \"" + st + "\" has " + st.length() + " chars, but max is " + len);
        }
        return st;
    }

    private void parseDTAUS(String dtaus) {
        int x;
        HBCIUtils.log("parsing DTAUS data", 4);
        String header = dtaus.substring(0, 5);
        if (!header.equals("0128A")) {
            throw new HBCI_Exception("*** DTAUS stream does not start with '0128A'");
        }
        char typ = dtaus.charAt(5);
        if (typ == 'G') {
            this.type = 1;
        } else if (typ == 'L') {
            this.type = 2;
        } else {
            throw new HBCI_Exception("*** Invalid type: " + typ);
        }
        this.setReferenceId(dtaus.substring(70, 80).trim());
        String myBLZ = dtaus.substring(7, 15).trim();
        String myName = dtaus.substring(23, 50).trim();
        String myNumber = dtaus.substring(60, 70).trim();
        try {
            SimpleDateFormat format = new SimpleDateFormat("ddMMyyyy");
            this.execdate = format.parse(dtaus.substring(95, 103).trim());
        }
        catch (ParseException e) {
            this.execdate = null;
        }
        this.curr = (byte)dtaus.charAt(127);
        if (this.curr != 32 && this.curr != 49) {
            throw new HBCI_Exception("*** Invalid currency: " + this.curr);
        }
        this.myAccount = new Konto("DE", myBLZ, myNumber);
        this.myAccount.curr = this.curr == 49 ? "EUR" : "DEM";
        this.myAccount.name = myName;
        int posi = 128;
        while (true) {
            Transaction entry = new Transaction();
            if (dtaus.charAt(posi + 4) != 'C') break;
            int setCLen = Integer.parseInt(dtaus.substring(posi, posi + 4));
            posi += 4;
            HBCIUtils.log("SetCLen = " + setCLen + " data bytes (--> " + (double)(setCLen - 187) / 29.0 + " extensions)", 4);
            ++posi;
            String otherBLZ = dtaus.substring(posi += 8, posi + 8).trim();
            String otherNumber = dtaus.substring(posi += 8, posi + 10).trim();
            entry.internalCustomerId = dtaus.substring((posi += 10) + 1, posi + 1 + 11).trim();
            entry.key = dtaus.substring(posi += 13, posi + 2).trim();
            entry.addkey = dtaus.substring(posi += 2, posi + 3).trim();
            posi += 3;
            String value_st = null;
            value_st = this.curr == 49 ? dtaus.substring(posi + 29, posi + 29 + 11).trim() : dtaus.substring(++posi, posi + 11).trim();
            posi += 40;
            String otherName = dtaus.substring(posi += 3, posi + 27).trim();
            posi += 27;
            posi += 8;
            entry.addUsage(dtaus.substring(posi += 27, posi + 27).trim());
            posi += 27;
            ++posi;
            int nofExtensions = Integer.parseInt(dtaus.substring(posi += 2, posi + 2));
            posi += 2;
            HBCIUtils.log("field 'nofExtensions' = " + nofExtensions, 4);
            String otherName2 = null;
            for (int i = 0; i < nofExtensions; ++i) {
                if (posi % 128 + 29 > 128) {
                    posi = (posi / 128 + 1) * 128;
                }
                String code = dtaus.substring(posi, posi + 2).trim();
                String data = dtaus.substring(posi += 2, posi + 27).trim();
                posi += 27;
                if (code.equals("01")) {
                    otherName2 = data;
                    continue;
                }
                if (code.equals("02")) {
                    entry.addUsage(data);
                    continue;
                }
                if (!code.equals("03")) continue;
                this.myAccount.name2 = data;
            }
            posi = (posi / 128 + 1) * 128;
            (entry.otherAccount = new Konto((String)"DE", (String)otherBLZ, (String)otherNumber)).curr = this.curr == 49 ? "EUR" : "DEM";
            entry.otherAccount.name = otherName;
            entry.otherAccount.name2 = otherName2;
            entry.value = new Value(Long.parseLong(value_st), this.curr == 49 ? "EUR" : "DEM");
            this.addEntry(entry);
        }
        if (!dtaus.substring(posi, posi + 5).equals("0128E")) {
            throw new HBCI_Exception("*** e-set does not start with 0128E");
        }
        posi += 5;
        if ((x = Integer.parseInt(dtaus.substring(posi += 5, posi + 7))) != this.entries.size()) {
            throw new HBCI_Exception("*** there were " + this.entries.size() + " c-sets, but e-set says " + x);
        }
        HBCIUtils.log("parsinng of DTAUS data finished", 4);
    }

    public class Transaction {
        public Konto otherAccount;
        public String internalCustomerId;
        public String key;
        public String addkey = "000";
        public Value value;
        private ArrayList<String> usage;

        public Transaction() {
            this.key = DTAUS.this.type == 1 ? "51" : "05";
            this.usage = new ArrayList();
        }

        public void addUsage(String st) {
            LogFilter.getInstance().addSecretData(st, "X", 3);
            this.usage.add(st);
        }

        public List<String> getUsage() {
            return this.usage;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            try {
                int basicLenOfCSet;
                ret.append("0000C");
                ret.append(DTAUS.this.expand(((DTAUS)DTAUS.this).myAccount.blz, 8, (byte)32, 2));
                ret.append(DTAUS.this.expand(this.otherAccount.blz, 8, (byte)32, 2));
                ret.append(DTAUS.this.expand(this.otherAccount.number, 10, (byte)48, 2));
                DTAUS.this.sumBLZ = DTAUS.this.sumBLZ + Long.parseLong(this.otherAccount.blz);
                DTAUS.this.sumNumber = DTAUS.this.sumNumber + Long.parseLong(this.otherAccount.number);
                if (this.internalCustomerId == null) {
                    ret.append(DTAUS.this.expand("", 13, (byte)48, 1));
                } else {
                    ret.append('\u0000');
                    ret.append(DTAUS.this.expand(SyntaxDTAUS.check(this.internalCustomerId), 11, (byte)48, 1));
                    ret.append('\u0000');
                }
                ret.append(DTAUS.this.expand(this.key, 2, (byte)48, 2));
                ret.append(DTAUS.this.expand(this.addkey, 3, (byte)48, 2));
                ret.append(' ');
                ret.append(DTAUS.this.expand(Long.toString(this.value.getCurr().equals("DEM") ? this.value.getLongValue() : 0L), 11, (byte)48, 2));
                ret.append(DTAUS.this.expand(((DTAUS)DTAUS.this).myAccount.blz, 8, (byte)32, 2));
                ret.append(DTAUS.this.expand(((DTAUS)DTAUS.this).myAccount.number, 10, (byte)48, 2));
                ret.append(DTAUS.this.expand(Long.toString(this.value.getCurr().equals("EUR") ? this.value.getLongValue() : 0L), 11, (byte)48, 2));
                ret.append(DTAUS.this.expand("", 3, (byte)32, 1));
                ret.append(DTAUS.this.expand(SyntaxDTAUS.check(this.otherAccount.name), 27, (byte)32, 1));
                ret.append(DTAUS.this.expand("", 8, (byte)32, 1));
                if (this.value.getCurr().equals("EUR")) {
                    DTAUS.this.sumEUR = DTAUS.this.sumEUR + this.value.getLongValue();
                } else if (this.value.getCurr().equals("DEM")) {
                    DTAUS.this.sumDM = DTAUS.this.sumDM + this.value.getLongValue();
                }
                ret.append(DTAUS.this.expand(SyntaxDTAUS.check(((DTAUS)DTAUS.this).myAccount.name), 27, (byte)32, 1));
                String st = "";
                if (this.usage.size() != 0) {
                    st = SyntaxDTAUS.check(this.usage.get(0));
                }
                ret.append(DTAUS.this.expand(st, 27, (byte)32, 1));
                ret.append((char)DTAUS.this.curr);
                ret.append(DTAUS.this.expand("", 2, (byte)32, 1));
                int posForNumOfExt = ret.length();
                ret.append("00");
                int realLenOfCSet = basicLenOfCSet = 187;
                int numOfExt = 0;
                for (int i = 1; i < this.usage.size(); ++i) {
                    st = SyntaxDTAUS.check(this.usage.get(i));
                    if (realLenOfCSet % 128 + 29 > 128) {
                        int diff = 128 - realLenOfCSet % 128;
                        ret.append(DTAUS.this.expand("", diff, (byte)32, 1));
                        realLenOfCSet += diff;
                    }
                    ret.append("02");
                    ret.append(DTAUS.this.expand(st, 27, (byte)32, 1));
                    realLenOfCSet += 29;
                    ++numOfExt;
                }
                if (realLenOfCSet % 128 != 0) {
                    int diff = 128 - realLenOfCSet % 128;
                    ret.append(DTAUS.this.expand("", diff, (byte)32, 1));
                    realLenOfCSet += diff;
                }
                ret.replace(posForNumOfExt, posForNumOfExt + 2, DTAUS.this.expand(Integer.toString(numOfExt), 2, (byte)48, 2));
                ret.replace(0, 4, DTAUS.this.expand(Integer.toString(basicLenOfCSet + 29 * numOfExt), 4, (byte)48, 2));
            }
            catch (NullPointerException e) {
                throw new HBCI_Exception("probably one or more DTAUS values which MUST be set are null - please refer the API doc", e);
            }
            return ret.toString();
        }
    }
}

