/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.status;

import java.util.Map;
import java.util.Properties;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIRetVal;
import org.kapott.hbci.status.HBCIStatus;

public final class HBCIMsgStatus {
    public HBCIStatus globStatus = new HBCIStatus();
    public HBCIStatus segStatus = new HBCIStatus();
    private Properties data = new Properties();

    public void addException(Exception e) {
        this.globStatus.addException(e);
    }

    public void setData(Properties data) {
        this.data = data;
        this.extractStatusData();
    }

    public void addData(Properties _data) {
        this.data.putAll((Map<?, ?>)_data);
        this.extractStatusData();
    }

    private void extractStatusData() {
        String segheader;
        String segref;
        this.globStatus = new HBCIStatus();
        this.segStatus = new HBCIStatus();
        int i = 0;
        while (true) {
            HBCIRetVal rv = null;
            try {
                rv = new HBCIRetVal(this.data, HBCIUtils.withCounter("RetGlob.RetVal", i));
            }
            catch (Exception e) {
                break;
            }
            this.globStatus.addRetVal(rv);
            ++i;
        }
        i = 0;
        while ((segref = this.data.getProperty((segheader = HBCIUtils.withCounter("RetSeg", i)) + ".SegHead.ref")) != null) {
            int j = 0;
            while (true) {
                HBCIRetVal rv = null;
                try {
                    rv = new HBCIRetVal(this.data, HBCIUtils.withCounter(segheader + ".RetVal", j), segref);
                }
                catch (Exception e) {
                    break;
                }
                this.segStatus.addRetVal(rv);
                ++j;
            }
            ++i;
        }
    }

    public Properties getData() {
        return this.data;
    }

    public boolean hasExceptions() {
        return this.globStatus.hasExceptions();
    }

    public Exception[] getExceptions() {
        return this.globStatus.getExceptions();
    }

    public boolean isOK() {
        return this.globStatus.getStatusCode() == 0;
    }

    public String getErrorString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.globStatus.getErrorString());
        ret.append(System.getProperty("line.separator"));
        ret.append(this.segStatus.getErrorString());
        return ret.toString().trim();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.globStatus.toString());
        ret.append(System.getProperty("line.separator"));
        ret.append(this.segStatus.toString());
        return ret.toString().trim();
    }

    public boolean isInvalidPIN() {
        for (HBCIRetVal hbciRetVal : this.globStatus.getErrors()) {
            if (!hbciRetVal.code.equals("9931") && !hbciRetVal.code.equals("9942") && !hbciRetVal.code.equals("9340")) continue;
            return true;
        }
        for (HBCIRetVal hbciRetVal : this.segStatus.getErrors()) {
            if (!hbciRetVal.code.equals("9931") && !hbciRetVal.code.equals("9942") && !hbciRetVal.code.equals("9340")) continue;
            return true;
        }
        return false;
    }

    public boolean isDialogClosed() {
        for (HBCIRetVal hbciRetVal : this.globStatus.getErrors()) {
            if (!hbciRetVal.code.equals("9800")) continue;
            return true;
        }
        for (HBCIRetVal hbciRetVal : this.segStatus.getErrors()) {
            if (!hbciRetVal.code.equals("9800")) continue;
            return true;
        }
        return false;
    }
}

