/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.sepa;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.kapott.hbci.GV.generators.ISEPAGenerator;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.manager.HBCIUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PainVersion
implements Comparable<PainVersion> {
    private static final String DF_MAJOR = "000";
    private static final String DF_MINOR = "00";
    private static final Pattern PATTERN = Pattern.compile("(\\d\\d\\d)\\.(\\d\\d\\d)\\.(\\d\\d)");
    public static PainVersion PAIN_001_001_02 = new PainVersion(1, "urn:sepade:xsd:pain.001.001.02", "pain.001.001.02.xsd");
    public static PainVersion PAIN_001_002_02 = new PainVersion(2, "urn:swift:xsd:$pain.001.002.02", "pain.001.002.02.xsd");
    public static PainVersion PAIN_001_002_03 = new PainVersion(3, "urn:iso:std:iso:20022:tech:xsd:pain.001.002.03", "pain.001.002.03.xsd");
    public static PainVersion PAIN_001_003_03 = new PainVersion(4, "urn:iso:std:iso:20022:tech:xsd:pain.001.003.03", "pain.001.003.03.xsd");
    public static PainVersion PAIN_001_001_03 = new PainVersion(5, "urn:iso:std:iso:20022:tech:xsd:pain.001.001.03", "pain.001.001.03.xsd");
    public static PainVersion PAIN_002_002_02 = new PainVersion(1, "urn:swift:xsd:$pain.002.002.02", "pain.002.002.02.xsd");
    public static PainVersion PAIN_002_003_03 = new PainVersion(2, "urn:iso:std:iso:20022:tech:xsd:pain.002.003.03", "pain.002.003.03.xsd");
    public static PainVersion PAIN_002_001_03 = new PainVersion(3, "urn:iso:std:iso:20022:tech:xsd:pain.002.001.03", "pain.002.001.03.xsd");
    public static PainVersion PAIN_008_001_01 = new PainVersion(1, "urn:sepade:xsd:pain.008.001.01", "pain.008.001.01.xsd");
    public static PainVersion PAIN_008_002_01 = new PainVersion(2, "urn:swift:xsd:$pain.008.002.01", "pain.008.002.01.xsd");
    public static PainVersion PAIN_008_002_02 = new PainVersion(3, "urn:iso:std:iso:20022:tech:xsd:pain.008.002.02", "pain.008.002.02.xsd");
    public static PainVersion PAIN_008_003_02 = new PainVersion(4, "urn:iso:std:iso:20022:tech:xsd:pain.008.003.02", "pain.008.003.02.xsd");
    public static PainVersion PAIN_008_001_02 = new PainVersion(5, "urn:iso:std:iso:20022:tech:xsd:pain.008.001.02", "pain.008.001.02.xsd");
    private static final Map<Type, List<PainVersion>> knownVersion = new HashMap<Type, List<PainVersion>>(){
        {
            this.put(Type.PAIN_001, Collections.unmodifiableList(Arrays.asList(PAIN_001_001_02, PAIN_001_002_02, PAIN_001_002_03, PAIN_001_003_03, PAIN_001_001_03)));
            this.put(Type.PAIN_002, Collections.unmodifiableList(Arrays.asList(PAIN_002_002_02, PAIN_002_003_03, PAIN_002_001_03)));
            this.put(Type.PAIN_008, Collections.unmodifiableList(Arrays.asList(PAIN_008_001_01, PAIN_008_002_01, PAIN_008_002_02, PAIN_008_003_02, PAIN_008_001_02)));
        }
    };
    private String urn = null;
    private String file = null;
    private Type type = null;
    private int major = 0;
    private int minor = 0;
    private int order = 0;

    public static PainVersion byURN(String urn) {
        PainVersion test = new PainVersion(0, urn, null);
        if (urn == null || urn.length() == 0) {
            return test;
        }
        for (List<PainVersion> types : knownVersion.values()) {
            for (PainVersion v : types) {
                if (!v.equals(test)) continue;
                return v;
            }
        }
        return test;
    }

    @Deprecated
    public PainVersion(String urn) {
        this(0, urn, null);
    }

    @Deprecated
    public PainVersion(String urn, String file) {
        this(0, urn, file);
    }

    private PainVersion(int order, String urn, String file) {
        Matcher m = PATTERN.matcher(urn);
        if (!m.find() || m.groupCount() != 3) {
            throw new IllegalArgumentException("invalid pain-version: " + urn);
        }
        this.order = order;
        this.urn = urn;
        this.file = file;
        this.type = Type.getType(m.group(1));
        this.major = Integer.parseInt(m.group(2));
        this.minor = Integer.parseInt(m.group(3));
    }

    public String getSchemaLocation() {
        if (this.file == null) {
            return null;
        }
        return this.urn + " " + this.file;
    }

    public String getGeneratorClass(String jobName) {
        StringBuilder sb = new StringBuilder();
        sb.append(ISEPAGenerator.class.getPackage().getName());
        sb.append(".Gen");
        sb.append(jobName);
        sb.append(this.type.getValue());
        sb.append(new DecimalFormat(DF_MAJOR).format(this.major));
        sb.append(new DecimalFormat(DF_MINOR).format(this.minor));
        return sb.toString();
    }

    public String getParserClass() {
        StringBuilder sb = new StringBuilder();
        sb.append(ISEPAParser.class.getPackage().getName());
        sb.append(".ParsePain");
        sb.append(this.type.getValue());
        sb.append(new DecimalFormat(DF_MAJOR).format(this.major));
        sb.append(new DecimalFormat(DF_MINOR).format(this.minor));
        return sb.toString();
    }

    public boolean isSupported(String jobName) {
        try {
            Class.forName(this.getGeneratorClass(jobName));
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Type getType() {
        return this.type;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getURN() {
        return this.urn;
    }

    public String getFile() {
        return this.file;
    }

    public static PainVersion findGreatest(List<PainVersion> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        try {
            Collections.sort(list);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return list.get(list.size() - 1);
    }

    public static List<PainVersion> getKnownVersions(Type t) {
        return knownVersion.get((Object)t);
    }

    public static PainVersion autodetect(InputStream xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xml);
            Node root = doc.getFirstChild();
            if (root == null) {
                throw new IllegalArgumentException("XML data did not contain a root element");
            }
            String uri = root.getNamespaceURI();
            if (uri == null) {
                return null;
            }
            return PainVersion.byURN(uri);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static PainVersion choose(String sepadesc, String sepadata) {
        boolean haveData;
        boolean haveDesc = sepadesc != null && sepadesc.length() > 0;
        boolean bl = haveData = sepadata != null && sepadata.length() > 0;
        if (!haveDesc && !haveData) {
            HBCIUtils.log("neither sepadesr nor sepa data given", 2);
            return null;
        }
        try {
            PainVersion versionDesc = haveDesc ? PainVersion.byURN(sepadesc) : null;
            PainVersion versionData = haveData ? PainVersion.autodetect(new ByteArrayInputStream(sepadata.getBytes("ISO-8859-1"))) : null;
            HBCIUtils.log("pain version given in sepadescr: " + versionDesc, 5);
            HBCIUtils.log("pain version according to data: " + versionData, 5);
            if (versionDesc == null) {
                return versionData;
            }
            if (versionData == null) {
                return versionDesc;
            }
            if (!versionDesc.equals(versionData)) {
                HBCIUtils.log("pain version mismatch. sepadesc: " + versionDesc + " vs. data: " + versionData, 2);
            }
            return versionData;
        }
        catch (UnsupportedEncodingException e) {
            HBCIUtils.log(e);
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PainVersion)) {
            return false;
        }
        PainVersion other = (PainVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public int compareTo(PainVersion v) {
        if (v.type != this.type) {
            throw new IllegalArgumentException("pain-type incompatible: " + (Object)((Object)v.type) + " != " + (Object)((Object)this.type));
        }
        int r = this.order - v.order;
        if (r != 0) {
            return r;
        }
        r = this.major - v.major;
        if (r != 0) {
            return r;
        }
        return this.minor - v.minor;
    }

    public String toString() {
        return this.urn;
    }

    public static enum Type {
        PAIN_001("001", "credit transfer"),
        PAIN_002("002", "payment status"),
        PAIN_008("008", "direct debit");

        private String value = null;
        private String name = null;

        private Type(String value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public static Type getType(String value) throws IllegalArgumentException {
            if (value != null && value.length() > 0) {
                for (Type t : Type.values()) {
                    if (!t.value.equals(value)) continue;
                    return t;
                }
            }
            throw new IllegalArgumentException("unknown PAIN type: " + value);
        }
    }
}

